/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.PlayerMessage;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.audio.MediaCodecAudioRenderer;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.mp4.Mp4Extractor;
import com.google.android.exoplayer2.mediacodec.MediaCodecSelector;
import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultAllocator;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSource;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheDataSource;
import com.google.android.exoplayer2.video.MediaCodecVideoRenderer;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibilityTracker;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.RepeatingHandlerRunnable;
import com.mopub.mobileads.VastTracker;
import com.mopub.mobileads.VastVideoConfig;
import com.mopub.nativeads.MoPubCache;
import com.mopub.network.TrackingRequest;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NativeVideoController
extends Player.DefaultEventListener
implements AudioManager.OnAudioFocusChangeListener {
    @NonNull
    private static final Map<Long, NativeVideoController> sManagerMap = new HashMap<Long, NativeVideoController>(4);
    public static final int STATE_READY = 3;
    public static final int STATE_BUFFERING = 2;
    public static final int STATE_IDLE = 1;
    public static final int STATE_ENDED = 4;
    public static final int STATE_CLEARED = 5;
    public static final long RESUME_FINISHED_THRESHOLD = 750L;
    private static final int BUFFER_SEGMENT_SIZE = 65536;
    private static final int BUFFER_SEGMENT_COUNT = 32;
    @NonNull
    private final Context mContext;
    @NonNull
    private final Handler mHandler;
    @NonNull
    private final MoPubExoPlayerFactory mMoPubExoPlayerFactory;
    @NonNull
    private VastVideoConfig mVastVideoConfig;
    @NonNull
    private NativeVideoProgressRunnable mNativeVideoProgressRunnable;
    @NonNull
    private AudioManager mAudioManager;
    @Nullable
    private Listener mListener;
    @Nullable
    private AudioManager.OnAudioFocusChangeListener mOnAudioFocusChangeListener;
    @Nullable
    private Surface mSurface;
    @Nullable
    private TextureView mTextureView;
    @Nullable
    private WeakReference<Object> mOwnerRef;
    @Nullable
    private volatile ExoPlayer mExoPlayer;
    @Nullable
    private BitmapDrawable mFinalFrame;
    @Nullable
    private MediaCodecAudioRenderer mAudioRenderer;
    @Nullable
    private MediaCodecVideoRenderer mVideoRenderer;
    private boolean mPlayWhenReady;
    private boolean mAudioEnabled;
    private boolean mAppAudioEnabled;
    private int mPreviousExoPlayerState = 1;
    private boolean mExoPlayerStateStartedFromIdle = true;

    @NonNull
    public static NativeVideoController createForId(long id, @NonNull Context context, @NonNull List<VisibilityTrackingEvent> visibilityTrackingEvents, @NonNull VastVideoConfig vastVideoConfig) {
        NativeVideoController nvc = new NativeVideoController(context, visibilityTrackingEvents, vastVideoConfig);
        sManagerMap.put(id, nvc);
        return nvc;
    }

    @NonNull
    @VisibleForTesting
    public static NativeVideoController createForId(long id, @NonNull Context context, @NonNull VastVideoConfig vastVideoConfig, @NonNull NativeVideoProgressRunnable nativeVideoProgressRunnable, @NonNull MoPubExoPlayerFactory moPubExoPlayerFactory, @NonNull AudioManager audioManager) {
        NativeVideoController nvc = new NativeVideoController(context, vastVideoConfig, nativeVideoProgressRunnable, moPubExoPlayerFactory, audioManager);
        sManagerMap.put(id, nvc);
        return nvc;
    }

    @VisibleForTesting
    public static void setForId(long id, @NonNull NativeVideoController nativeVideoController) {
        sManagerMap.put(id, nativeVideoController);
    }

    @Nullable
    public static NativeVideoController getForId(long id) {
        return sManagerMap.get(id);
    }

    @Nullable
    public static NativeVideoController remove(long id) {
        return sManagerMap.remove(id);
    }

    private NativeVideoController(@NonNull Context context, @NonNull List<VisibilityTrackingEvent> visibilityTrackingEvents, @NonNull VastVideoConfig vastVideoConfig) {
        this(context, vastVideoConfig, new NativeVideoProgressRunnable(context, new Handler(Looper.getMainLooper()), visibilityTrackingEvents, vastVideoConfig), new MoPubExoPlayerFactory(), (AudioManager)context.getSystemService("audio"));
    }

    private NativeVideoController(@NonNull Context context, @NonNull VastVideoConfig vastVideoConfig, @NonNull NativeVideoProgressRunnable nativeVideoProgressRunnable, @NonNull MoPubExoPlayerFactory moPubExoPlayerFactory, @NonNull AudioManager audioManager) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)vastVideoConfig);
        Preconditions.checkNotNull((Object)moPubExoPlayerFactory);
        Preconditions.checkNotNull((Object)audioManager);
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mVastVideoConfig = vastVideoConfig;
        this.mNativeVideoProgressRunnable = nativeVideoProgressRunnable;
        this.mMoPubExoPlayerFactory = moPubExoPlayerFactory;
        this.mAudioManager = audioManager;
    }

    public void setListener(@Nullable Listener listener) {
        this.mListener = listener;
    }

    public void setProgressListener(@Nullable NativeVideoProgressRunnable.ProgressListener progressListener) {
        this.mNativeVideoProgressRunnable.setProgressListener(progressListener);
    }

    public void setOnAudioFocusChangeListener(@Nullable AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener) {
        this.mOnAudioFocusChangeListener = onAudioFocusChangeListener;
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        if (this.mPlayWhenReady == playWhenReady) {
            return;
        }
        this.mPlayWhenReady = playWhenReady;
        this.setExoPlayWhenReady();
    }

    public int getPlaybackState() {
        if (this.mExoPlayer == null) {
            return 5;
        }
        return this.mExoPlayer.getPlaybackState();
    }

    public void setAudioEnabled(boolean audioEnabled) {
        this.mAudioEnabled = audioEnabled;
        this.setExoAudio();
    }

    public void setAppAudioEnabled(boolean audioEnabled) {
        if (this.mAppAudioEnabled == audioEnabled) {
            return;
        }
        this.mAppAudioEnabled = audioEnabled;
        if (this.mAppAudioEnabled) {
            this.mAudioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 1);
        } else {
            this.mAudioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
        }
    }

    public void setAudioVolume(float volume) {
        if (!this.mAudioEnabled) {
            return;
        }
        this.setExoAudio(volume);
    }

    public void onAudioFocusChange(int focusChange) {
        if (this.mOnAudioFocusChangeListener == null) {
            return;
        }
        this.mOnAudioFocusChangeListener.onAudioFocusChange(focusChange);
    }

    public void setTextureView(@NonNull TextureView textureView) {
        Preconditions.checkNotNull((Object)textureView);
        this.mSurface = new Surface(textureView.getSurfaceTexture());
        this.mTextureView = textureView;
        this.mNativeVideoProgressRunnable.setTextureView(this.mTextureView);
        this.setExoSurface(this.mSurface);
    }

    public void prepare(@NonNull Object owner) {
        Preconditions.checkNotNull((Object)owner);
        this.mOwnerRef = new WeakReference<Object>(owner);
        this.clearExistingPlayer();
        this.preparePlayer();
        this.setExoSurface(this.mSurface);
    }

    public void clear() {
        this.setPlayWhenReady(false);
        this.mSurface = null;
        this.clearExistingPlayer();
    }

    public void release(@NonNull Object owner) {
        Object object;
        Preconditions.checkNotNull((Object)owner);
        Object v0 = object = this.mOwnerRef == null ? null : this.mOwnerRef.get();
        if (object == owner) {
            this.clearExistingPlayer();
        }
    }

    public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
    }

    public void onLoadingChanged(boolean isLoading) {
    }

    public void onPlayerStateChanged(boolean playWhenReady, int newState) {
        if (newState == 4 && this.mFinalFrame == null) {
            if (this.mExoPlayer == null || this.mSurface == null || this.mTextureView == null) {
                MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"onPlayerStateChanged called afer view has been recycled."});
                return;
            }
            this.mFinalFrame = new BitmapDrawable(this.mContext.getResources(), this.mTextureView.getBitmap());
            this.mNativeVideoProgressRunnable.requestStop();
        }
        this.mPreviousExoPlayerState = newState;
        if (newState == 3) {
            this.mExoPlayerStateStartedFromIdle = false;
        } else if (newState == 1) {
            this.mExoPlayerStateStartedFromIdle = true;
        }
        if (this.mListener != null) {
            this.mListener.onStateChanged(playWhenReady, newState);
        }
    }

    public void seekTo(long ms) {
        if (this.mExoPlayer == null) {
            return;
        }
        this.mExoPlayer.seekTo(ms);
        this.mNativeVideoProgressRunnable.seekTo(ms);
    }

    public long getCurrentPosition() {
        return this.mNativeVideoProgressRunnable.getCurrentPosition();
    }

    public long getDuration() {
        return this.mNativeVideoProgressRunnable.getDuration();
    }

    public void onPlayerError(ExoPlaybackException e) {
        if (this.mListener == null) {
            return;
        }
        this.mListener.onError((Exception)e);
        this.mNativeVideoProgressRunnable.requestStop();
    }

    public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
    }

    public void handleCtaClick(@NonNull Context context) {
        this.triggerImpressionTrackers();
        this.mVastVideoConfig.handleClickWithoutResult(context, 0);
    }

    public boolean hasFinalFrame() {
        return this.mFinalFrame != null;
    }

    @Nullable
    public Drawable getFinalFrame() {
        return this.mFinalFrame;
    }

    void triggerImpressionTrackers() {
        this.mNativeVideoProgressRunnable.checkImpressionTrackers(true);
    }

    private void clearExistingPlayer() {
        if (this.mExoPlayer == null) {
            return;
        }
        this.setExoSurface(null);
        this.mExoPlayer.stop();
        this.mExoPlayer.release();
        this.mExoPlayer = null;
        this.mNativeVideoProgressRunnable.stop();
        this.mNativeVideoProgressRunnable.setExoPlayer(null);
    }

    private void preparePlayer() {
        if (this.mExoPlayer == null) {
            this.mVideoRenderer = new MediaCodecVideoRenderer(this.mContext, MediaCodecSelector.DEFAULT, 0L, this.mHandler, null, 10);
            this.mAudioRenderer = new MediaCodecAudioRenderer(this.mContext, MediaCodecSelector.DEFAULT);
            DefaultAllocator allocator = new DefaultAllocator(true, 65536, 32);
            DefaultLoadControl.Builder defaultLoadControlBuilder = new DefaultLoadControl.Builder();
            defaultLoadControlBuilder.setAllocator(allocator);
            this.mExoPlayer = this.mMoPubExoPlayerFactory.newInstance(this.mContext, new Renderer[]{this.mVideoRenderer, this.mAudioRenderer}, (TrackSelector)new DefaultTrackSelector(), (LoadControl)defaultLoadControlBuilder.createDefaultLoadControl());
            this.mNativeVideoProgressRunnable.setExoPlayer(this.mExoPlayer);
            this.mExoPlayer.addListener((Player.EventListener)this);
            DataSource.Factory dataSourceFactory = new DataSource.Factory(){

                public DataSource createDataSource() {
                    DefaultHttpDataSource dataSource = new DefaultHttpDataSource("exo_demo", null);
                    Cache cache = MoPubCache.getCacheInstance(NativeVideoController.this.mContext);
                    if (cache != null) {
                        dataSource = new CacheDataSource(cache, (DataSource)dataSource);
                    }
                    return dataSource;
                }
            };
            ExtractorsFactory extractorsFactory = new ExtractorsFactory(){

                public Extractor[] createExtractors() {
                    return new Extractor[]{new Mp4Extractor()};
                }
            };
            ExtractorMediaSource.Factory extractorMediaSourceFactory = new ExtractorMediaSource.Factory(dataSourceFactory);
            extractorMediaSourceFactory.setExtractorsFactory(extractorsFactory);
            ExtractorMediaSource mediaSource = extractorMediaSourceFactory.createMediaSource(Uri.parse((String)this.mVastVideoConfig.getNetworkMediaFileUrl()));
            this.mExoPlayer.prepare((MediaSource)mediaSource);
            this.mNativeVideoProgressRunnable.startRepeating(50L);
        }
        this.setExoAudio();
        this.setExoPlayWhenReady();
    }

    private void setExoPlayWhenReady() {
        if (this.mExoPlayer == null) {
            return;
        }
        this.mExoPlayer.setPlayWhenReady(this.mPlayWhenReady);
    }

    private void setExoAudio() {
        this.setExoAudio(this.mAudioEnabled ? 1.0f : 0.0f);
    }

    private void setExoAudio(float volume) {
        ExoPlayer exoPlayer = this.mExoPlayer;
        MediaCodecAudioRenderer audioRenderer = this.mAudioRenderer;
        if (exoPlayer == null || audioRenderer == null) {
            return;
        }
        PlayerMessage playerMessage = exoPlayer.createMessage((PlayerMessage.Target)audioRenderer);
        if (playerMessage == null) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"ExoPlayer.createMessage returned null."});
            return;
        }
        playerMessage.setType(2).setPayload((Object)Float.valueOf(volume)).send();
    }

    private void setExoSurface(@Nullable Surface surface) {
        ExoPlayer exoPlayer = this.mExoPlayer;
        MediaCodecVideoRenderer videoRenderer = this.mVideoRenderer;
        if (exoPlayer == null || videoRenderer == null) {
            return;
        }
        PlayerMessage playerMessage = exoPlayer.createMessage((PlayerMessage.Target)videoRenderer);
        if (playerMessage == null) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"ExoPlayer.createMessage returned null."});
            return;
        }
        playerMessage.setType(1).setPayload((Object)surface).send();
    }

    static class NativeVideoProgressRunnable
    extends RepeatingHandlerRunnable {
        @NonNull
        private final Context mContext;
        @NonNull
        private final VisibilityTracker.VisibilityChecker mVisibilityChecker;
        @NonNull
        private final List<VisibilityTrackingEvent> mVisibilityTrackingEvents;
        @NonNull
        private final VastVideoConfig mVastVideoConfig;
        @Nullable
        private ExoPlayer mExoPlayer;
        @Nullable
        private TextureView mTextureView;
        @Nullable
        private ProgressListener mProgressListener;
        private long mCurrentPosition;
        private long mDuration;
        private boolean mStopRequested;

        NativeVideoProgressRunnable(@NonNull Context context, @NonNull Handler handler, @NonNull List<VisibilityTrackingEvent> visibilityTrackingEvents, @NonNull VastVideoConfig vastVideoConfig) {
            this(context, handler, visibilityTrackingEvents, new VisibilityTracker.VisibilityChecker(), vastVideoConfig);
        }

        @VisibleForTesting
        NativeVideoProgressRunnable(@NonNull Context context, @NonNull Handler handler, @NonNull List<VisibilityTrackingEvent> visibilityTrackingEvents, @NonNull VisibilityTracker.VisibilityChecker visibilityChecker, @NonNull VastVideoConfig vastVideoConfig) {
            super(handler);
            Preconditions.checkNotNull((Object)context);
            Preconditions.checkNotNull((Object)handler);
            Preconditions.checkNotNull(visibilityTrackingEvents);
            Preconditions.checkNotNull((Object)vastVideoConfig);
            this.mContext = context.getApplicationContext();
            this.mVisibilityTrackingEvents = visibilityTrackingEvents;
            this.mVisibilityChecker = visibilityChecker;
            this.mVastVideoConfig = vastVideoConfig;
            this.mDuration = -1L;
            this.mStopRequested = false;
        }

        void setExoPlayer(@Nullable ExoPlayer exoPlayer) {
            this.mExoPlayer = exoPlayer;
        }

        void setTextureView(@Nullable TextureView textureView) {
            this.mTextureView = textureView;
        }

        void setProgressListener(@Nullable ProgressListener progressListener) {
            this.mProgressListener = progressListener;
        }

        void seekTo(long currentPosition) {
            this.mCurrentPosition = currentPosition;
        }

        long getCurrentPosition() {
            return this.mCurrentPosition;
        }

        long getDuration() {
            return this.mDuration;
        }

        void requestStop() {
            this.mStopRequested = true;
        }

        void checkImpressionTrackers(boolean forceTrigger) {
            int trackedCount = 0;
            for (VisibilityTrackingEvent event : this.mVisibilityTrackingEvents) {
                if (event.isTracked) {
                    ++trackedCount;
                    continue;
                }
                if (!forceTrigger && !this.mVisibilityChecker.isVisible((View)this.mTextureView, (View)this.mTextureView, event.minimumPercentageVisible, event.minimumVisiblePx)) continue;
                event.totalQualifiedPlayCounter = (int)((long)event.totalQualifiedPlayCounter + this.mUpdateIntervalMillis);
                if (!forceTrigger && event.totalQualifiedPlayCounter < event.totalRequiredPlayTimeMs) continue;
                event.strategy.execute();
                event.isTracked = true;
                ++trackedCount;
            }
            if (trackedCount == this.mVisibilityTrackingEvents.size() && this.mStopRequested) {
                this.stop();
            }
        }

        public void doWork() {
            List trackers;
            if (this.mExoPlayer == null || !this.mExoPlayer.getPlayWhenReady()) {
                return;
            }
            this.mCurrentPosition = this.mExoPlayer.getCurrentPosition();
            this.mDuration = this.mExoPlayer.getDuration();
            this.checkImpressionTrackers(false);
            if (this.mProgressListener != null) {
                float tenthsOfPercentPlayed = (float)this.mCurrentPosition / (float)this.mDuration * 1000.0f;
                this.mProgressListener.updateProgress((int)tenthsOfPercentPlayed);
            }
            if (!(trackers = this.mVastVideoConfig.getUntriggeredTrackersBefore((int)this.mCurrentPosition, (int)this.mDuration)).isEmpty()) {
                ArrayList<String> trackingUrls = new ArrayList<String>();
                for (VastTracker tracker : trackers) {
                    if (tracker.isTracked()) continue;
                    trackingUrls.add(tracker.getContent());
                    tracker.setTracked();
                }
                TrackingRequest.makeTrackingHttpRequest(trackingUrls, (Context)this.mContext);
            }
        }

        @Deprecated
        @VisibleForTesting
        void setUpdateIntervalMillis(long updateIntervalMillis) {
            this.mUpdateIntervalMillis = updateIntervalMillis;
        }

        public static interface ProgressListener {
            public void updateProgress(int var1);
        }
    }

    static class VisibilityTrackingEvent {
        OnTrackedStrategy strategy;
        int minimumPercentageVisible;
        int totalRequiredPlayTimeMs;
        int totalQualifiedPlayCounter;
        boolean isTracked;
        Integer minimumVisiblePx;

        VisibilityTrackingEvent() {
        }

        static interface OnTrackedStrategy {
            public void execute();
        }
    }

    @VisibleForTesting
    static class MoPubExoPlayerFactory {
        MoPubExoPlayerFactory() {
        }

        public ExoPlayer newInstance(@NonNull Context context, @NonNull Renderer[] renderers, @NonNull TrackSelector trackSelector, @Nullable LoadControl loadControl) {
            return ExoPlayerFactory.newInstance((Context)context, (Renderer[])renderers, (TrackSelector)trackSelector, (LoadControl)loadControl);
        }
    }

    public static interface Listener {
        public void onStateChanged(boolean var1, int var2);

        public void onError(Exception var1);
    }
}

