/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.actions;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.appboy.ui.AppboyWebViewActivity;
import com.appboy.ui.actions.IAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class WebAction
implements IAction {
    private final String mTargetUrl;
    private final Bundle mExtras;
    private static final List<String> sSupportedSchemes = Collections.unmodifiableList(Arrays.asList("http", "https", "ftp", "ftps", "about", "javascript"));

    public WebAction(String targetUrl) {
        this(targetUrl, null);
    }

    public WebAction(String targetUrl, Bundle extras) {
        this.mTargetUrl = targetUrl;
        this.mExtras = extras;
    }

    @Override
    public void execute(Context context) {
        Intent intent = new Intent(context, AppboyWebViewActivity.class);
        if (this.mExtras != null) {
            intent.putExtras(this.mExtras);
        }
        intent.putExtra("url", this.mTargetUrl);
        context.startActivity(intent);
    }

    public static List<String> getSupportedSchemes() {
        return sSupportedSchemes;
    }
}

