/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.widget;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import com.appboy.models.cards.BannerImageCard;
import com.appboy.support.AppboyLogger;
import com.appboy.ui.R;
import com.appboy.ui.actions.ActionFactory;
import com.appboy.ui.actions.IAction;
import com.appboy.ui.widget.BaseCardView;
import com.facebook.drawee.view.SimpleDraweeView;

public class BannerImageCardView
extends BaseCardView<BannerImageCard> {
    private ImageView mImage;
    private IAction mCardAction;
    private SimpleDraweeView mDrawee;
    private static final String TAG = String.format("%s.%s", "Appboy", BannerImageCardView.class.getName());
    private float mAspectRatio = 6.0f;

    public BannerImageCardView(Context context) {
        this(context, null);
    }

    public BannerImageCardView(Context context, BannerImageCard card) {
        super(context);
        if (this.canUseFresco()) {
            this.mDrawee = (SimpleDraweeView)this.getProperViewFromInflatedStub(R.id.com_appboy_banner_image_card_drawee_stub);
        } else {
            this.mImage = (ImageView)this.getProperViewFromInflatedStub(R.id.com_appboy_banner_image_card_imageview_stub);
            this.mImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
            this.mImage.setAdjustViewBounds(true);
        }
        if (card != null) {
            this.setCard(card);
        }
        this.safeSetBackground(this.getResources().getDrawable(R.drawable.com_appboy_card_background));
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.com_appboy_banner_image_card;
    }

    @Override
    public void onSetCard(final BannerImageCard card) {
        boolean respectAspectRatio = false;
        if (card.getAspectRatio() != 0.0f) {
            this.mAspectRatio = card.getAspectRatio();
            respectAspectRatio = true;
        }
        if (this.canUseFresco()) {
            this.setSimpleDraweeToUrl(this.mDrawee, card.getImageUrl(), this.mAspectRatio, respectAspectRatio);
        } else {
            this.setImageViewToUrl(this.mImage, card.getImageUrl(), this.mAspectRatio, respectAspectRatio);
        }
        this.mCardAction = ActionFactory.createUriAction(this.getContext(), card.getUrl());
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BannerImageCardView.this.mCardAction != null) {
                    AppboyLogger.d((String)TAG, (String)String.format("Logged click for card %s", card.getId()));
                    card.logClick();
                    BannerImageCardView.this.mCardAction.execute(BannerImageCardView.this.mContext);
                }
            }
        });
    }
}

