/*
 * Decompiled with CFR 0.152.
 */
package com.appboy;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Environment;
import com.appboy.Constants;
import com.appboy.support.AppboyLogger;
import com.appboy.support.PermissionUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

public class AppboyImageUtils {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, AppboyImageUtils.class.getName());
    public static final int BASELINE_SCREEN_DPI = 160;

    public static Bitmap downloadImageBitmap(String imageUrl) {
        if (imageUrl == null || imageUrl.length() == 0) {
            AppboyLogger.i((String)TAG, (String)"Null or empty Url string passed to image bitmap download. Not attempting download.");
            return null;
        }
        Bitmap bitmap = null;
        try {
            InputStream inputStream = new URL(imageUrl).openStream();
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (OutOfMemoryError e) {
            AppboyLogger.e((String)TAG, (String)String.format("Out of Memory Error in image bitmap download for Url: %s.", imageUrl), (Throwable)e);
        }
        catch (UnknownHostException e) {
            AppboyLogger.e((String)TAG, (String)String.format("Unknown Host Exception in image bitmap download for Url: %s. Device may be offline.", imageUrl), (Throwable)e);
        }
        catch (MalformedURLException e) {
            AppboyLogger.e((String)TAG, (String)String.format("Malformed URL Exception in image bitmap download for Url: %s. Image Url may be corrupted.", imageUrl), (Throwable)e);
        }
        catch (Exception e) {
            AppboyLogger.e((String)TAG, (String)String.format("Exception in image bitmap download for Url: %s", imageUrl), (Throwable)e);
        }
        return bitmap;
    }

    public static int getPixelsFromDensityAndDp(int dpi, int dp) {
        return dpi * dp / 160;
    }

    public static Uri storeBitmapLocally(Context context, Bitmap imageBitmap, String imageFilenameBase, String folderName) {
        if (context == null) {
            AppboyLogger.w((String)TAG, (String)"Received null context. Doing nothing.");
            return null;
        }
        if (imageBitmap == null) {
            AppboyLogger.w((String)TAG, (String)"Received null bitmap. Doing nothing.");
            return null;
        }
        if (imageFilenameBase == null) {
            AppboyLogger.w((String)TAG, (String)"Received null image filename base. Doing nothing.");
            return null;
        }
        if (folderName == null) {
            AppboyLogger.w((String)TAG, (String)"Received null image folder name. Doing nothing.");
            return null;
        }
        try {
            String imageStoragePath = Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + folderName;
            File imageStorageDirectory = new File(imageStoragePath);
            if (!imageStorageDirectory.exists()) {
                imageStorageDirectory.mkdirs();
            }
            File imageFile = new File(imageStorageDirectory, imageFilenameBase + ".png");
            AppboyLogger.d((String)TAG, (String)("Storing image locally at " + imageFile.getAbsolutePath()));
            FileOutputStream fileOutputStream = new FileOutputStream(imageFile);
            imageBitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
            MediaScannerConnection.scanFile((Context)context, (String[])new String[]{imageFile.getAbsolutePath()}, null, null);
            return Uri.fromFile((File)imageFile);
        }
        catch (Exception e) {
            AppboyLogger.e((String)TAG, (String)"Exception occurred when attempting to store image locally.", (Throwable)e);
            return null;
        }
    }

    public static boolean isWriteExternalPermissionGranted(Context context) {
        return context != null && PermissionUtils.hasPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
    }
}

