/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.inappmessage;

import android.net.Uri;
import android.os.Bundle;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.appboy.Constants;
import com.appboy.models.IInAppMessage;
import com.appboy.support.AppboyLogger;
import com.appboy.ui.inappmessage.listeners.IInAppMessageWebViewClientListener;
import com.appboy.ui.support.StringUtils;
import com.appboy.ui.support.UriUtils;
import java.util.Map;

public class InAppMessageWebViewClient
extends WebViewClient {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, InAppMessageWebViewClient.class.getName());
    private static final String APPBOY_INAPP_MESSAGE_SCHEME = "appboy";
    private static final String AUTHORITY_NAME_CLOSE = "close";
    private static final String AUTHORITY_NAME_NEWSFEED = "feed";
    private static final String AUTHORITY_NAME_CUSTOM_EVENT = "customEvent";
    public static final String QUERY_NAME_BUTTON_ID = "abButtonId";
    public static final String QUERY_NAME_EXTERNAL_OPEN = "abExternalOpen";
    private IInAppMessageWebViewClientListener mInAppMessageWebViewClientListener;
    private final IInAppMessage mInAppMessage;

    public InAppMessageWebViewClient(IInAppMessage inAppMessage, IInAppMessageWebViewClientListener inAppMessageWebViewClientListener) {
        this.mInAppMessageWebViewClientListener = inAppMessageWebViewClientListener;
        this.mInAppMessage = inAppMessage;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (this.mInAppMessageWebViewClientListener == null) {
            AppboyLogger.i((String)TAG, (String)"InAppMessageWebViewClient was given null IInAppMessageWebViewClientListener listener. Returning true.");
            return true;
        }
        if (StringUtils.isNullOrBlank(url)) {
            AppboyLogger.i((String)TAG, (String)"InAppMessageWebViewClient.shouldOverrideUrlLoading was given null or blank url. Returning true.");
            return true;
        }
        Uri uri = Uri.parse((String)url);
        Bundle queryBundle = InAppMessageWebViewClient.getBundleFromUrl(url);
        if (uri.getScheme().equals(APPBOY_INAPP_MESSAGE_SCHEME)) {
            String authority = uri.getAuthority();
            if (authority.equals(AUTHORITY_NAME_CLOSE)) {
                this.mInAppMessageWebViewClientListener.onCloseAction(this.mInAppMessage, url, queryBundle);
            } else if (authority.equals(AUTHORITY_NAME_NEWSFEED)) {
                this.mInAppMessageWebViewClientListener.onNewsfeedAction(this.mInAppMessage, url, queryBundle);
            } else if (authority.equals(AUTHORITY_NAME_CUSTOM_EVENT)) {
                this.mInAppMessageWebViewClientListener.onCustomEventAction(this.mInAppMessage, url, queryBundle);
            }
            return true;
        }
        this.mInAppMessageWebViewClientListener.onOtherUrlAction(this.mInAppMessage, url, queryBundle);
        return true;
    }

    static Bundle getBundleFromUrl(String url) {
        Bundle queryBundle = new Bundle();
        if (StringUtils.isNullOrBlank(url)) {
            return queryBundle;
        }
        Uri uri = Uri.parse((String)url);
        Map<String, String> queryParameterMap = UriUtils.getQueryParameters(uri);
        for (String queryKeyName : queryParameterMap.keySet()) {
            String queryValue = queryParameterMap.get(queryKeyName);
            queryBundle.putString(queryKeyName, queryValue);
        }
        return queryBundle;
    }
}

