/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.support;

import android.net.Uri;
import com.appboy.Constants;
import com.appboy.support.AppboyLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UriUtils {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, UriUtils.class.getName());

    public static Map<String, String> getQueryParameters(Uri uri) {
        int end;
        if (uri.isOpaque()) {
            AppboyLogger.d((String)TAG, (String)"URI is not hierarchical. There are no query parameters to parse.");
            return Collections.emptyMap();
        }
        String query = uri.getEncodedQuery();
        if (query == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        int start = 0;
        do {
            int next;
            end = (next = query.indexOf(38, start)) == -1 ? query.length() : next;
            int separator = query.indexOf(61, start);
            if (separator > end || separator == -1) {
                separator = end;
            }
            if (end <= start) continue;
            String name = query.substring(start, separator);
            String value = query.substring(separator + 1, end);
            parameters.put(Uri.decode((String)name), Uri.decode((String)value));
        } while ((start = end + 1) < query.length());
        return Collections.unmodifiableMap(parameters);
    }
}

