/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.support;

import com.appboy.Constants;
import com.appboy.models.IInAppMessageHtml;
import com.appboy.support.AppboyLogger;
import com.appboy.ui.support.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class WebContentUtils {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, WebContentUtils.class.getName());
    private static final String FILE_URI_SCHEME_PREFIX = "file://";
    private static final int ZIP_UNPACK_BYTE_BUFFER_LENGTH = 8192;
    static final String HTML_INAPP_MESSAGES_FOLDER_NAME = "appboy-html-inapp-messages";

    public static String getLocalHtmlUrlFromRemoteUrl(File localCacheDirectory, String remoteZipUrl) {
        if (localCacheDirectory == null) {
            AppboyLogger.w((String)TAG, (String)"Internal cache directory is null. No local URL will be created.");
            return null;
        }
        if (StringUtils.isNullOrBlank(remoteZipUrl)) {
            AppboyLogger.w((String)TAG, (String)"Remote zip url is null or empty. No local URL will be created.");
            return null;
        }
        WebContentUtils.clearEntireHtmlInAppMessageCache(localCacheDirectory);
        String appboyHtmlInAppMessagesFolder = localCacheDirectory.getAbsolutePath() + "/" + HTML_INAPP_MESSAGES_FOLDER_NAME;
        String inappMessageIdentifier = String.valueOf(System.currentTimeMillis());
        String unpackDirectoryPath = appboyHtmlInAppMessagesFolder + "/" + inappMessageIdentifier;
        AppboyLogger.d((String)TAG, (String)("Starting download of url: " + remoteZipUrl));
        File zipFile = WebContentUtils.downloadFileToPath(unpackDirectoryPath, remoteZipUrl, inappMessageIdentifier);
        if (zipFile == null) {
            AppboyLogger.d((String)TAG, (String)"Could not download zip file to local storage.");
            WebContentUtils.deleteFileOrDirectory(new File(unpackDirectoryPath));
            return null;
        }
        AppboyLogger.d((String)TAG, (String)"Html content zip downloaded.");
        boolean unpackSuccessful = WebContentUtils.unpackZipIntoDirectory(unpackDirectoryPath, zipFile);
        if (!unpackSuccessful) {
            AppboyLogger.w((String)TAG, (String)"Error during the zip unpack.");
            WebContentUtils.deleteFileOrDirectory(new File(unpackDirectoryPath));
            return null;
        }
        AppboyLogger.d((String)TAG, (String)"Html content zip unpacked.");
        return FILE_URI_SCHEME_PREFIX + unpackDirectoryPath + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File downloadFileToPath(String downloadDirectoryAbsolutePath, String zipFileUrl, String outputFilename) {
        if (StringUtils.isNullOrBlank(downloadDirectoryAbsolutePath)) {
            AppboyLogger.i((String)TAG, (String)"Download directory null or blank. Zip file not downloaded.");
            return null;
        }
        if (StringUtils.isNullOrBlank(zipFileUrl)) {
            AppboyLogger.i((String)TAG, (String)"Zip file url null or blank. Zip file not downloaded.");
            return null;
        }
        if (StringUtils.isNullOrBlank(outputFilename)) {
            AppboyLogger.i((String)TAG, (String)"Output filename null or blank. Zip file not downloaded.");
            return null;
        }
        File downloadDir = new File(downloadDirectoryAbsolutePath);
        downloadDir.mkdirs();
        File outputFile = new File(downloadDirectoryAbsolutePath, outputFilename + ".zip");
        HttpURLConnection urlConnection = null;
        FilterInputStream dataInputStream = null;
        FilterOutputStream bufferedOutputStream = null;
        try {
            URL url = new URL(zipFileUrl);
            urlConnection = (HttpURLConnection)url.openConnection();
            int responseCode = urlConnection.getResponseCode();
            if (responseCode != 200) {
                AppboyLogger.d((String)TAG, (String)String.format("HTTP response code was %s. Zip file with url %s could not be downloaded.", responseCode, zipFileUrl));
                File file = null;
                return file;
            }
            int contentLength = urlConnection.getContentLength();
            if (contentLength == -1) {
                AppboyLogger.d((String)TAG, (String)String.format("Content length to the zip file could not be set. Zip file with url %s could not be downloaded.", zipFileUrl));
                File e = null;
                return e;
            }
            byte[] byteBuffer = new byte[contentLength];
            dataInputStream = new DataInputStream(url.openStream());
            ((DataInputStream)dataInputStream).readFully(byteBuffer);
            dataInputStream.close();
            urlConnection.disconnect();
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
            bufferedOutputStream.write(byteBuffer);
            bufferedOutputStream.close();
        }
        catch (MalformedURLException e) {
            AppboyLogger.e((String)TAG, (String)"MalformedURLException during download of zip file from url.", (Throwable)e);
            File file = null;
            return file;
        }
        catch (IOException e) {
            AppboyLogger.e((String)TAG, (String)"IOException during download of zip file from url.", (Throwable)e);
            File file = null;
            return file;
        }
        catch (Exception e) {
            AppboyLogger.e((String)TAG, (String)"Exception during download of zip file from url.", (Throwable)e);
            File file = null;
            return file;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            try {
                if (dataInputStream != null) {
                    dataInputStream.close();
                }
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.close();
                }
            }
            catch (IOException e) {
                AppboyLogger.e((String)TAG, (String)"IOException during closing of zip file download streams.", (Throwable)e);
            }
        }
        return outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean unpackZipIntoDirectory(String unpackDirectory, File zipFile) {
        if (StringUtils.isNullOrBlank(unpackDirectory)) {
            AppboyLogger.i((String)TAG, (String)"Unpack directory null or blank. Zip file not unpacked.");
            return false;
        }
        if (zipFile == null) {
            AppboyLogger.i((String)TAG, (String)"Zip file is null. Zip file not unpacked.");
            return false;
        }
        File unpackDir = new File(unpackDirectory);
        unpackDir.mkdirs();
        ZipInputStream zipInputStream = null;
        FilterOutputStream bufferedOutputStream = null;
        try {
            ZipEntry zipEntry;
            FileInputStream fileInputStream = new FileInputStream(zipFile);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            zipInputStream = new ZipInputStream(bufferedInputStream);
            byte[] buffer = new byte[8192];
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int byteCount;
                String entryFilename = zipEntry.getName();
                if (entryFilename.toLowerCase().startsWith("__macosx")) continue;
                String absoluteEntryPath = unpackDirectory + "/" + entryFilename;
                if (zipEntry.isDirectory()) {
                    File zipEntryFile = new File(absoluteEntryPath);
                    zipEntryFile.mkdirs();
                    continue;
                }
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(absoluteEntryPath));
                while ((byteCount = zipInputStream.read(buffer)) != -1) {
                    ((BufferedOutputStream)bufferedOutputStream).write(buffer, 0, byteCount);
                }
                bufferedOutputStream.close();
                zipInputStream.closeEntry();
            }
            zipInputStream.close();
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            AppboyLogger.e((String)TAG, (String)"FileNotFoundException during unpack of zip file.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            AppboyLogger.e((String)TAG, (String)"IOException during unpack of zip file.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            AppboyLogger.e((String)TAG, (String)"Exception during unpack of zip file.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.close();
                }
            }
            catch (IOException e) {
                AppboyLogger.e((String)TAG, (String)"IOException during closing of zip file unpacking streams.", (Throwable)e);
            }
        }
    }

    public static void clearEntireHtmlInAppMessageCache(File localCacheDirectory) {
        AppboyLogger.d((String)TAG, (String)"Deleting Html In App Messages folder");
        File appboyHtmlCacheDirectory = new File(localCacheDirectory, HTML_INAPP_MESSAGES_FOLDER_NAME);
        WebContentUtils.deleteFileOrDirectory(appboyHtmlCacheDirectory);
    }

    public static void clearInAppMessageLocalAssets(IInAppMessageHtml inAppMessage) {
        if (inAppMessage == null) {
            AppboyLogger.d((String)TAG, (String)"Could not clear InAppMessage Local Assets for a null IInAppMessageHtml. Doing nothing.");
            return;
        }
        String localDirectoryPath = inAppMessage.getLocalAssetsDirectoryUrl();
        if (StringUtils.isNullOrBlank(localDirectoryPath)) {
            AppboyLogger.d((String)TAG, (String)"IInAppMessageHtml has null local assets file url. Doing nothing.");
            return;
        }
        int startIndex = FILE_URI_SCHEME_PREFIX.length();
        int endIndex = localDirectoryPath.length() - 1;
        String assetsDirectoryAbsolutePath = localDirectoryPath.substring(startIndex, endIndex);
        AppboyLogger.d((String)TAG, (String)("Deleting local html assets with path: " + assetsDirectoryAbsolutePath));
        WebContentUtils.deleteFileOrDirectory(new File(assetsDirectoryAbsolutePath));
    }

    static void deleteFileOrDirectory(File fileOrDirectory) {
        if (fileOrDirectory == null || !fileOrDirectory.exists()) {
            return;
        }
        if (fileOrDirectory.isDirectory()) {
            for (String childFileName : fileOrDirectory.list()) {
                WebContentUtils.deleteFileOrDirectory(new File(fileOrDirectory, childFileName));
            }
        }
        fileOrDirectory.delete();
    }
}

