/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.configuration;

import android.content.Context;
import android.content.pm.PackageManager;
import bo.app.ct;
import bo.app.er;
import bo.app.n;
import com.appboy.Constants;
import com.appboy.configuration.CachedConfigurationProvider;
import com.appboy.support.AppboyLogger;
import com.appboy.support.PackageUtils;
import java.util.Locale;

public class XmlAppConfigurationProvider
extends CachedConfigurationProvider {
    private static final String a = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, XmlAppConfigurationProvider.class.getName());
    private final Context b;

    /*
     * WARNING - void declaration
     */
    public XmlAppConfigurationProvider(Context context) {
        super(context);
        void var1_1;
        this.b = var1_1;
    }

    public String getBaseUrlForRequests() {
        if ("STAGING".equals(this.getStringValue("com_appboy_server_target", "PROD").toUpperCase(Locale.US))) {
            return "https://sondheim.appboy.com/api/v2/";
        }
        return "https://dev.appboy.com/api/v2/";
    }

    public String getAppboyApiKeyStringFromLocaleMapping(Locale localeToMatch) {
        if (localeToMatch == null) {
            return null;
        }
        String[] stringArray = this.readStringArrayResourceValue("com_appboy_locale_api_key_map", null);
        if (stringArray == null) {
            return null;
        }
        for (String string2 : stringArray) {
            String[] stringArray2;
            if (er.a(string2, ",") != 1 || (stringArray2 = string2.split(",")).length != 2) continue;
            String string3 = stringArray2[0].trim().toLowerCase();
            boolean bl2 = string3.equals(localeToMatch.toString().toLowerCase());
            if (!string3.equals(localeToMatch.getCountry().toLowerCase()) && !bl2) continue;
            return stringArray2[1].trim();
        }
        return null;
    }

    public ct getAppboyApiKey() {
        ct ct2 = (ct)this.mConfigurationCache.get("com_appboy_api_key");
        if (ct2 == null) {
            String string2 = this.b.getSharedPreferences("com_appboy_override_configuration_cache", 0).getString("com_appboy_api_key", null);
            if (string2 != null) {
                AppboyLogger.i(a, "Found an override api key.  Using it to configure Appboy.");
            } else {
                string2 = this.getAppboyApiKeyStringFromLocaleMapping(Locale.getDefault());
                if (string2 != null) {
                    AppboyLogger.i(a, "Found a locale that matches the current locale in appboy.xml.  Using the associated api key");
                } else {
                    string2 = this.readStringResourceValue("com_appboy_api_key", null);
                }
            }
            if (string2 != null) {
                ct2 = new ct(string2);
                this.mConfigurationCache.put("com_appboy_api_key", ct2);
            }
        }
        if (ct2 == null) {
            AppboyLogger.e(a, "****************************************************");
            AppboyLogger.e(a, "**                                                **");
            AppboyLogger.e(a, "**                 !! WARNING !!                  **");
            AppboyLogger.e(a, "**                                                **");
            AppboyLogger.e(a, "**     No API key set in res/values/appboy.xml    **");
            AppboyLogger.e(a, "** No cached API Key found from Appboy.configure  **");
            AppboyLogger.e(a, "**         Appboy functionality disabled          **");
            AppboyLogger.e(a, "**                                                **");
            AppboyLogger.e(a, "****************************************************");
            throw new RuntimeException("Unable to read the Appboy API key from the res/values/appboy.xml file. See log for more details.");
        }
        return ct2;
    }

    public boolean isGcmMessagingRegistrationEnabled() {
        return this.getBooleanValue("com_appboy_push_gcm_messaging_registration_enabled", false);
    }

    public boolean isAdmMessagingRegistrationEnabled() {
        return this.getBooleanValue("com_appboy_push_adm_messaging_registration_enabled", false);
    }

    public boolean isLocationCollectionEnabled() {
        return !this.getBooleanValue("com_appboy_disable_location_collection", false);
    }

    public boolean isBackgroundLocationCollectionEnabled() {
        return this.getBooleanValue("com_appboy_enable_background_location_collection", false);
    }

    public long getLocationUpdateTimeIntervalInMillis() {
        return 1000L * (long)this.getIntValue("com_appboy_location_update_time_interval", -1);
    }

    public float getLocationUpdateDistanceInMeters() {
        return this.getIntValue("com_appboy_location_update_distance", -1);
    }

    public int getSmallNotificationIconResourceId() {
        return this.a(n.a);
    }

    public int getLargeNotificationIconResourceId() {
        return this.a(n.b);
    }

    private int a(n object) {
        Object object2 = object = object.equals((Object)n.b) ? "com_appboy_push_large_notification_icon" : "com_appboy_push_small_notification_icon";
        if (this.mConfigurationCache.containsKey(object)) {
            return (Integer)this.mConfigurationCache.get(object);
        }
        int n2 = this.b.getResources().getIdentifier((String)object, "drawable", PackageUtils.getResourcePackageName(this.b));
        this.mConfigurationCache.put(object, n2);
        return n2;
    }

    public int getSessionTimeoutSeconds() {
        return this.getIntValue("com_appboy_session_timeout", 10);
    }

    public int getVersionCode() {
        int n2;
        if (this.mConfigurationCache.containsKey("version_code")) {
            return (Integer)this.mConfigurationCache.get("version_code");
        }
        try {
            String string2 = PackageUtils.getResourcePackageName(this.b);
            n2 = this.b.getPackageManager().getPackageInfo((String)string2, (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            AppboyLogger.e(a, "Unable to read the version code.");
            n2 = -1;
        }
        this.mConfigurationCache.put("version_code", n2);
        return n2;
    }

    public String getGcmSenderId() {
        return this.getStringValue("com_appboy_push_gcm_sender_id", null);
    }

    public int getApplicationIconResourceId() {
        if (this.mConfigurationCache.containsKey("application_icon")) {
            return (Integer)this.mConfigurationCache.get("application_icon");
        }
        String string2 = this.b.getPackageName();
        int n2 = 0;
        try {
            n2 = this.b.getPackageManager().getApplicationInfo((String)string2, (int)0).icon;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            AppboyLogger.e(a, String.format("Cannot find package named %s", string2));
            try {
                n2 = this.b.getPackageManager().getApplicationInfo((String)this.b.getPackageName(), (int)0).icon;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException2) {
                AppboyLogger.e(a, String.format("Cannot find package named %s", string2));
            }
        }
        this.mConfigurationCache.put("application_icon", n2);
        return n2;
    }

    public int getDefaultNotificationAccentColor() {
        return this.getIntValue("com_appboy_default_notification_accent_color", 0);
    }
}

