/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.models.cards;

import bo.app.by;
import bo.app.cu;
import bo.app.ed;
import bo.app.ee;
import bo.app.em;
import bo.app.ep;
import bo.app.er;
import com.appboy.enums.CardCategory;
import com.appboy.models.IPutIntoJson;
import com.appboy.support.AppboyLogger;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import org.json.JSONArray;
import org.json.JSONObject;

public class Card
extends Observable
implements IPutIntoJson<JSONObject> {
    private static final String j = String.format("%s.%s", "Appboy", Card.class.getName());
    public static final String ID = "id";
    public static final String VIEWED = "viewed";
    public static final String CREATED = "created";
    public static final String UPDATED = "updated";
    public static final String EXPIRES_AT = "expires_at";
    public static final String CATEGORIES = "categories";
    public static final long DEFAULT_EXPIRES_AT = -1L;
    protected final JSONObject a;
    protected final Map<String, String> b;
    protected final String c;
    protected boolean d;
    protected boolean e;
    protected final long f;
    protected final long g;
    protected final long h;
    protected final EnumSet<CardCategory> i;
    private final by k;
    private final ed l;

    /*
     * WARNING - void declaration
     */
    public Card(JSONObject jsonObject) {
        this((JSONObject)var1_1, null, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Card(JSONObject object, by manager, ed storageProvider) {
        JSONArray jSONArray;
        CardCategory cardCategory;
        void var2_2;
        this.a = object;
        this.b = ep.a(object.optJSONObject("extras"), new HashMap<String, String>());
        this.k = var2_2;
        this.l = cardCategory;
        this.c = object.getString(ID);
        this.e = this.d = object.getBoolean(VIEWED);
        this.f = object.getLong(CREATED);
        this.g = object.getLong(UPDATED);
        this.h = object.optLong(EXPIRES_AT, -1L);
        jSONArray = jSONArray.optJSONArray(CATEGORIES);
        if (jSONArray == null || jSONArray.length() == 0) {
            this.i = EnumSet.of(CardCategory.NO_CATEGORY);
            return;
        }
        this.i = EnumSet.noneOf(CardCategory.class);
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            cardCategory = CardCategory.get(jSONArray.getString(i2));
            if (cardCategory == null) continue;
            this.i.add(cardCategory);
        }
    }

    public boolean logImpression() {
        try {
            if (this.k != null && this.l != null && this.a()) {
                this.k.a(cu.c(this.c));
                this.l.a(this.c);
                return true;
            }
        }
        catch (Exception exception) {
            AppboyLogger.w(j, "Failed to log feed card impression.", exception);
        }
        return false;
    }

    public boolean logClick() {
        try {
            if (this.k != null && this.a()) {
                this.k.a(cu.d(this.c));
                return true;
            }
        }
        catch (Exception exception) {
            AppboyLogger.w(j, "Failed to log feed card clicked.", exception);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEqualToCard(Card card) {
        void var1_1;
        return this.c.equals(card.getId()) && this.g == card.getUpdated() && this.k == var1_1.k;
    }

    public String getId() {
        return this.c;
    }

    public Map<String, String> getExtras() {
        return this.b;
    }

    public boolean getViewed() {
        return this.d;
    }

    /*
     * WARNING - void declaration
     */
    public void setViewed(boolean viewed) {
        void var1_1;
        this.d = var1_1;
    }

    public boolean isRead() {
        return this.e;
    }

    /*
     * WARNING - void declaration
     */
    public void setIsRead(boolean read) {
        void var1_1;
        this.e = read;
        this.setChanged();
        this.notifyObservers();
        if (var1_1 != false) {
            try {
                String string2 = this.c;
                ed ed2 = this.l;
                if (!ed2.d.contains(string2)) {
                    ed2.d.add(string2);
                    ed2.a(ed2.d, ee.a);
                }
                return;
            }
            catch (Exception exception) {
            }
        }
    }

    public long getCreated() {
        return this.f;
    }

    public long getUpdated() {
        return this.g;
    }

    public long getExpiresAt() {
        return this.h;
    }

    public boolean isExpired() {
        return this.getExpiresAt() != -1L && this.getExpiresAt() <= em.a();
    }

    public EnumSet<CardCategory> getCategories() {
        return this.i;
    }

    public boolean isInCategorySet(EnumSet<CardCategory> categories) {
        for (CardCategory cardCategory : categories) {
            if (!this.i.contains((Object)cardCategory)) continue;
            return true;
        }
        return false;
    }

    private boolean a() {
        if (er.c(this.c)) {
            AppboyLogger.e(j, "Card ID cannot be null");
            return false;
        }
        return true;
    }

    @Override
    public JSONObject forJsonPut() {
        return this.a;
    }
}

