/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import com.appboy.Appboy;
import com.appboy.support.ValidationUtils;
import com.appboy.ui.R;
import com.appboy.ui.support.StringUtils;

public class AppboyFeedbackFragment
extends Fragment {
    private Button mCancelButton;
    private Button mSendButton;
    private CheckBox mIsBugCheckBox;
    private EditText mMessageEditText;
    private EditText mEmailEditText;
    private TextWatcher mSendButtonWatcher;
    private View.OnClickListener mCancelListener;
    private View.OnClickListener mSendListener;
    private FeedbackFinishedListener mFeedbackFinishedListener;
    private int mOriginalSoftInputMode;
    private boolean mErrorMessageShown;

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mSendButtonWatcher = new TextWatcher(){

            public void beforeTextChanged(CharSequence sequence, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence sequence, int start, int before, int count) {
            }

            public void afterTextChanged(Editable sequence) {
                if (AppboyFeedbackFragment.this.mErrorMessageShown) {
                    AppboyFeedbackFragment.this.ensureSendButton();
                }
            }
        };
        this.mCancelListener = new View.OnClickListener(){

            public void onClick(View view) {
                AppboyFeedbackFragment.this.hideSoftKeyboard();
                if (AppboyFeedbackFragment.this.mFeedbackFinishedListener != null) {
                    AppboyFeedbackFragment.this.mFeedbackFinishedListener.onFeedbackFinished(FeedbackResult.CANCELLED);
                }
                AppboyFeedbackFragment.this.clearData();
            }
        };
        this.mSendListener = new View.OnClickListener(){

            public void onClick(View view) {
                if (AppboyFeedbackFragment.this.ensureSendButton()) {
                    AppboyFeedbackFragment.this.hideSoftKeyboard();
                    boolean isBug = AppboyFeedbackFragment.this.mIsBugCheckBox.isChecked();
                    String message = AppboyFeedbackFragment.this.mMessageEditText.getText().toString();
                    String email = AppboyFeedbackFragment.this.mEmailEditText.getText().toString();
                    if (AppboyFeedbackFragment.this.mFeedbackFinishedListener != null) {
                        message = AppboyFeedbackFragment.this.mFeedbackFinishedListener.beforeFeedbackSubmitted(message);
                    }
                    boolean result = Appboy.getInstance((Context)AppboyFeedbackFragment.this.getActivity()).submitFeedback(email, message, isBug);
                    if (AppboyFeedbackFragment.this.mFeedbackFinishedListener != null) {
                        AppboyFeedbackFragment.this.mFeedbackFinishedListener.onFeedbackFinished(result ? FeedbackResult.SENT : FeedbackResult.ERROR);
                    }
                    AppboyFeedbackFragment.this.clearData();
                } else {
                    AppboyFeedbackFragment.this.mErrorMessageShown = true;
                }
            }
        };
        this.setRetainInstance(true);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup container, Bundle savedInstanceState) {
        View view = layoutInflater.inflate(R.layout.com_appboy_feedback, container, false);
        this.mCancelButton = (Button)view.findViewById(R.id.com_appboy_feedback_cancel);
        this.mSendButton = (Button)view.findViewById(R.id.com_appboy_feedback_send);
        this.mIsBugCheckBox = (CheckBox)view.findViewById(R.id.com_appboy_feedback_is_bug);
        this.mMessageEditText = (EditText)view.findViewById(R.id.com_appboy_feedback_message);
        this.mEmailEditText = (EditText)view.findViewById(R.id.com_appboy_feedback_email);
        this.mMessageEditText.addTextChangedListener(this.mSendButtonWatcher);
        this.mEmailEditText.addTextChangedListener(this.mSendButtonWatcher);
        this.mCancelButton.setOnClickListener(this.mCancelListener);
        this.mSendButton.setOnClickListener(this.mSendListener);
        return view;
    }

    public void onResume() {
        super.onResume();
        Appboy.getInstance((Context)this.getActivity()).logFeedbackDisplayed();
        FragmentActivity activity = this.getActivity();
        Window window = activity.getWindow();
        this.mOriginalSoftInputMode = window.getAttributes().softInputMode;
        window.setSoftInputMode(16);
        Appboy.getInstance((Context)activity).logFeedbackDisplayed();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mMessageEditText.removeTextChangedListener(this.mSendButtonWatcher);
        this.mEmailEditText.removeTextChangedListener(this.mSendButtonWatcher);
    }

    public void setFeedbackFinishedListener(FeedbackFinishedListener feedbackFinishedListener) {
        this.mFeedbackFinishedListener = feedbackFinishedListener;
    }

    private boolean validatedMessage() {
        boolean validMessage;
        boolean bl = validMessage = this.mMessageEditText.getText() != null && !StringUtils.isNullOrBlank(this.mMessageEditText.getText().toString());
        if (validMessage) {
            this.mMessageEditText.setError(null);
        } else {
            this.mMessageEditText.setError((CharSequence)this.getResources().getString(R.string.com_appboy_feedback_form_invalid_message));
        }
        return validMessage;
    }

    private boolean validatedEmail() {
        boolean blankEmail;
        boolean validEmail = this.mEmailEditText.getText() != null && !StringUtils.isNullOrBlank(this.mEmailEditText.getText().toString()) && ValidationUtils.isValidEmailAddress((String)this.mEmailEditText.getText().toString());
        boolean bl = blankEmail = this.mEmailEditText.getText() != null && StringUtils.isNullOrBlank(this.mEmailEditText.getText().toString());
        if (validEmail) {
            this.mEmailEditText.setError(null);
        } else if (blankEmail) {
            this.mEmailEditText.setError((CharSequence)this.getResources().getString(R.string.com_appboy_feedback_form_empty_email));
        } else {
            this.mEmailEditText.setError((CharSequence)this.getResources().getString(R.string.com_appboy_feedback_form_invalid_email));
        }
        return validEmail;
    }

    private boolean ensureSendButton() {
        return this.validatedMessage() & this.validatedEmail();
    }

    private void clearData() {
        this.mEmailEditText.setText((CharSequence)"");
        this.mMessageEditText.setText((CharSequence)"");
        this.mIsBugCheckBox.setChecked(false);
        this.mErrorMessageShown = false;
        this.mEmailEditText.setError(null);
        this.mMessageEditText.setError(null);
    }

    private void hideSoftKeyboard() {
        FragmentActivity activity = this.getActivity();
        activity.getWindow().setSoftInputMode(this.mOriginalSoftInputMode);
        View currentFocusView = activity.getCurrentFocus();
        if (currentFocusView != null) {
            InputMethodManager inputMethodManager = (InputMethodManager)activity.getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(activity.getCurrentFocus().getWindowToken(), 0);
        }
    }

    public static enum FeedbackResult {
        SENT,
        CANCELLED,
        ERROR;

    }

    public static interface FeedbackFinishedListener {
        public void onFeedbackFinished(FeedbackResult var1);

        public String beforeFeedbackSubmitted(String var1);
    }
}

