/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.actions;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import com.appboy.Constants;
import com.appboy.enums.AppStore;
import com.appboy.support.AppboyLogger;
import com.appboy.ui.AppboyWebViewActivity;
import com.appboy.ui.actions.IAction;

public final class GooglePlayAppDetailsAction
implements IAction {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, GooglePlayAppDetailsAction.class.getName());
    private static final String PLAY_STORE_APP_BASE = "market://details?id=";
    private static final String PLAY_STORE_WEB_BASE = "https://play.google.com/store/apps/details?id=";
    private static final String AMAZON_STORE_APP_BASE = "amzn://apps/android?asin=";
    private static final String AMAZON_STORE_WEB_BASE = "http://www.amazon.com/gp/mas/dl/android?asin=";
    private final String mPackageName;
    private boolean mUseAppboyWebView;
    private final AppStore mAppStore;
    private String mKindleId;

    public GooglePlayAppDetailsAction(String packageName, boolean useAppboyWebView, AppStore appStore) {
        this.mPackageName = packageName;
        this.mUseAppboyWebView = useAppboyWebView;
        this.mAppStore = appStore;
    }

    public GooglePlayAppDetailsAction(String packageName, boolean useAppboyWebView, AppStore appStore, String kindleId) {
        this.mPackageName = packageName;
        this.mUseAppboyWebView = useAppboyWebView;
        this.mAppStore = appStore;
        this.mKindleId = kindleId;
    }

    @Override
    public void execute(Context context) {
        if (this.mAppStore != AppStore.KINDLE_STORE) {
            try {
                context.getPackageManager().getPackageInfo("com.google.android.gsf", 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                AppboyLogger.i((String)TAG, (String)"Google Play Store not found, launching Play Store with WebView");
                this.mUseAppboyWebView = true;
            }
            catch (Exception e) {
                AppboyLogger.e((String)TAG, (String)String.format("Unexpected exception while checking for %s.", "com.google.android.gsf"));
                this.mUseAppboyWebView = true;
            }
        }
        String uriString = "";
        if (this.mUseAppboyWebView) {
            uriString = this.mAppStore == AppStore.KINDLE_STORE ? AMAZON_STORE_WEB_BASE + this.mKindleId : PLAY_STORE_WEB_BASE + this.mPackageName;
            Uri uri = Uri.parse((String)uriString);
            Intent intent = new Intent("android.intent.action.VIEW", uri, context, AppboyWebViewActivity.class);
            context.startActivity(intent);
        } else {
            uriString = this.mAppStore == AppStore.KINDLE_STORE ? AMAZON_STORE_APP_BASE + this.mKindleId : PLAY_STORE_APP_BASE + this.mPackageName;
            Uri uri = Uri.parse((String)uriString);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            context.startActivity(intent);
        }
    }
}

