/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.inappmessage;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import com.appboy.Appboy;
import com.appboy.AppboyImageUtils;
import com.appboy.Constants;
import com.appboy.IAppboyNavigator;
import com.appboy.enums.inappmessage.ClickAction;
import com.appboy.enums.inappmessage.SlideFrom;
import com.appboy.events.IEventSubscriber;
import com.appboy.events.InAppMessageEvent;
import com.appboy.models.IInAppMessage;
import com.appboy.models.IInAppMessageHtml;
import com.appboy.models.IInAppMessageImmersive;
import com.appboy.models.InAppMessageFull;
import com.appboy.models.InAppMessageHtmlFull;
import com.appboy.models.InAppMessageModal;
import com.appboy.models.InAppMessageSlideup;
import com.appboy.models.MessageButton;
import com.appboy.models.outgoing.AppboyProperties;
import com.appboy.push.AppboyNotificationUtils;
import com.appboy.support.AppboyLogger;
import com.appboy.support.BundleUtils;
import com.appboy.ui.AppboyNavigator;
import com.appboy.ui.R;
import com.appboy.ui.actions.ActionFactory;
import com.appboy.ui.actions.IAction;
import com.appboy.ui.inappmessage.IInAppMessageAnimationFactory;
import com.appboy.ui.inappmessage.IInAppMessageImmersiveView;
import com.appboy.ui.inappmessage.IInAppMessageView;
import com.appboy.ui.inappmessage.IInAppMessageViewFactory;
import com.appboy.ui.inappmessage.InAppMessageCloser;
import com.appboy.ui.inappmessage.InAppMessageOperation;
import com.appboy.ui.inappmessage.InAppMessageViewWrapper;
import com.appboy.ui.inappmessage.InAppMessageWebViewClient;
import com.appboy.ui.inappmessage.listeners.IHtmlInAppMessageActionListener;
import com.appboy.ui.inappmessage.listeners.IInAppMessageManagerListener;
import com.appboy.ui.inappmessage.listeners.IInAppMessageViewLifecycleListener;
import com.appboy.ui.inappmessage.listeners.IInAppMessageWebViewClientListener;
import com.appboy.ui.inappmessage.views.AppboyInAppMessageFullView;
import com.appboy.ui.inappmessage.views.AppboyInAppMessageHtmlFullView;
import com.appboy.ui.inappmessage.views.AppboyInAppMessageModalView;
import com.appboy.ui.inappmessage.views.AppboyInAppMessageSlideupView;
import com.appboy.ui.support.AnimationUtils;
import com.appboy.ui.support.FrescoLibraryUtils;
import com.appboy.ui.support.StringUtils;
import com.appboy.ui.support.ViewUtils;
import com.appboy.ui.support.WebContentUtils;
import com.facebook.datasource.DataSource;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.File;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;

public final class AppboyInAppMessageManager {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, AppboyInAppMessageManager.class.getName());
    private static volatile AppboyInAppMessageManager sInstance = null;
    private static final String HTML_IAM_CUSTOM_EVENT_NAME_KEY = "name";
    private final Stack<IInAppMessage> mInAppMessageBaseStack = new Stack();
    private final IAppboyNavigator mDefaultAppboyNavigator = new AppboyNavigator();
    private Activity mActivity;
    private IEventSubscriber<InAppMessageEvent> mInAppMessageEventSubscriber;
    private IInAppMessageManagerListener mCustomInAppMessageManagerListener;
    private IInAppMessageViewFactory mCustomInAppMessageViewFactory;
    private IInAppMessageAnimationFactory mCustomInAppMessageAnimationFactory;
    private InAppMessageViewWrapper mInAppMessageViewWrapper;
    private IInAppMessage mCarryoverInAppMessageBase;
    private AtomicBoolean mDisplayingInAppMessage = new AtomicBoolean(false);
    private IHtmlInAppMessageActionListener mCustomHtmlInAppMessageActionListener;
    private boolean mCanUseFresco;
    private IInAppMessageManagerListener mDefaultInAppMessageManagerListener = new IInAppMessageManagerListener(){

        @Override
        public boolean onInAppMessageReceived(IInAppMessage inAppMessage) {
            return false;
        }

        @Override
        public InAppMessageOperation beforeInAppMessageDisplayed(IInAppMessage inAppMessage) {
            return InAppMessageOperation.DISPLAY_NOW;
        }

        @Override
        public boolean onInAppMessageClicked(IInAppMessage inAppMessage, InAppMessageCloser inAppMessageCloser) {
            return false;
        }

        @Override
        public boolean onInAppMessageButtonClicked(MessageButton button, InAppMessageCloser inAppMessageCloser) {
            return false;
        }

        @Override
        public void onInAppMessageDismissed(IInAppMessage inAppMessage) {
        }
    };
    private IHtmlInAppMessageActionListener mDefaultHtmlInAppMessageActionListener = new IHtmlInAppMessageActionListener(){

        @Override
        public void onCloseClicked(IInAppMessage inAppMessage, String url, Bundle queryBundle) {
        }

        @Override
        public boolean onNewsfeedClicked(IInAppMessage inAppMessage, String url, Bundle queryBundle) {
            return false;
        }

        @Override
        public boolean onCustomEventFired(IInAppMessage inAppMessage, String url, Bundle queryBundle) {
            return false;
        }

        @Override
        public boolean onOtherUrlAction(IInAppMessage inAppMessage, String url, Bundle queryBundle) {
            return false;
        }
    };
    private IInAppMessageViewFactory mInAppMessageSlideupViewFactory = new IInAppMessageViewFactory(){

        @Override
        public View createInAppMessageView(Activity activity, IInAppMessage inAppMessage) {
            InAppMessageSlideup inAppMessageSlideup = (InAppMessageSlideup)inAppMessage;
            AppboyInAppMessageSlideupView slideupView = (AppboyInAppMessageSlideupView)activity.getLayoutInflater().inflate(R.layout.com_appboy_inappmessage_slideup, null);
            slideupView.inflateStubViews();
            if (AppboyInAppMessageManager.this.mCanUseFresco) {
                slideupView.setMessageSimpleDrawee(inAppMessage.getImageUrl());
            } else {
                slideupView.setMessageImageView(inAppMessageSlideup.getBitmap());
            }
            slideupView.setMessageBackgroundColor(inAppMessageSlideup.getBackgroundColor());
            slideupView.setMessage(inAppMessageSlideup.getMessage());
            slideupView.setMessageTextColor(inAppMessageSlideup.getMessageTextColor());
            slideupView.setMessageIcon(inAppMessageSlideup.getIcon(), inAppMessageSlideup.getIconColor(), inAppMessageSlideup.getIconBackgroundColor());
            slideupView.setMessageChevron(inAppMessageSlideup.getChevronColor(), inAppMessageSlideup.getClickAction());
            slideupView.resetMessageMargins(inAppMessage.getImageDownloadSuccessful());
            return slideupView;
        }
    };
    private IInAppMessageViewFactory mInAppMessageModalViewFactory = new IInAppMessageViewFactory(){

        @Override
        public View createInAppMessageView(Activity activity, IInAppMessage inAppMessage) {
            InAppMessageModal inAppMessageModal = (InAppMessageModal)inAppMessage;
            AppboyInAppMessageModalView modalView = (AppboyInAppMessageModalView)activity.getLayoutInflater().inflate(R.layout.com_appboy_inappmessage_modal, null);
            modalView.inflateStubViews();
            if (AppboyInAppMessageManager.this.mCanUseFresco) {
                modalView.setMessageSimpleDrawee(inAppMessage.getImageUrl());
            } else {
                modalView.setMessageImageView(inAppMessageModal.getBitmap());
            }
            modalView.setMessageBackgroundColor(inAppMessage.getBackgroundColor());
            modalView.setMessage(inAppMessage.getMessage());
            modalView.setMessageTextColor(inAppMessage.getMessageTextColor());
            modalView.setMessageHeaderText(inAppMessageModal.getHeader());
            modalView.setMessageHeaderTextColor(inAppMessageModal.getHeaderTextColor());
            modalView.setMessageIcon(inAppMessage.getIcon(), inAppMessage.getIconColor(), inAppMessage.getIconBackgroundColor());
            modalView.setMessageButtons(inAppMessageModal.getMessageButtons());
            modalView.setMessageCloseButtonColor(inAppMessageModal.getCloseButtonColor());
            modalView.resetMessageMargins(inAppMessage.getImageDownloadSuccessful());
            return modalView;
        }
    };
    private IInAppMessageViewFactory mInAppMessageFullViewFactory = new IInAppMessageViewFactory(){

        @Override
        public View createInAppMessageView(Activity activity, IInAppMessage inAppMessage) {
            InAppMessageFull inAppMessageFull = (InAppMessageFull)inAppMessage;
            AppboyInAppMessageFullView fullView = (AppboyInAppMessageFullView)activity.getLayoutInflater().inflate(R.layout.com_appboy_inappmessage_full, null);
            fullView.inflateStubViews();
            if (AppboyInAppMessageManager.this.mCanUseFresco) {
                fullView.setMessageSimpleDrawee(inAppMessage.getImageUrl());
            } else {
                fullView.setMessageImageView(inAppMessage.getBitmap());
            }
            fullView.setMessageBackgroundColor(inAppMessageFull.getBackgroundColor());
            fullView.setMessage(inAppMessageFull.getMessage());
            fullView.setMessageTextColor(inAppMessageFull.getMessageTextColor());
            fullView.setMessageHeaderText(inAppMessageFull.getHeader());
            fullView.setMessageHeaderTextColor(inAppMessageFull.getHeaderTextColor());
            fullView.setMessageButtons(inAppMessageFull.getMessageButtons());
            fullView.setMessageCloseButtonColor(inAppMessageFull.getCloseButtonColor());
            fullView.resetMessageMargins(inAppMessage.getImageDownloadSuccessful());
            return fullView;
        }
    };
    private IInAppMessageViewFactory mInAppMessageHtmlFullViewFactory = new IInAppMessageViewFactory(){

        @Override
        public View createInAppMessageView(Activity activity, IInAppMessage inAppMessage) {
            InAppMessageHtmlFull inAppMessageHtmlFull = (InAppMessageHtmlFull)inAppMessage;
            AppboyInAppMessageHtmlFullView htmlFullView = (AppboyInAppMessageHtmlFullView)activity.getLayoutInflater().inflate(R.layout.com_appboy_inappmessage_html_full, null);
            htmlFullView.setWebViewContent(inAppMessage.getMessage(), inAppMessageHtmlFull.getLocalAssetsDirectoryUrl());
            htmlFullView.setInAppMessageWebViewClient(new InAppMessageWebViewClient(inAppMessage, AppboyInAppMessageManager.this.mInAppMessageWebViewClientListener));
            return htmlFullView;
        }
    };
    private IInAppMessageAnimationFactory mInAppMessageAnimationFactory = new IInAppMessageAnimationFactory(){
        private final long sSlideupAnimationDurationMillis = 400L;
        private final int mShortAnimationDurationMillis = Resources.getSystem().getInteger(0x10E0000);

        @Override
        public Animation getOpeningAnimation(IInAppMessage inAppMessage) {
            InAppMessageSlideup inAppMessageSlideup;
            Object animation = inAppMessage instanceof InAppMessageSlideup ? ((inAppMessageSlideup = (InAppMessageSlideup)inAppMessage).getSlideFrom() == SlideFrom.TOP ? AnimationUtils.createVerticalAnimation(-1.0f, 0.0f, 400L, false) : AnimationUtils.createVerticalAnimation(1.0f, 0.0f, 400L, false)) : new AlphaAnimation(0.0f, 1.0f);
            return AnimationUtils.setAnimationParams((Animation)animation, this.mShortAnimationDurationMillis, true);
        }

        @Override
        public Animation getClosingAnimation(IInAppMessage inAppMessage) {
            InAppMessageSlideup inAppMessageSlideup;
            Object animation = inAppMessage instanceof InAppMessageSlideup ? ((inAppMessageSlideup = (InAppMessageSlideup)inAppMessage).getSlideFrom() == SlideFrom.TOP ? AnimationUtils.createVerticalAnimation(0.0f, -1.0f, 400L, false) : AnimationUtils.createVerticalAnimation(0.0f, 1.0f, 400L, false)) : new AlphaAnimation(1.0f, 0.0f);
            return AnimationUtils.setAnimationParams((Animation)animation, this.mShortAnimationDurationMillis, false);
        }
    };
    private final IInAppMessageViewLifecycleListener mInAppMessageViewLifecycleListener = new IInAppMessageViewLifecycleListener(){

        @Override
        public void beforeOpened(View inAppMessageView, IInAppMessage inAppMessage) {
            AppboyLogger.d((String)TAG, (String)"InAppMessageViewWrapper.IInAppMessageViewLifecycleListener.beforeOpened called.");
            inAppMessage.logImpression();
        }

        @Override
        public void afterOpened(View inAppMessageView, IInAppMessage inAppMessage) {
            AppboyLogger.d((String)TAG, (String)"InAppMessageViewWrapper.IInAppMessageViewLifecycleListener.afterOpened called.");
        }

        @Override
        public void beforeClosed(View inAppMessageView, IInAppMessage inAppMessage) {
            AppboyLogger.d((String)TAG, (String)"InAppMessageViewWrapper.IInAppMessageViewLifecycleListener.beforeClosed called.");
        }

        @Override
        public void afterClosed(IInAppMessage inAppMessage) {
            AppboyInAppMessageManager.this.mInAppMessageViewWrapper = null;
            AppboyLogger.d((String)TAG, (String)"InAppMessageViewWrapper.IInAppMessageViewLifecycleListener.afterClosed called.");
            AppboyInAppMessageManager.this.mDisplayingInAppMessage.set(false);
            if (inAppMessage instanceof IInAppMessageHtml) {
                AppboyInAppMessageManager.this.startClearHtmlInAppMessageAssetsThread((IInAppMessageHtml)inAppMessage);
            }
        }

        @Override
        public void onClicked(InAppMessageCloser inAppMessageCloser, View inAppMessageView, IInAppMessage inAppMessage) {
            boolean handled;
            AppboyLogger.d((String)TAG, (String)"InAppMessageViewWrapper.IInAppMessageViewLifecycleListener.onClicked called.");
            if (inAppMessage.getClickAction() != ClickAction.NONE) {
                inAppMessage.logClick();
            }
            if (!(handled = AppboyInAppMessageManager.this.getInAppMessageManagerListener().onInAppMessageClicked(inAppMessage, inAppMessageCloser))) {
                this.performInAppMessageClicked(inAppMessage, inAppMessageCloser);
            }
        }

        @Override
        public void onButtonClicked(InAppMessageCloser inAppMessageCloser, MessageButton messageButton, IInAppMessageImmersive inAppMessageImmersive) {
            boolean handled;
            AppboyLogger.d((String)TAG, (String)"InAppMessageViewWrapper.IInAppMessageViewLifecycleListener.onButtonClicked called.");
            if (messageButton.getClickAction() != ClickAction.NONE) {
                inAppMessageImmersive.logButtonClick(messageButton);
            }
            if (!(handled = AppboyInAppMessageManager.this.getInAppMessageManagerListener().onInAppMessageButtonClicked(messageButton, inAppMessageCloser))) {
                this.performInAppMessageButtonClicked(messageButton, (IInAppMessage)inAppMessageImmersive, inAppMessageCloser);
            }
        }

        @Override
        public void onDismissed(View inAppMessageView, IInAppMessage inAppMessage) {
            AppboyLogger.d((String)TAG, (String)"InAppMessageViewWrapper.IInAppMessageViewLifecycleListener.onDismissed called.");
            AppboyInAppMessageManager.this.getInAppMessageManagerListener().onInAppMessageDismissed(inAppMessage);
        }

        private void performInAppMessageButtonClicked(MessageButton messageButton, IInAppMessage inAppMessage, InAppMessageCloser inAppMessageCloser) {
            this.performClickAction(messageButton.getClickAction(), inAppMessage, inAppMessageCloser, messageButton.getUri());
        }

        private void performInAppMessageClicked(IInAppMessage inAppMessage, InAppMessageCloser inAppMessageCloser) {
            this.performClickAction(inAppMessage.getClickAction(), inAppMessage, inAppMessageCloser, inAppMessage.getUri());
        }

        private void performClickAction(ClickAction clickAction, IInAppMessage inAppMessage, InAppMessageCloser inAppMessageCloser, Uri clickUri) {
            if (AppboyInAppMessageManager.this.mActivity == null) {
                AppboyLogger.e((String)TAG, (String)"No activity is currently registered to receive in-app messages. Doing nothing.");
                return;
            }
            switch (clickAction) {
                case NEWS_FEED: {
                    inAppMessage.setAnimateOut(false);
                    inAppMessageCloser.close(false);
                    AppboyInAppMessageManager.this.getAppboyNavigator().gotoNewsFeed((Context)AppboyInAppMessageManager.this.mActivity, BundleUtils.mapToBundle((Map)inAppMessage.getExtras()));
                    break;
                }
                case URI: {
                    inAppMessage.setAnimateOut(false);
                    inAppMessageCloser.close(false);
                    IAction action = ActionFactory.createUriAction((Context)AppboyInAppMessageManager.this.mActivity, clickUri.toString());
                    action.execute((Context)AppboyInAppMessageManager.this.mActivity);
                    break;
                }
                case NONE: {
                    inAppMessageCloser.close(true);
                    break;
                }
                default: {
                    inAppMessageCloser.close(false);
                }
            }
        }
    };
    private final IInAppMessageWebViewClientListener mInAppMessageWebViewClientListener = new IInAppMessageWebViewClientListener(){

        @Override
        public void onCloseAction(IInAppMessage inAppMessage, String url, Bundle queryBundle) {
            AppboyLogger.d((String)TAG, (String)"IInAppMessageWebViewClientListener.onCloseAction called.");
            AppboyInAppMessageManager.this.hideCurrentInAppMessage(true, true);
            AppboyInAppMessageManager.this.getHtmlInAppMessageActionListener().onCloseClicked(inAppMessage, url, queryBundle);
        }

        @Override
        public void onNewsfeedAction(IInAppMessage inAppMessage, String url, Bundle queryBundle) {
            AppboyLogger.d((String)TAG, (String)"IInAppMessageWebViewClientListener.onNewsfeedAction called.");
            this.logHtmlInAppMessageClick(inAppMessage, queryBundle);
            boolean handled = AppboyInAppMessageManager.this.getHtmlInAppMessageActionListener().onNewsfeedClicked(inAppMessage, url, queryBundle);
            if (!handled) {
                AppboyInAppMessageManager.this.hideCurrentInAppMessage(false);
                Bundle inAppMessageBundle = BundleUtils.mapToBundle((Map)inAppMessage.getExtras());
                inAppMessageBundle.putAll(queryBundle);
                AppboyInAppMessageManager.this.getAppboyNavigator().gotoNewsFeed((Context)AppboyInAppMessageManager.this.mActivity, inAppMessageBundle);
            }
        }

        @Override
        public void onCustomEventAction(IInAppMessage inAppMessage, String url, Bundle queryBundle) {
            AppboyLogger.d((String)TAG, (String)"IInAppMessageWebViewClientListener.onCustomEventAction called.");
            boolean handled = AppboyInAppMessageManager.this.getHtmlInAppMessageActionListener().onCustomEventFired(inAppMessage, url, queryBundle);
            if (!handled) {
                String customEventName = AppboyInAppMessageManager.this.parseCustomEventNameFromQueryBundle(queryBundle);
                if (StringUtils.isNullOrBlank(customEventName)) {
                    return;
                }
                AppboyProperties customEventProperties = AppboyInAppMessageManager.this.parsePropertiesFromQueryBundle(queryBundle);
                Appboy.getInstance((Context)AppboyInAppMessageManager.this.mActivity.getApplicationContext()).logCustomEvent(customEventName, customEventProperties);
            }
        }

        @Override
        public void onOtherUrlAction(IInAppMessage inAppMessage, String url, Bundle queryBundle) {
            AppboyLogger.d((String)TAG, (String)"IInAppMessageWebViewClientListener.onOtherUrlAction called.");
            this.logHtmlInAppMessageClick(inAppMessage, queryBundle);
            boolean handled = AppboyInAppMessageManager.this.getHtmlInAppMessageActionListener().onOtherUrlAction(inAppMessage, url, queryBundle);
            if (!handled) {
                IAction urlAction;
                AppboyInAppMessageManager.this.hideCurrentInAppMessage(false);
                boolean doExternalOpen = false;
                if (queryBundle.containsKey("abExternalOpen")) {
                    doExternalOpen = Boolean.parseBoolean(queryBundle.getString("abExternalOpen"));
                }
                if (doExternalOpen) {
                    Bundle inAppMessageBundle = BundleUtils.mapToBundle((Map)inAppMessage.getExtras());
                    inAppMessageBundle.putAll(queryBundle);
                    urlAction = ActionFactory.createViewUriAction(url, inAppMessageBundle);
                } else {
                    urlAction = ActionFactory.createUriAction((Context)AppboyInAppMessageManager.this.mActivity, url);
                }
                if (urlAction != null) {
                    urlAction.execute((Context)AppboyInAppMessageManager.this.mActivity);
                }
            }
        }

        private void logHtmlInAppMessageClick(IInAppMessage inAppMessage, Bundle queryBundle) {
            if (queryBundle != null && queryBundle.containsKey("abButtonId")) {
                InAppMessageHtmlFull inAppMessageHtmlFull = (InAppMessageHtmlFull)inAppMessage;
                inAppMessageHtmlFull.logButtonClick(queryBundle.getString("abButtonId"));
            } else {
                inAppMessage.logClick();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppboyInAppMessageManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<AppboyInAppMessageManager> clazz = AppboyInAppMessageManager.class;
        synchronized (AppboyInAppMessageManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new AppboyInAppMessageManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void registerInAppMessageManager(Activity activity) {
        this.mActivity = activity;
        this.mCanUseFresco = FrescoLibraryUtils.canUseFresco(activity.getApplicationContext());
        if (this.mCarryoverInAppMessageBase != null) {
            AppboyLogger.d((String)TAG, (String)"Displaying carryover in-app message.");
            this.mCarryoverInAppMessageBase.setAnimateIn(false);
            this.displayInAppMessage(this.mCarryoverInAppMessageBase);
            this.mCarryoverInAppMessageBase = null;
        }
        this.mInAppMessageEventSubscriber = this.createInAppMessageEventSubscriber();
        Appboy.getInstance((Context)activity).subscribeToNewInAppMessages(this.mInAppMessageEventSubscriber);
    }

    public void unregisterInAppMessageManager(Activity activity) {
        if (this.mInAppMessageViewWrapper != null) {
            ViewUtils.removeViewFromParent(this.mInAppMessageViewWrapper.getInAppMessageView());
            if (this.mInAppMessageViewWrapper.getIsAnimatingClose()) {
                this.mInAppMessageViewWrapper.callAfterClosed();
                this.mCarryoverInAppMessageBase = null;
            } else {
                this.mCarryoverInAppMessageBase = this.mInAppMessageViewWrapper.getInAppMessage();
            }
            this.mInAppMessageViewWrapper = null;
        } else {
            this.mCarryoverInAppMessageBase = null;
        }
        Appboy.getInstance((Context)activity).removeSingleSubscription(this.mInAppMessageEventSubscriber, InAppMessageEvent.class);
        this.mActivity = null;
    }

    public void setCustomInAppMessageManagerListener(IInAppMessageManagerListener inAppMessageManagerListener) {
        this.mCustomInAppMessageManagerListener = inAppMessageManagerListener;
    }

    public void setCustomHtmlInAppMessageActionListener(IHtmlInAppMessageActionListener htmlInAppMessageActionListener) {
        this.mCustomHtmlInAppMessageActionListener = htmlInAppMessageActionListener;
    }

    public void setCustomInAppMessageAnimationFactory(IInAppMessageAnimationFactory inAppMessageAnimationFactory) {
        this.mCustomInAppMessageAnimationFactory = inAppMessageAnimationFactory;
    }

    public void setCustomInAppMessageViewFactory(IInAppMessageViewFactory inAppMessageViewFactory) {
        this.mCustomInAppMessageViewFactory = inAppMessageViewFactory;
    }

    public void addInAppMessage(IInAppMessage inAppMessage) {
        this.mInAppMessageBaseStack.push(inAppMessage);
        this.requestDisplayInAppMessage();
    }

    public boolean requestDisplayInAppMessage() {
        if (this.mActivity == null) {
            AppboyLogger.e((String)TAG, (String)"No activity is currently registered to receive in-app messages. Doing nothing.");
            return false;
        }
        if (!this.mDisplayingInAppMessage.compareAndSet(false, true)) {
            AppboyLogger.d((String)TAG, (String)"A in-app message is currently being displayed. Ignoring request to display in-app message.");
            return false;
        }
        if (this.mInAppMessageBaseStack.isEmpty()) {
            AppboyLogger.d((String)TAG, (String)"The in-app message stack is empty. No in-app message will be displayed.");
            this.mDisplayingInAppMessage.set(false);
            return false;
        }
        final IInAppMessage inAppMessage = this.mInAppMessageBaseStack.pop();
        InAppMessageOperation inAppMessageOperation = this.getInAppMessageManagerListener().beforeInAppMessageDisplayed(inAppMessage);
        switch (inAppMessageOperation) {
            case DISPLAY_NOW: {
                AppboyLogger.d((String)TAG, (String)"The IInAppMessageManagerListener method beforeInAppMessageDisplayed returned DISPLAY_NOW. The in-app message will be displayed.");
                break;
            }
            case DISPLAY_LATER: {
                AppboyLogger.d((String)TAG, (String)"The IInAppMessageManagerListener method beforeInAppMessageDisplayed returned DISPLAY_LATER. The in-app message will be pushed back onto the stack.");
                this.mInAppMessageBaseStack.push(inAppMessage);
                this.mDisplayingInAppMessage.set(false);
                return false;
            }
            case DISCARD: {
                AppboyLogger.d((String)TAG, (String)"The IInAppMessageManagerListener method beforeInAppMessageDisplayed returned DISCARD. The in-app message will not be displayed and will not be put back on the stack.");
                this.mDisplayingInAppMessage.set(false);
                return false;
            }
            default: {
                AppboyLogger.e((String)TAG, (String)"The IInAppMessageManagerListener method beforeInAppMessageDisplayed returned null instead of a InAppMessageOperation. Ignoring the in-app message. Please check the IInAppMessageStackBehaviour implementation.");
                this.mDisplayingInAppMessage.set(false);
                return false;
            }
        }
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                new AsyncInAppMessageDisplayer().execute(new IInAppMessage[]{inAppMessage});
            }
        });
        return true;
    }

    public void hideCurrentInAppMessage(boolean animate, boolean dismissed) {
        InAppMessageViewWrapper inAppMessageWrapperView = this.mInAppMessageViewWrapper;
        if (inAppMessageWrapperView != null && dismissed) {
            inAppMessageWrapperView.callOnDismissed();
        }
        this.hideCurrentInAppMessage(animate);
    }

    public void hideCurrentInAppMessage(boolean animate) {
        InAppMessageViewWrapper inAppMessageWrapperView = this.mInAppMessageViewWrapper;
        if (inAppMessageWrapperView != null) {
            IInAppMessage inAppMessage = inAppMessageWrapperView.getInAppMessage();
            if (inAppMessage != null) {
                inAppMessage.setAnimateOut(animate);
            }
            inAppMessageWrapperView.close();
        }
    }

    private void startClearHtmlInAppMessageAssetsThread(final IInAppMessageHtml inAppMessageHtml) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (inAppMessageHtml != null) {
                    WebContentUtils.clearInAppMessageLocalAssets(inAppMessageHtml);
                }
            }
        }).start();
    }

    private IInAppMessageManagerListener getInAppMessageManagerListener() {
        return this.mCustomInAppMessageManagerListener != null ? this.mCustomInAppMessageManagerListener : this.mDefaultInAppMessageManagerListener;
    }

    private IHtmlInAppMessageActionListener getHtmlInAppMessageActionListener() {
        return this.mCustomHtmlInAppMessageActionListener != null ? this.mCustomHtmlInAppMessageActionListener : this.mDefaultHtmlInAppMessageActionListener;
    }

    private IInAppMessageViewFactory getInAppMessageViewFactory(IInAppMessage inAppMessage) {
        if (this.mCustomInAppMessageViewFactory != null) {
            return this.mCustomInAppMessageViewFactory;
        }
        if (inAppMessage instanceof InAppMessageSlideup) {
            return this.mInAppMessageSlideupViewFactory;
        }
        if (inAppMessage instanceof InAppMessageModal) {
            return this.mInAppMessageModalViewFactory;
        }
        if (inAppMessage instanceof InAppMessageFull) {
            return this.mInAppMessageFullViewFactory;
        }
        if (inAppMessage instanceof InAppMessageHtmlFull) {
            return this.mInAppMessageHtmlFullViewFactory;
        }
        return null;
    }

    private boolean displayInAppMessage(IInAppMessage inAppMessage) {
        if (this.mActivity == null) {
            AppboyLogger.e((String)TAG, (String)"No activity is currently registered to receive in-app messages. Doing nothing.");
            return false;
        }
        IInAppMessageViewFactory inAppMessageViewFactory = this.getInAppMessageViewFactory(inAppMessage);
        if (inAppMessageViewFactory == null) {
            AppboyLogger.d((String)TAG, (String)"ViewFactory from getInAppMessageViewFactory was null.");
            return false;
        }
        View inAppMessageView = inAppMessageViewFactory.createInAppMessageView(this.mActivity, inAppMessage);
        if (inAppMessageView == null) {
            AppboyLogger.e((String)TAG, (String)"The in-app message view returned from the IInAppMessageViewFactory was null. The in-app message will not be displayed and will not be put back on the stack.");
            this.mDisplayingInAppMessage.set(false);
            return false;
        }
        if (inAppMessageView.getParent() != null) {
            AppboyLogger.e((String)TAG, (String)"The in-app message view returned from the IInAppMessageViewFactory already has a parent. This is a sign that the view is being reused. The IInAppMessageViewFactory method createInAppMessageViewmust return a new view without a parent. The in-app message will not be displayed and will not be put back on the stack.");
            this.mDisplayingInAppMessage.set(false);
            return false;
        }
        Animation openingAnimation = this.getInAppMessageAnimationFactory(inAppMessage).getOpeningAnimation(inAppMessage);
        Animation closingAnimation = this.getInAppMessageAnimationFactory(inAppMessage).getClosingAnimation(inAppMessage);
        if (inAppMessageView instanceof IInAppMessageImmersiveView) {
            AppboyLogger.d((String)TAG, (String)"Creating view wrapper for immersive in-app message.");
            IInAppMessageImmersiveView inAppMessageViewImmersive = (IInAppMessageImmersiveView)inAppMessageView;
            this.mInAppMessageViewWrapper = new InAppMessageViewWrapper(inAppMessageView, inAppMessage, this.mInAppMessageViewLifecycleListener, openingAnimation, closingAnimation, inAppMessageViewImmersive.getMessageClickableView(), inAppMessageViewImmersive.getMessageButtonViews(), inAppMessageViewImmersive.getMessageCloseButtonView());
        } else if (inAppMessageView instanceof IInAppMessageView) {
            AppboyLogger.d((String)TAG, (String)"Creating view wrapper for base in-app message.");
            IInAppMessageView inAppMessageViewBase = (IInAppMessageView)inAppMessageView;
            this.mInAppMessageViewWrapper = new InAppMessageViewWrapper(inAppMessageView, inAppMessage, this.mInAppMessageViewLifecycleListener, openingAnimation, closingAnimation, inAppMessageViewBase.getMessageClickableView());
        } else {
            AppboyLogger.d((String)TAG, (String)"Creating view wrapper for in-app message.");
            this.mInAppMessageViewWrapper = new InAppMessageViewWrapper(inAppMessageView, inAppMessage, this.mInAppMessageViewLifecycleListener, openingAnimation, closingAnimation, inAppMessageView);
        }
        FrameLayout root = (FrameLayout)this.mActivity.getWindow().getDecorView().findViewById(0x1020002);
        this.mInAppMessageViewWrapper.open(root);
        return true;
    }

    private IEventSubscriber<InAppMessageEvent> createInAppMessageEventSubscriber() {
        return new IEventSubscriber<InAppMessageEvent>(){

            public void trigger(InAppMessageEvent event) {
                if (AppboyInAppMessageManager.this.getInAppMessageManagerListener().onInAppMessageReceived(event.getInAppMessage())) {
                    return;
                }
                AppboyInAppMessageManager.this.addInAppMessage(event.getInAppMessage());
            }
        };
    }

    private IInAppMessageAnimationFactory getInAppMessageAnimationFactory(IInAppMessage inAppMessage) {
        if (this.mCustomInAppMessageAnimationFactory != null) {
            return this.mCustomInAppMessageAnimationFactory;
        }
        return this.mInAppMessageAnimationFactory;
    }

    String parseCustomEventNameFromQueryBundle(Bundle queryBundle) {
        return queryBundle.getString(HTML_IAM_CUSTOM_EVENT_NAME_KEY);
    }

    AppboyProperties parsePropertiesFromQueryBundle(Bundle queryBundle) {
        AppboyProperties customEventProperties = new AppboyProperties();
        for (String key : queryBundle.keySet()) {
            String propertyValue;
            if (key.equals(HTML_IAM_CUSTOM_EVENT_NAME_KEY) || StringUtils.isNullOrBlank(propertyValue = AppboyNotificationUtils.bundleOptString(queryBundle, key, null))) continue;
            customEventProperties.addProperty(key, propertyValue);
        }
        return customEventProperties;
    }

    private IAppboyNavigator getAppboyNavigator() {
        IAppboyNavigator customAppboyNavigator = Appboy.getInstance((Context)this.mActivity).getAppboyNavigator();
        return customAppboyNavigator != null ? customAppboyNavigator : this.mDefaultAppboyNavigator;
    }

    @Deprecated
    public void registerSlideupManager(Activity activity) {
        AppboyInAppMessageManager.getInstance().registerInAppMessageManager(activity);
    }

    @Deprecated
    public void unregisterSlideupManager(Activity activity) {
        AppboyInAppMessageManager.getInstance().unregisterInAppMessageManager(activity);
    }

    AsyncInAppMessageDisplayer createAsyncInAppMessageDisplayer() {
        return new AsyncInAppMessageDisplayer();
    }

    class AsyncInAppMessageDisplayer
    extends AsyncTask<IInAppMessage, Integer, IInAppMessage> {
        AsyncInAppMessageDisplayer() {
        }

        protected IInAppMessage doInBackground(IInAppMessage ... inAppMessages) {
            AppboyLogger.d((String)TAG, (String)"Starting asynchronous in-app message preparation.");
            IInAppMessage inAppMessage = inAppMessages[0];
            if (inAppMessage instanceof InAppMessageHtmlFull) {
                this.prepareInAppMessageWithHtml(inAppMessage);
            } else {
                String imageUrl = inAppMessage.getImageUrl();
                if (StringUtils.isNullOrBlank(imageUrl)) {
                    AppboyLogger.w((String)TAG, (String)"In-app message has no image URL. Not downloading image from URL.");
                    return inAppMessage;
                }
                if (AppboyInAppMessageManager.this.mCanUseFresco) {
                    this.prepareInAppMessageWithFresco(inAppMessage, imageUrl);
                } else {
                    this.prepareInAppMessageWithBitmapDownload(inAppMessage, imageUrl);
                }
            }
            return inAppMessage;
        }

        protected void onPostExecute(final IInAppMessage inAppMessage) {
            if (AppboyInAppMessageManager.this.mActivity == null) {
                AppboyLogger.e((String)TAG, (String)"No activity is currently registered to receive in-app messages. Doing nothing.");
                return;
            }
            AppboyLogger.d((String)TAG, (String)"Finished asynchronous in-app message preparation. Attempting to display in-app message.");
            if (inAppMessage != null) {
                AppboyInAppMessageManager.this.mActivity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        AppboyLogger.d((String)TAG, (String)"Displaying in-app message.");
                        AppboyInAppMessageManager.this.displayInAppMessage(inAppMessage);
                    }
                });
            } else {
                AppboyLogger.e((String)TAG, (String)"Cannot display the in-app message because the in-app message was null.");
                AppboyInAppMessageManager.this.mDisplayingInAppMessage.set(false);
            }
        }

        void prepareInAppMessageWithHtml(IInAppMessage inAppMessage) {
            InAppMessageHtmlFull inAppMessageHtmlFull = (InAppMessageHtmlFull)inAppMessage;
            File internalStorageCacheDirectory = AppboyInAppMessageManager.this.mActivity.getCacheDir();
            String localWebContentUrl = WebContentUtils.getLocalHtmlUrlFromRemoteUrl(internalStorageCacheDirectory, inAppMessageHtmlFull.getAssetsZipRemoteUrl());
            if (!StringUtils.isNullOrBlank(localWebContentUrl)) {
                AppboyLogger.d((String)TAG, (String)("Local url for html in-app message is " + localWebContentUrl));
                inAppMessageHtmlFull.setLocalAssetsDirectoryUrl(localWebContentUrl);
            } else {
                AppboyLogger.w((String)TAG, (String)String.format("Download of html content to local directory failed for remote url: %s . Returned local url is: %s", inAppMessageHtmlFull.getAssetsZipRemoteUrl(), localWebContentUrl));
            }
        }

        private void prepareInAppMessageWithFresco(IInAppMessage inAppMessage, String imageUrl) {
            try {
                ImagePipeline imagePipeline = Fresco.getImagePipeline();
                ImageRequest imageRequest = ImageRequest.fromUri((String)imageUrl);
                DataSource dataSource = imagePipeline.prefetchToDiskCache(imageRequest, new Object());
                while (!dataSource.isFinished()) {
                }
                if (dataSource.hasFailed()) {
                    if (dataSource.getFailureCause() == null) {
                        AppboyLogger.w((String)TAG, (String)"Fresco disk prefetch failed with a null cause.");
                    } else {
                        AppboyLogger.w((String)TAG, (String)("Fresco disk prefetch failed with cause: " + dataSource.getFailureCause().getMessage() + " with image url: " + imageUrl));
                    }
                } else {
                    inAppMessage.setImageDownloadSuccessful(true);
                }
                dataSource.close();
            }
            catch (NullPointerException e) {
                AppboyLogger.e((String)TAG, (String)"Fresco image pipeline could not be retrieved. Fresco most likely prematurely shutdown.", (Throwable)e);
            }
        }

        void prepareInAppMessageWithBitmapDownload(IInAppMessage inAppMessage, String imageUrl) {
            if (inAppMessage.getBitmap() == null) {
                inAppMessage.setBitmap(AppboyImageUtils.downloadImageBitmap(imageUrl));
                if (inAppMessage.getBitmap() != null) {
                    inAppMessage.setImageDownloadSuccessful(true);
                }
            } else {
                AppboyLogger.i((String)TAG, (String)"In-app message already contains image bitmap. Not downloading image from URL.");
            }
        }
    }
}

