/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.inappmessage;

import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import com.appboy.Constants;
import com.appboy.enums.inappmessage.DismissType;
import com.appboy.enums.inappmessage.SlideFrom;
import com.appboy.models.IInAppMessage;
import com.appboy.models.IInAppMessageHtml;
import com.appboy.models.IInAppMessageImmersive;
import com.appboy.models.InAppMessageSlideup;
import com.appboy.models.MessageButton;
import com.appboy.support.AppboyLogger;
import com.appboy.ui.inappmessage.InAppMessageCloser;
import com.appboy.ui.inappmessage.listeners.IInAppMessageViewLifecycleListener;
import com.appboy.ui.inappmessage.listeners.SimpleSwipeDismissTouchListener;
import com.appboy.ui.inappmessage.listeners.SwipeDismissTouchListener;
import com.appboy.ui.inappmessage.listeners.TouchAwareSwipeDismissTouchListener;
import com.appboy.ui.support.AnimationUtils;
import com.appboy.ui.support.ViewUtils;
import java.util.List;

public class InAppMessageViewWrapper {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, InAppMessageViewWrapper.class.getName());
    private final View mInAppMessageView;
    private View mClickableInAppMessageView;
    private View mCloseButton;
    private List<View> mButtons;
    private final IInAppMessage mInAppMessage;
    private final IInAppMessageViewLifecycleListener mInAppMessageViewLifecycleListener;
    private final Animation mOpeningAnimation;
    private final Animation mClosingAnimation;
    private Runnable mDismissRunnable;
    private boolean mIsAnimatingClose;

    public InAppMessageViewWrapper(View inAppMessageView, IInAppMessage inAppMessage, IInAppMessageViewLifecycleListener inAppMessageViewLifecycleListener, Animation openingAnimation, Animation closingAnimation, View clickableInAppMessageView) {
        this.mInAppMessageView = inAppMessageView;
        this.mInAppMessage = inAppMessage;
        this.mInAppMessageViewLifecycleListener = inAppMessageViewLifecycleListener;
        this.mIsAnimatingClose = false;
        this.mClickableInAppMessageView = clickableInAppMessageView != null ? clickableInAppMessageView : this.mInAppMessageView;
        if (Build.VERSION.SDK_INT >= 12 && this.mInAppMessage instanceof InAppMessageSlideup) {
            SwipeDismissTouchListener.DismissCallbacks dismissCallbacks = this.createDismissCallbacks();
            TouchAwareSwipeDismissTouchListener touchAwareSwipeListener = new TouchAwareSwipeDismissTouchListener(inAppMessageView, null, dismissCallbacks);
            touchAwareSwipeListener.setTouchListener(this.createTouchAwareListener());
            this.mClickableInAppMessageView.setOnTouchListener((View.OnTouchListener)touchAwareSwipeListener);
        } else if (this.mInAppMessage instanceof InAppMessageSlideup) {
            this.mClickableInAppMessageView.setOnTouchListener((View.OnTouchListener)this.getSimpleSwipeListener());
        }
        this.mOpeningAnimation = openingAnimation;
        this.mClosingAnimation = closingAnimation;
        this.mClickableInAppMessageView.setOnClickListener(this.createClickListener());
    }

    public InAppMessageViewWrapper(View inAppMessageView, IInAppMessage inAppMessage, IInAppMessageViewLifecycleListener inAppMessageViewLifecycleListener, Animation openingAnimation, Animation closingAnimation, View clickableInAppMessageView, List<View> buttons, View closeButton) {
        this(inAppMessageView, inAppMessage, inAppMessageViewLifecycleListener, openingAnimation, closingAnimation, clickableInAppMessageView);
        if (closeButton != null) {
            this.mCloseButton = closeButton;
            this.mCloseButton.setOnClickListener(this.createCloseInAppMessageClickListener());
        }
        if (buttons != null) {
            this.mButtons = buttons;
            for (View button : this.mButtons) {
                button.setOnClickListener(this.createButtonClickListener());
            }
        }
    }

    public void open(FrameLayout root) {
        this.mInAppMessageViewLifecycleListener.beforeOpened(this.mInAppMessageView, this.mInAppMessage);
        this.addViewToLayout(root);
        this.display();
    }

    public boolean getIsAnimatingClose() {
        return this.mIsAnimatingClose;
    }

    public void callAfterClosed() {
        this.mInAppMessageViewLifecycleListener.afterClosed(this.mInAppMessage);
    }

    public void callOnDismissed() {
        this.mInAppMessageViewLifecycleListener.onDismissed(this.mInAppMessageView, this.mInAppMessage);
    }

    private void preClose() {
        this.mInAppMessageView.removeCallbacks(this.mDismissRunnable);
        this.mInAppMessageViewLifecycleListener.beforeClosed(this.mInAppMessageView, this.mInAppMessage);
    }

    private void performClose() {
        if (this.mInAppMessage.getAnimateOut()) {
            this.mIsAnimatingClose = true;
            this.setAndStartAnimation(false);
        } else {
            ViewUtils.removeViewFromParent(this.mInAppMessageView);
            this.mInAppMessageViewLifecycleListener.afterClosed(this.mInAppMessage);
        }
    }

    public void close() {
        this.preClose();
        this.performClose();
    }

    public View getInAppMessageView() {
        return this.mInAppMessageView;
    }

    public IInAppMessage getInAppMessage() {
        return this.mInAppMessage;
    }

    private View.OnClickListener createClickListener() {
        return new View.OnClickListener(){

            public void onClick(View view) {
                if (InAppMessageViewWrapper.this.mInAppMessage instanceof IInAppMessageImmersive) {
                    IInAppMessageImmersive inAppMessageImmersive = (IInAppMessageImmersive)InAppMessageViewWrapper.this.mInAppMessage;
                    if (inAppMessageImmersive.getMessageButtons() == null || inAppMessageImmersive.getMessageButtons().size() == 0) {
                        InAppMessageViewWrapper.this.mInAppMessageViewLifecycleListener.onClicked(new InAppMessageCloser(InAppMessageViewWrapper.this), InAppMessageViewWrapper.this.mInAppMessageView, InAppMessageViewWrapper.this.mInAppMessage);
                    }
                } else {
                    InAppMessageViewWrapper.this.mInAppMessageViewLifecycleListener.onClicked(new InAppMessageCloser(InAppMessageViewWrapper.this), InAppMessageViewWrapper.this.mInAppMessageView, InAppMessageViewWrapper.this.mInAppMessage);
                }
            }
        };
    }

    private View.OnClickListener createButtonClickListener() {
        return new View.OnClickListener(){

            public void onClick(View view) {
                IInAppMessageImmersive inAppMessageImmersive = (IInAppMessageImmersive)InAppMessageViewWrapper.this.mInAppMessage;
                for (int i = 0; i < InAppMessageViewWrapper.this.mButtons.size(); ++i) {
                    if (view.getId() != ((View)InAppMessageViewWrapper.this.mButtons.get(i)).getId()) continue;
                    MessageButton messageButton = (MessageButton)inAppMessageImmersive.getMessageButtons().get(i);
                    InAppMessageViewWrapper.this.mInAppMessageViewLifecycleListener.onButtonClicked(new InAppMessageCloser(InAppMessageViewWrapper.this), messageButton, inAppMessageImmersive);
                    return;
                }
            }
        };
    }

    private View.OnClickListener createCloseInAppMessageClickListener() {
        return new View.OnClickListener(){

            public void onClick(View view) {
                InAppMessageViewWrapper.this.mInAppMessageViewLifecycleListener.onDismissed(InAppMessageViewWrapper.this.mInAppMessageView, InAppMessageViewWrapper.this.mInAppMessage);
                InAppMessageViewWrapper.this.close();
            }
        };
    }

    private void addViewToLayout(FrameLayout root) {
        AppboyLogger.d((String)TAG, (String)"Adding In-app message view to root FrameLayout.");
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
        if (this.mInAppMessage instanceof InAppMessageSlideup) {
            InAppMessageSlideup inAppMessageSlideup = (InAppMessageSlideup)this.mInAppMessage;
            int n = layoutParams.gravity = inAppMessageSlideup.getSlideFrom() == SlideFrom.TOP ? 48 : 80;
        }
        if (this.mInAppMessage instanceof IInAppMessageImmersive || this.mInAppMessage instanceof IInAppMessageHtml) {
            this.mInAppMessageView.setFocusableInTouchMode(true);
            this.mInAppMessageView.requestFocus();
        }
        root.addView(this.mInAppMessageView, (ViewGroup.LayoutParams)layoutParams);
    }

    private void display() {
        if (this.mInAppMessage.getAnimateIn()) {
            AppboyLogger.d((String)TAG, (String)"In-app message view will animate into the visible area.");
            this.setAndStartAnimation(true);
        } else {
            AppboyLogger.d((String)TAG, (String)"In-app message view will be placed instantly into the visible area.");
            if (this.mInAppMessage.getDismissType() == DismissType.AUTO_DISMISS) {
                this.addDismissRunnable();
            }
            this.mInAppMessageViewLifecycleListener.afterOpened(this.mInAppMessageView, this.mInAppMessage);
        }
    }

    private void addDismissRunnable() {
        if (this.mDismissRunnable == null) {
            this.mDismissRunnable = new Runnable(){

                @Override
                public void run() {
                    InAppMessageViewWrapper.this.mInAppMessageViewLifecycleListener.onDismissed(InAppMessageViewWrapper.this.mInAppMessageView, InAppMessageViewWrapper.this.mInAppMessage);
                    InAppMessageViewWrapper.this.close();
                }
            };
            this.mInAppMessageView.postDelayed(this.mDismissRunnable, (long)this.mInAppMessage.getDurationInMilliseconds());
        }
    }

    private SwipeDismissTouchListener.DismissCallbacks createDismissCallbacks() {
        return new SwipeDismissTouchListener.DismissCallbacks(){

            @Override
            public boolean canDismiss(Object token) {
                return true;
            }

            @Override
            public void onDismiss(View view, Object token) {
                InAppMessageViewWrapper.this.mInAppMessageViewLifecycleListener.onDismissed(InAppMessageViewWrapper.this.mInAppMessageView, InAppMessageViewWrapper.this.mInAppMessage);
                InAppMessageViewWrapper.this.mInAppMessage.setAnimateOut(false);
                InAppMessageViewWrapper.this.close();
            }
        };
    }

    private TouchAwareSwipeDismissTouchListener.ITouchListener createTouchAwareListener() {
        return new TouchAwareSwipeDismissTouchListener.ITouchListener(){

            @Override
            public void onTouchStartedOrContinued() {
                InAppMessageViewWrapper.this.mInAppMessageView.removeCallbacks(InAppMessageViewWrapper.this.mDismissRunnable);
            }

            @Override
            public void onTouchEnded() {
                if (InAppMessageViewWrapper.this.mInAppMessage.getDismissType() == DismissType.AUTO_DISMISS) {
                    InAppMessageViewWrapper.this.addDismissRunnable();
                }
            }
        };
    }

    private void setAndStartAnimation(boolean opening) {
        Animation animation = opening ? this.mOpeningAnimation : this.mClosingAnimation;
        animation.setAnimationListener(this.createAnimationListener(opening));
        this.mInAppMessageView.clearAnimation();
        this.mInAppMessageView.setAnimation(animation);
        animation.startNow();
        this.mInAppMessageView.invalidate();
    }

    private Animation.AnimationListener createAnimationListener(boolean opening) {
        if (opening) {
            return new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    InAppMessageViewWrapper.this.mInAppMessageView.setClickable(false);
                }

                public void onAnimationEnd(Animation animation) {
                    InAppMessageViewWrapper.this.mInAppMessageView.setVisibility(0);
                    InAppMessageViewWrapper.this.mInAppMessageView.setClickable(true);
                    if (InAppMessageViewWrapper.this.mInAppMessage.getDismissType() == DismissType.AUTO_DISMISS) {
                        InAppMessageViewWrapper.this.addDismissRunnable();
                    }
                    AppboyLogger.d((String)TAG, (String)"In-app message animated into view.");
                    InAppMessageViewWrapper.this.mInAppMessageViewLifecycleListener.afterOpened(InAppMessageViewWrapper.this.mInAppMessageView, InAppMessageViewWrapper.this.mInAppMessage);
                }

                public void onAnimationRepeat(Animation animation) {
                }
            };
        }
        return new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                InAppMessageViewWrapper.this.mInAppMessageView.setClickable(false);
            }

            public void onAnimationEnd(Animation animation) {
                InAppMessageViewWrapper.this.mInAppMessageView.clearAnimation();
                InAppMessageViewWrapper.this.mInAppMessageView.setVisibility(8);
                InAppMessageViewWrapper.this.mInAppMessageView.setClickable(true);
                ViewUtils.removeViewFromParent(InAppMessageViewWrapper.this.mInAppMessageView);
                InAppMessageViewWrapper.this.mInAppMessageViewLifecycleListener.afterClosed(InAppMessageViewWrapper.this.mInAppMessage);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        };
    }

    private SimpleSwipeDismissTouchListener getSimpleSwipeListener() {
        return new SimpleSwipeDismissTouchListener(this.mInAppMessageView.getContext()){
            private final long sSwipeAnimationDurationMillis = 400L;
            {
                this.sSwipeAnimationDurationMillis = 400L;
            }

            @Override
            public void onSwipeLeft() {
                this.animateAndClose(AnimationUtils.createHorizontalAnimation(0.0f, -1.0f, 400L, false));
            }

            @Override
            public void onSwipeRight() {
                this.animateAndClose(AnimationUtils.createHorizontalAnimation(0.0f, 1.0f, 400L, false));
            }

            private void animateAndClose(Animation animation) {
                InAppMessageViewWrapper.this.mInAppMessageViewLifecycleListener.onDismissed(InAppMessageViewWrapper.this.mInAppMessageView, InAppMessageViewWrapper.this.mInAppMessage);
                InAppMessageViewWrapper.this.preClose();
                InAppMessageViewWrapper.this.mInAppMessageView.clearAnimation();
                InAppMessageViewWrapper.this.mInAppMessageView.setAnimation(animation);
                animation.startNow();
                InAppMessageViewWrapper.this.mInAppMessageView.invalidate();
                InAppMessageViewWrapper.this.mInAppMessage.setAnimateOut(false);
                InAppMessageViewWrapper.this.performClose();
            }
        };
    }
}

