/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.ViewTreeObserver;
import android.widget.ImageSwitcher;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.ViewSwitcher;
import com.appboy.Appboy;
import com.appboy.Constants;
import com.appboy.models.cards.Card;
import com.appboy.support.AppboyLogger;
import com.appboy.support.PackageUtils;
import com.appboy.ui.R;
import com.appboy.ui.actions.IAction;
import com.appboy.ui.support.FrescoLibraryUtils;
import com.facebook.drawee.view.SimpleDraweeView;
import java.util.Observable;
import java.util.Observer;

public abstract class BaseCardView<T extends Card>
extends RelativeLayout
implements Observer {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, BaseCardView.class.getName());
    private static Boolean unreadCardVisualIndicatorOn;
    private static final float SQUARE_ASPECT_RATIO = 1.0f;
    private static final String COM_APPBOY_NEWSFEED_UNREAD_VISUAL_INDICATOR_ON = "com_appboy_newsfeed_unread_visual_indicator_on";
    protected final Context mContext;
    protected T mCard;
    protected ImageSwitcher mImageSwitcher;
    private final boolean mCanUseFresco;

    public BaseCardView(Context context) {
        super(context);
        this.mCanUseFresco = FrescoLibraryUtils.canUseFresco(context);
        this.mContext = context;
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater.inflate(this.getLayoutResource(), (ViewGroup)this);
        this.mImageSwitcher = (ImageSwitcher)this.findViewById(R.id.com_appboy_newsfeed_item_read_indicator_image_switcher);
        if (this.mImageSwitcher != null) {
            this.mImageSwitcher.setFactory(new ViewSwitcher.ViewFactory(){

                public View makeView() {
                    return new ImageView(BaseCardView.this.mContext.getApplicationContext());
                }
            });
        }
        if (unreadCardVisualIndicatorOn == null) {
            int resId = this.mContext.getResources().getIdentifier(COM_APPBOY_NEWSFEED_UNREAD_VISUAL_INDICATOR_ON, "bool", PackageUtils.getResourcePackageName((Context)context));
            unreadCardVisualIndicatorOn = resId != 0 ? Boolean.valueOf(context.getResources().getBoolean(resId)) : Boolean.valueOf(true);
        }
        if (!unreadCardVisualIndicatorOn.booleanValue() && this.mImageSwitcher != null) {
            this.mImageSwitcher.setVisibility(8);
        }
    }

    @Override
    public void update(Observable observable, Object data) {
        this.setCardViewedIndicator();
    }

    private void setCardViewedIndicator() {
        if (this.getCard() != null) {
            if (this.mImageSwitcher != null) {
                int resourceId = this.getCard().isRead() ? R.drawable.icon_read : R.drawable.icon_unread;
                this.mImageSwitcher.setImageResource(resourceId);
                this.mImageSwitcher.setTag((Object)String.valueOf(resourceId));
            } else {
                AppboyLogger.d((String)TAG, (String)"The imageSwitcher for the read/unread feature is null. Did you include it in your xml?");
            }
        } else {
            AppboyLogger.d((String)TAG, (String)"The card is null.");
        }
    }

    protected abstract int getLayoutResource();

    public void setCard(T card) {
        this.mCard = card;
        this.onSetCard(card);
        card.addObserver((Observer)this);
        this.setCardViewedIndicator();
    }

    protected abstract void onSetCard(T var1);

    public Card getCard() {
        return this.mCard;
    }

    void setOptionalTextView(TextView view, String value) {
        if (value != null && !value.trim().equals("")) {
            view.setText((CharSequence)value);
            view.setVisibility(0);
        } else {
            view.setText((CharSequence)"");
            view.setVisibility(8);
        }
    }

    void safeSetBackground(Drawable background) {
        if (Build.VERSION.SDK_INT < 16) {
            this.setBackgroundDrawable(background);
        } else {
            this.setBackgroundNew(background);
        }
    }

    @TargetApi(value=16)
    private void setBackgroundNew(Drawable background) {
        this.setBackground(background);
    }

    void setImageViewToUrl(ImageView imageView, String imageUrl) {
        this.setImageViewToUrl(imageView, imageUrl, 1.0f, false);
    }

    void setImageViewToUrl(ImageView imageView, String imageUrl, float aspectRatio) {
        this.setImageViewToUrl(imageView, imageUrl, aspectRatio, true);
    }

    void setImageViewToUrl(final ImageView imageView, String imageUrl, final float aspectRatio, boolean respectAspectRatio) {
        if (imageUrl == null) {
            AppboyLogger.w((String)TAG, (String)"The image url to render is null. Not setting the card image.");
            return;
        }
        if (aspectRatio == 0.0f) {
            AppboyLogger.w((String)TAG, (String)"The image aspect ratio is 0. Not setting the card image.");
            return;
        }
        if (!imageUrl.equals(imageView.getTag())) {
            ViewTreeObserver viewTreeObserver;
            if (aspectRatio != 1.0f && (viewTreeObserver = imageView.getViewTreeObserver()).isAlive()) {
                viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                    public void onGlobalLayout() {
                        int width = imageView.getWidth();
                        imageView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(width, (int)((float)width / aspectRatio)));
                        BaseCardView.removeOnGlobalLayoutListenerSafe(imageView.getViewTreeObserver(), this);
                    }
                });
            }
            imageView.setImageResource(17170445);
            Appboy.getInstance((Context)this.getContext()).fetchAndRenderImage(imageUrl, imageView, respectAspectRatio);
            imageView.setTag((Object)imageUrl);
        }
    }

    @TargetApi(value=16)
    public static void removeOnGlobalLayoutListenerSafe(ViewTreeObserver viewTreeObserver, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
        if (Build.VERSION.SDK_INT < 16) {
            viewTreeObserver.removeGlobalOnLayoutListener(onGlobalLayoutListener);
        } else {
            viewTreeObserver.removeOnGlobalLayoutListener(onGlobalLayoutListener);
        }
    }

    void setSimpleDraweeToUrl(SimpleDraweeView simpleDraweeView, String imageUrl, float aspectRatio, boolean respectAspectRatio) {
        if (imageUrl == null) {
            AppboyLogger.w((String)TAG, (String)"The image url to render is null. Not setting the card image.");
            return;
        }
        FrescoLibraryUtils.setDraweeControllerHelper(simpleDraweeView, imageUrl, aspectRatio, respectAspectRatio);
    }

    boolean canUseFresco() {
        return this.mCanUseFresco;
    }

    protected static void handleCardClick(Context context, Card card, IAction cardAction, String tag) {
        card.setIsRead(true);
        if (cardAction != null) {
            AppboyLogger.d((String)tag, (String)String.format("Logged click for card %s", card.getId()));
            card.logClick();
            cardAction.execute(context);
        }
    }

    View getProperViewFromInflatedStub(int stubLayoutId) {
        ViewStub imageStub = (ViewStub)this.findViewById(stubLayoutId);
        imageStub.inflate();
        if (this.mCanUseFresco) {
            return this.findViewById(R.id.com_appboy_stubbed_feed_drawee_view);
        }
        return this.findViewById(R.id.com_appboy_stubbed_feed_image_view);
    }
}

