/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.widget;

import android.content.Context;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.appboy.models.cards.Card;
import com.appboy.models.cards.CrossPromotionSmallCard;
import com.appboy.ui.R;
import com.appboy.ui.actions.GooglePlayAppDetailsAction;
import com.appboy.ui.actions.IAction;
import com.appboy.ui.support.StringUtils;
import com.appboy.ui.widget.BaseCardView;
import com.appboy.ui.widget.StarRatingView;
import com.facebook.drawee.view.SimpleDraweeView;
import java.text.NumberFormat;
import java.util.Locale;

public class CrossPromotionSmallCardView
extends BaseCardView<CrossPromotionSmallCard> {
    private final TextView mTitle = (TextView)this.findViewById(R.id.com_appboy_cross_promotion_small_card_title);
    private final TextView mSubtitle = (TextView)this.findViewById(R.id.com_appboy_cross_promotion_small_card_subtitle);
    private final TextView mReviewCount = (TextView)this.findViewById(R.id.com_appboy_cross_promotion_small_card_review_count);
    private final TextView mCaption = (TextView)this.findViewById(R.id.com_appboy_cross_promotion_small_card_recommendation_tab);
    private final StarRatingView mStarRating = (StarRatingView)this.findViewById(R.id.com_appboy_cross_promotion_small_card_star_rating);
    private ImageView mImage;
    private SimpleDraweeView mDrawee;
    private final Button mPrice = (Button)this.findViewById(R.id.com_appboy_cross_promotion_small_card_price);
    private IAction mPriceAction;
    private final float mAspectRatio = 1.0f;
    private static final String TAG = String.format("%s.%s", "Appboy", CrossPromotionSmallCardView.class.getName());

    public CrossPromotionSmallCardView(Context context) {
        this(context, null);
    }

    public CrossPromotionSmallCardView(Context context, CrossPromotionSmallCard card) {
        super(context);
        if (this.canUseFresco()) {
            this.mDrawee = (SimpleDraweeView)this.getProperViewFromInflatedStub(R.id.com_appboy_cross_promotion_small_card_drawee_stub);
        } else {
            this.mImage = (ImageView)this.getProperViewFromInflatedStub(R.id.com_appboy_cross_promotion_small_card_imageview_stub);
        }
        if (card != null) {
            this.setCard(card);
        }
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.com_appboy_cross_promotion_small_card;
    }

    @Override
    public void onSetCard(final CrossPromotionSmallCard card) {
        this.mTitle.setText((CharSequence)card.getTitle());
        if (card.getSubtitle() == null || card.getSubtitle().toUpperCase(Locale.getDefault()).equals("NULL")) {
            this.mSubtitle.setVisibility(8);
        } else {
            this.mSubtitle.setText((CharSequence)card.getSubtitle().toUpperCase(Locale.getDefault()));
        }
        this.mCaption.setText((CharSequence)card.getCaption().toUpperCase(Locale.getDefault()));
        if (card.getRating() <= 0.0) {
            this.mReviewCount.setVisibility(8);
            this.mStarRating.setVisibility(8);
        } else {
            this.mReviewCount.setText((CharSequence)String.format("(%s)", NumberFormat.getInstance().format(card.getReviewCount())));
            this.mStarRating.setRating((float)card.getRating());
        }
        if (!StringUtils.isNullOrBlank(card.getDisplayPrice())) {
            this.mPrice.setText((CharSequence)card.getDisplayPrice());
        } else {
            this.mPrice.setText((CharSequence)this.getPriceString(card.getPrice()));
        }
        this.mPriceAction = new GooglePlayAppDetailsAction(card.getPackage(), false, card.getAppStore(), card.getKindleId());
        this.mPrice.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BaseCardView.handleCardClick(CrossPromotionSmallCardView.this.mContext, (Card)card, CrossPromotionSmallCardView.this.mPriceAction, TAG);
            }
        });
        if (this.canUseFresco()) {
            this.setSimpleDraweeToUrl(this.mDrawee, card.getImageUrl(), 1.0f, true);
        } else {
            this.setImageViewToUrl(this.mImage, card.getImageUrl(), 1.0f);
        }
    }

    private String getPriceString(double price) {
        if (price == 0.0) {
            return this.mContext.getString(R.string.com_appboy_recommendation_free);
        }
        return NumberFormat.getCurrencyInstance(Locale.US).format(price);
    }
}

