/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.appboy.Constants;
import com.appboy.support.AppboyLogger;
import com.appboy.ui.R;
import java.util.ArrayList;
import java.util.List;

public class StarRatingView
extends LinearLayout {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, StarRatingView.class.getName());
    private static final int MAX_NUMBER_OF_STARS = 5;
    private List<ImageView> mStarRating;
    private float mRating = 0.0f;

    public StarRatingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOrientation(0);
        this.mStarRating = new ArrayList<ImageView>(5);
        for (int i = 0; i < 5; ++i) {
            ImageView star = new ImageView(context);
            star.setTag((Object)0);
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -2);
            this.addView((View)star, layoutParams);
            this.mStarRating.add(star);
        }
        this.setRating(this.mRating);
    }

    public float getRating() {
        return this.mRating;
    }

    public boolean setRating(float rating) {
        ImageView star;
        int starIndex;
        if (rating < 0.0f || rating > 5.0f) {
            AppboyLogger.e((String)TAG, (String)String.format("Unable to set rating to %f. Rating must be between 0 and %d", Float.valueOf(rating), 5));
            return false;
        }
        this.mRating = rating;
        int ratingRoundedDown = (int)Math.floor(this.mRating);
        int ratingRoundedUp = (int)Math.ceil(this.mRating);
        for (starIndex = 0; starIndex < ratingRoundedDown; ++starIndex) {
            star = this.mStarRating.get(starIndex);
            star.setTag((Object)R.drawable.com_appboy_rating_full_star);
            star.setImageResource(R.drawable.com_appboy_rating_full_star);
        }
        for (starIndex = ratingRoundedUp; starIndex < this.mStarRating.size(); ++starIndex) {
            star = this.mStarRating.get(starIndex);
            star.setTag((Object)R.drawable.com_appboy_rating_empty_star);
            star.setImageResource(R.drawable.com_appboy_rating_empty_star);
        }
        float remainder = rating - (float)ratingRoundedDown;
        if (remainder > 0.0f) {
            star = this.mStarRating.get(ratingRoundedDown);
            if (remainder < 0.25f) {
                star.setTag((Object)R.drawable.com_appboy_rating_empty_star);
                star.setImageResource(R.drawable.com_appboy_rating_empty_star);
            } else if (remainder < 0.75f) {
                star.setTag((Object)R.drawable.com_appboy_rating_half_star);
                star.setImageResource(R.drawable.com_appboy_rating_half_star);
            } else {
                star.setTag((Object)R.drawable.com_appboy_rating_full_star);
                star.setImageResource(R.drawable.com_appboy_rating_full_star);
            }
        }
        return true;
    }

    List<ImageView> getImageViewList() {
        return this.mStarRating;
    }
}

