/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.support;

import bo.app.gs;
import bo.app.gt;
import bo.app.hx;
import com.appboy.Constants;
import com.appboy.support.AppboyLogger;
import java.util.Set;

public final class ValidationUtils {
    private static final String a = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, ValidationUtils.class.getName());
    public static final int APPBOY_STRING_MAX_LENGTH = 255;
    public static final gs<String> CUSTOM_ATTRIBUTE_RESERVED_KEY_PREFIXES = new gt<String>().c("appboy").a();
    public static final gs<String> CUSTOM_ATTRIBUTE_RESERVED_KEYS = new gt<String>().c("first_name").c("last_name").c("email").c("gender").c("dob").c("country").c("home_city").c("email_subscribe").c("push_subscribe").c("phone").c("facebook").c("twitter").c("image_url").a();
    private static String b = "(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])";
    private static String c = "^[0-9 .\\(\\)\\+\\-]+$";

    public static boolean isValidEmailAddress(String emailAddress) {
        String string2;
        return emailAddress != null && string2.toLowerCase().matches(b);
    }

    public static boolean isValidPhoneNumber(String phoneNumber) {
        String string2;
        return phoneNumber != null && string2.matches(c);
    }

    public static boolean isValidCustomAttributeKey(String key) {
        String string2;
        if (key == null) {
            AppboyLogger.w(a, "Custom attribute key cannot be null.");
            return false;
        }
        return !ValidationUtils.customAttributeKeyHasReservedPrefix(key) && !ValidationUtils.customAttributeKeyIsReservedKey(string2);
    }

    public static boolean isBlacklistedCustomAttributeKey(String key, Set<String> blacklistedAttributes) {
        if (blacklistedAttributes.contains(key)) {
            String string2;
            AppboyLogger.w(a, String.format("Custom attribute key cannot be blacklisted attribute: %s.", string2));
            return true;
        }
        return false;
    }

    public static boolean isValidCustomAttributeValue(String value) {
        if (value == null) {
            AppboyLogger.w(a, "Custom attribute value cannot be null.");
            return false;
        }
        return true;
    }

    public static boolean customAttributeKeyHasReservedPrefix(String key) {
        key = key.trim();
        hx<String> hx2 = CUSTOM_ATTRIBUTE_RESERVED_KEY_PREFIXES.a();
        while (hx2.hasNext()) {
            String string2 = (String)hx2.next();
            if (!key.toLowerCase().startsWith(string2)) continue;
            AppboyLogger.w(a, String.format("'%s' contains a reserved prefix. Cannot use the given key.", key));
            return true;
        }
        return false;
    }

    public static boolean customAttributeKeyIsReservedKey(String key) {
        if (CUSTOM_ATTRIBUTE_RESERVED_KEYS.contains(key = key.trim())) {
            String string2;
            AppboyLogger.w(a, String.format("'%s' is a reserved attribute key. Cannot use the given key.", string2));
            return true;
        }
        return false;
    }

    public static String[] ensureCustomAttributeArrayValues(String[] values) {
        String[] stringArray;
        if (values != null && values.length > 0) {
            for (int i2 = 0; i2 < values.length; ++i2) {
                values[i2] = ValidationUtils.ensureAppboyFieldLength(values[i2]);
            }
        }
        return stringArray;
    }

    public static String ensureAppboyFieldLength(String field) {
        String string2;
        if ((field = field.trim()).length() > 255) {
            AppboyLogger.w(a, String.format("Provided string field is too long [%d]. The max length is %d, truncating provided field.", field.length(), 255));
            field = field.substring(0, 255);
        }
        return string2;
    }
}

