/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.push;

import android.app.Notification;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import android.widget.RemoteViews;
import com.appboy.IAppboyNotificationFactory;
import com.appboy.configuration.XmlAppConfigurationProvider;
import com.appboy.push.AppboyNotificationActionUtils;
import com.appboy.push.AppboyNotificationRemoteViewsUtils;
import com.appboy.push.AppboyNotificationUtils;
import com.appboy.push.AppboyWearableNotificationUtils;

public class AppboyNotificationFactory
implements IAppboyNotificationFactory {
    private static volatile AppboyNotificationFactory sInstance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppboyNotificationFactory getInstance() {
        if (sInstance != null) return sInstance;
        Class<AppboyNotificationFactory> clazz = AppboyNotificationFactory.class;
        synchronized (AppboyNotificationFactory.class) {
            if (sInstance != null) return sInstance;
            sInstance = new AppboyNotificationFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public Notification createNotification(XmlAppConfigurationProvider appConfigurationProvider, Context context, Bundle notificationExtras, Bundle appboyExtras) {
        RemoteViews remoteViews;
        NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(context).setAutoCancel(true);
        AppboyNotificationUtils.setTitleIfPresent(notificationBuilder, notificationExtras);
        AppboyNotificationUtils.setContentIfPresent(notificationBuilder, notificationExtras);
        AppboyNotificationUtils.setTickerIfPresent(notificationBuilder, notificationExtras);
        AppboyNotificationUtils.setContentIntentIfPresent(context, notificationBuilder, notificationExtras);
        int smallNotificationIconResourceId = AppboyNotificationUtils.setSmallIcon(appConfigurationProvider, notificationBuilder);
        boolean usingLargeIcon = AppboyNotificationUtils.setLargeIconIfPresentAndSupported(context, appConfigurationProvider, notificationBuilder);
        AppboyNotificationUtils.setSoundIfPresentAndSupported(notificationBuilder, notificationExtras);
        if (Build.VERSION.SDK_INT >= 11 && Build.VERSION.SDK_INT < 16 && (remoteViews = AppboyNotificationRemoteViewsUtils.createMultiLineContentNotificationView(context, notificationExtras, smallNotificationIconResourceId, !usingLargeIcon)) != null) {
            notificationBuilder.setContent(remoteViews);
            return notificationBuilder.build();
        }
        AppboyNotificationUtils.setSummaryTextIfPresentAndSupported(notificationBuilder, notificationExtras);
        AppboyNotificationUtils.setPriorityIfPresentAndSupported(notificationBuilder, notificationExtras);
        AppboyNotificationUtils.setStyleIfSupported(context, notificationBuilder, notificationExtras, appboyExtras);
        AppboyNotificationActionUtils.addNotificationActions(context, notificationBuilder, notificationExtras);
        AppboyNotificationUtils.setAccentColorIfPresentAndSupported(appConfigurationProvider, notificationBuilder, notificationExtras);
        AppboyNotificationUtils.setCategoryIfPresentAndSupported(notificationBuilder, notificationExtras);
        AppboyNotificationUtils.setVisibilityIfPresentAndSupported(notificationBuilder, notificationExtras);
        AppboyNotificationUtils.setPublicVersionIfPresentAndSupported(context, appConfigurationProvider, notificationBuilder, notificationExtras);
        AppboyWearableNotificationUtils.setWearableNotificationFeaturesIfPresentAndSupported(context, notificationBuilder, notificationExtras);
        return notificationBuilder.build();
    }
}

