/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.ListFragment;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.appboy.Appboy;
import com.appboy.Constants;
import com.appboy.enums.CardCategory;
import com.appboy.events.FeedUpdatedEvent;
import com.appboy.events.IEventSubscriber;
import com.appboy.models.cards.Card;
import com.appboy.support.AppboyLogger;
import com.appboy.ui.R;
import com.appboy.ui.adapters.AppboyListAdapter;
import java.util.ArrayList;
import java.util.EnumSet;

public class AppboyFeedFragment
extends ListFragment
implements SwipeRefreshLayout.OnRefreshListener {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, AppboyFeedFragment.class.getName());
    private static final int NETWORK_PROBLEM_WARNING_MS = 5000;
    private static final int MAX_FEED_TTL_SECONDS = 60;
    private static final long AUTO_HIDE_REFRESH_INDICATOR_DELAY_MS = 2500L;
    private final Handler mMainThreadLooper = new Handler(Looper.getMainLooper());
    private final Runnable mShowNetworkError = new Runnable(){

        @Override
        public void run() {
            if (AppboyFeedFragment.this.mLoadingSpinner != null) {
                AppboyFeedFragment.this.mLoadingSpinner.setVisibility(8);
            }
            if (AppboyFeedFragment.this.mNetworkErrorLayout != null) {
                AppboyFeedFragment.this.mNetworkErrorLayout.setVisibility(0);
            }
        }
    };
    private Appboy mAppboy;
    private IEventSubscriber<FeedUpdatedEvent> mFeedUpdatedSubscriber;
    private AppboyListAdapter mAdapter;
    private LinearLayout mNetworkErrorLayout;
    private LinearLayout mEmptyFeedLayout;
    private ProgressBar mLoadingSpinner;
    private RelativeLayout mFeedRootLayout;
    private boolean mSkipCardImpressionsReset;
    private EnumSet<CardCategory> mCategories;
    private SwipeRefreshLayout mFeedSwipeLayout;
    private int previousVisibleHeadCardIndex;
    private int currentCardIndexAtBottomOfScreen;
    private GestureDetectorCompat mGestureDetector;
    private View mTransparentFullBoundsContainerView;

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mAppboy = Appboy.getInstance((Context)activity);
        if (this.mAdapter == null) {
            this.mAdapter = new AppboyListAdapter((Context)activity, R.id.tag, new ArrayList<Card>());
            this.mCategories = CardCategory.ALL_CATEGORIES;
        }
        this.setRetainInstance(true);
        this.mGestureDetector = new GestureDetectorCompat((Context)activity, (GestureDetector.OnGestureListener)new FeedGestureListener());
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup container, Bundle savedInstanceState) {
        View view = layoutInflater.inflate(R.layout.com_appboy_feed, container, false);
        this.mNetworkErrorLayout = (LinearLayout)view.findViewById(R.id.com_appboy_feed_network_error);
        this.mLoadingSpinner = (ProgressBar)view.findViewById(R.id.com_appboy_feed_loading_spinner);
        this.mEmptyFeedLayout = (LinearLayout)view.findViewById(R.id.com_appboy_feed_empty_feed);
        this.mFeedRootLayout = (RelativeLayout)view.findViewById(R.id.com_appboy_feed_root);
        this.mFeedSwipeLayout = (SwipeRefreshLayout)view.findViewById(R.id.appboy_feed_swipe_container);
        this.mFeedSwipeLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.mFeedSwipeLayout.setEnabled(false);
        this.mFeedSwipeLayout.setColorSchemeResources(new int[]{R.color.com_appboy_newsfeed_swipe_refresh_color_1, R.color.com_appboy_newsfeed_swipe_refresh_color_2, R.color.com_appboy_newsfeed_swipe_refresh_color_3, R.color.com_appboy_newsfeed_swipe_refresh_color_4});
        this.mTransparentFullBoundsContainerView = view.findViewById(R.id.com_appboy_feed_transparent_full_bounds_container_view);
        return view;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (this.mSkipCardImpressionsReset) {
            this.mSkipCardImpressionsReset = false;
        } else {
            this.mAdapter.resetCardImpressionTracker();
            AppboyLogger.d((String)TAG, (String)"Resetting card impressions.");
        }
        LayoutInflater inflater = LayoutInflater.from((Context)this.getActivity());
        final ListView listView = this.getListView();
        listView.addHeaderView(inflater.inflate(R.layout.com_appboy_feed_header, null));
        listView.addFooterView(inflater.inflate(R.layout.com_appboy_feed_footer, null));
        this.mFeedRootLayout.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                return AppboyFeedFragment.this.mGestureDetector.onTouchEvent(motionEvent);
            }
        });
        listView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int scrollState) {
            }

            public void onScroll(AbsListView absListView, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                AppboyFeedFragment.this.mFeedSwipeLayout.setEnabled(firstVisibleItem == 0);
                if (visibleItemCount == 0) {
                    return;
                }
                int currentVisibleHeadCardIndex = firstVisibleItem - 1;
                if (currentVisibleHeadCardIndex > AppboyFeedFragment.this.previousVisibleHeadCardIndex) {
                    AppboyFeedFragment.this.mAdapter.batchSetCardsToRead(AppboyFeedFragment.this.previousVisibleHeadCardIndex, currentVisibleHeadCardIndex);
                }
                AppboyFeedFragment.this.previousVisibleHeadCardIndex = currentVisibleHeadCardIndex;
                AppboyFeedFragment.this.currentCardIndexAtBottomOfScreen = firstVisibleItem + visibleItemCount;
            }
        });
        this.mTransparentFullBoundsContainerView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                return view.getVisibility() == 0;
            }
        });
        this.mAppboy.removeSingleSubscription(this.mFeedUpdatedSubscriber, FeedUpdatedEvent.class);
        this.mFeedUpdatedSubscriber = new IEventSubscriber<FeedUpdatedEvent>(){

            public void trigger(final FeedUpdatedEvent event) {
                FragmentActivity activity = AppboyFeedFragment.this.getActivity();
                if (activity == null) {
                    return;
                }
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        AppboyLogger.d((String)TAG, (String)("Updating feed views in response to FeedUpdatedEvent: " + event));
                        AppboyFeedFragment.this.mMainThreadLooper.removeCallbacks(AppboyFeedFragment.this.mShowNetworkError);
                        AppboyFeedFragment.this.mNetworkErrorLayout.setVisibility(8);
                        if (event.getCardCount(AppboyFeedFragment.this.mCategories) == 0) {
                            listView.setVisibility(8);
                            AppboyFeedFragment.this.mAdapter.clear();
                        } else {
                            AppboyFeedFragment.this.mEmptyFeedLayout.setVisibility(8);
                            AppboyFeedFragment.this.mLoadingSpinner.setVisibility(8);
                            AppboyFeedFragment.this.mTransparentFullBoundsContainerView.setVisibility(8);
                        }
                        if (event.isFromOfflineStorage() && (event.lastUpdatedInSecondsFromEpoch() + 60L) * 1000L < System.currentTimeMillis()) {
                            AppboyLogger.i((String)TAG, (String)String.format("Feed received was older than the max time to live of %d seconds, displaying it for now, but requesting an updated view from the server.", 60));
                            AppboyFeedFragment.this.mAppboy.requestFeedRefresh();
                            if (event.getCardCount(AppboyFeedFragment.this.mCategories) == 0) {
                                AppboyLogger.d((String)TAG, (String)String.format("Old feed was empty, putting up a network spinner and registering the network error message on a delay of %dms.", 5000));
                                AppboyFeedFragment.this.mEmptyFeedLayout.setVisibility(8);
                                AppboyFeedFragment.this.mLoadingSpinner.setVisibility(0);
                                AppboyFeedFragment.this.mTransparentFullBoundsContainerView.setVisibility(0);
                                AppboyFeedFragment.this.mMainThreadLooper.postDelayed(AppboyFeedFragment.this.mShowNetworkError, 5000L);
                                return;
                            }
                        }
                        if (event.getCardCount(AppboyFeedFragment.this.mCategories) == 0) {
                            AppboyFeedFragment.this.mLoadingSpinner.setVisibility(8);
                            AppboyFeedFragment.this.mEmptyFeedLayout.setVisibility(0);
                            AppboyFeedFragment.this.mTransparentFullBoundsContainerView.setVisibility(0);
                        } else {
                            AppboyFeedFragment.this.mAdapter.replaceFeed(event.getFeedCards(AppboyFeedFragment.this.mCategories));
                            listView.setVisibility(0);
                        }
                        AppboyFeedFragment.this.mFeedSwipeLayout.setRefreshing(false);
                    }
                });
            }
        };
        this.mAppboy.subscribeToFeedUpdates(this.mFeedUpdatedSubscriber);
        listView.setAdapter((ListAdapter)this.mAdapter);
        this.mAppboy.requestFeedRefreshFromCache();
    }

    public void onResume() {
        super.onResume();
        Appboy.getInstance((Context)this.getActivity()).logFeedDisplayed();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mAppboy.removeSingleSubscription(this.mFeedUpdatedSubscriber, FeedUpdatedEvent.class);
        this.setOnScreenCardsToRead();
    }

    public void onPause() {
        super.onPause();
        this.setOnScreenCardsToRead();
    }

    private void setOnScreenCardsToRead() {
        this.mAdapter.batchSetCardsToRead(this.previousVisibleHeadCardIndex, this.currentCardIndexAtBottomOfScreen);
    }

    public void onDetach() {
        super.onDetach();
        this.setListAdapter(null);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.isVisible()) {
            this.mSkipCardImpressionsReset = true;
        }
    }

    public EnumSet<CardCategory> getCategories() {
        return this.mCategories;
    }

    public void setCategory(CardCategory category) {
        this.setCategories(EnumSet.of(category));
    }

    public void setCategories(EnumSet<CardCategory> categories) {
        if (categories == null) {
            AppboyLogger.i((String)TAG, (String)"The categories passed into setCategories are null, AppboyFeedFragment is going to display all the cards in cache.");
            this.mCategories = CardCategory.ALL_CATEGORIES;
        } else {
            if (categories.isEmpty()) {
                AppboyLogger.w((String)TAG, (String)"The categories set had no elements and have been ignored. Please pass a valid EnumSet of CardCategory.");
                return;
            }
            if (categories.equals(this.mCategories)) {
                return;
            }
            this.mCategories = categories;
        }
        if (this.mAppboy != null) {
            this.mAppboy.requestFeedRefreshFromCache();
        }
    }

    public void onRefresh() {
        this.mAppboy.requestFeedRefresh();
        this.mMainThreadLooper.postDelayed(new Runnable(){

            @Override
            public void run() {
                AppboyFeedFragment.this.mFeedSwipeLayout.setRefreshing(false);
            }
        }, 2500L);
    }

    public class FeedGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        public boolean onDown(MotionEvent motionEvent) {
            return true;
        }

        public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float dx, float dy) {
            AppboyFeedFragment.this.getListView().smoothScrollBy((int)dy, 0);
            return true;
        }

        public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float velocityX, float velocityY) {
            long deltaTimeMillis = (motionEvent2.getEventTime() - motionEvent.getEventTime()) * 2L;
            int scrollDistance = (int)(velocityY * (float)deltaTimeMillis / 1000.0f);
            AppboyFeedFragment.this.getListView().smoothScrollBy(-scrollDistance, (int)(deltaTimeMillis * 2L));
            return true;
        }
    }
}

