/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.events;

import com.appboy.Constants;
import com.appboy.enums.CardCategory;
import com.appboy.models.cards.Card;
import com.appboy.support.AppboyLogger;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public final class FeedUpdatedEvent {
    private static final String a = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, FeedUpdatedEvent.class.getName());
    private final List<Card> b;
    private final String c;
    private final boolean d;
    private final long e;

    /*
     * WARNING - void declaration
     */
    public FeedUpdatedEvent(List<Card> feedCards, String userId, boolean isFromOfflineStorage, long timestamp) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.c = var2_2;
        this.d = var3_3;
        if (feedCards == null) {
            throw new NullPointerException();
        }
        this.b = var1_1;
        this.e = timestamp;
    }

    public final boolean isFromOfflineStorage() {
        return this.d;
    }

    public final List<Card> getFeedCards() {
        return this.getFeedCards(CardCategory.ALL_CATEGORIES);
    }

    /*
     * WARNING - void declaration
     */
    public final List<Card> getFeedCards(CardCategory category) {
        void var1_1;
        return this.getFeedCards(EnumSet.of(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final List<Card> getFeedCards(EnumSet<CardCategory> categories) {
        try {
            if (this.b == null) {
                AppboyLogger.i(a, "There are no cards targeted to this user in the Appboy News Feed, you can call Appboy.requestFeedRefresh(),and try to call getFeedCards(categories) again when you receive a new feed updated event, or check your Appboy dashboard and make sure there are cards in the segment.");
                return new ArrayList<Card>();
            }
            if (categories == null) {
                AppboyLogger.i(a, "The categories passed to getFeedCards are null, FeedUpdatedEvent is going to return all the cards in cache.");
                categories = CardCategory.ALL_CATEGORIES;
            }
            if (categories.isEmpty()) {
                AppboyLogger.w(a, "The parameter passed into categories is not valid, Appboy is returning an empty card list.Please pass in a non-empty EnumSet of CardCategory for getFeedCards().");
                return new ArrayList<Card>();
            }
            ArrayList<Card> arrayList = new ArrayList<Card>();
            for (Card card : this.b) {
                if (!card.isInCategorySet(categories) || card.isExpired()) continue;
                arrayList.add(card);
            }
            return arrayList;
        }
        catch (Exception exception) {
            void var1_1;
            AppboyLogger.w(a, String.format("Unable to get cards with categories[%s]. Ignoring.", var1_1), exception);
            return null;
        }
    }

    public final String getUserId() {
        return this.c;
    }

    public final int getCardCount() {
        return this.getCardCount(CardCategory.ALL_CATEGORIES);
    }

    /*
     * WARNING - void declaration
     */
    public final int getCardCount(CardCategory category) {
        void var1_1;
        return this.getCardCount(EnumSet.of(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final int getCardCount(EnumSet<CardCategory> categories) {
        void var1_1;
        if (categories == null) {
            AppboyLogger.i(a, "The categories passed into getCardCount are null, FeedUpdatedEvent is going to return the count of all the cards in cache.");
            return this.b.size();
        }
        if (categories.isEmpty()) {
            AppboyLogger.w(a, "The parameters passed into categories are not valid, Appboy is returning 0 in getCardCount().Please pass in a non-empty EnumSet of CardCategory.");
            return 0;
        }
        return this.getFeedCards((EnumSet<CardCategory>)var1_1).size();
    }

    public final int getUnreadCardCount() {
        return this.getUnreadCardCount(CardCategory.ALL_CATEGORIES);
    }

    /*
     * WARNING - void declaration
     */
    public final int getUnreadCardCount(CardCategory category) {
        void var1_1;
        return this.getUnreadCardCount(EnumSet.of(var1_1));
    }

    public final int getUnreadCardCount(EnumSet<CardCategory> categories) {
        while (categories == null) {
            AppboyLogger.w(a, "The categories passed to getUnreadCardCount are null, FeedUpdatedEvent is going to return the count of all the unread cards in cache.");
            categories = CardCategory.ALL_CATEGORIES;
        }
        if (categories.isEmpty()) {
            AppboyLogger.w(a, "The parameters passed into categories are Empty, Appboy is returning 0 in getUnreadCardCount().Please pass in a non-empty EnumSet of CardCategory.");
            return 0;
        }
        int n2 = 0;
        for (Card card : this.b) {
            if (!card.isInCategorySet(categories) || card.getViewed() || card.isExpired()) continue;
            ++n2;
        }
        return n2;
    }

    public final long lastUpdatedInSecondsFromEpoch() {
        return this.e;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("FeedUpdatedEvent{");
        stringBuilder.append("mFeedCards=").append(this.b);
        stringBuilder.append(", mUserId='").append(this.c).append('\'');
        stringBuilder.append(", mFromOfflineStorage=").append(this.d);
        stringBuilder.append(", mTimestamp=").append(this.e);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

