/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.inappmessage.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import com.appboy.models.MessageButton;
import com.appboy.support.StringUtils;
import com.appboy.ui.R;
import com.appboy.ui.inappmessage.IInAppMessageImmersiveView;
import com.appboy.ui.inappmessage.views.AppboyInAppMessageBaseView;
import com.appboy.ui.inappmessage.views.InAppMessageViewUtils;
import com.appboy.ui.support.ViewUtils;
import java.util.List;

public abstract class AppboyInAppMessageImmersiveBaseView
extends AppboyInAppMessageBaseView
implements IInAppMessageImmersiveView {
    public AppboyInAppMessageImmersiveBaseView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public abstract List<View> getMessageButtonViews();

    public void setMessageButtons(List<MessageButton> messageButtons) {
        View buttonLayout = this.getMessageButtonsView();
        int backgroundColor = this.getContext().getResources().getColor(R.color.com_appboy_inappmessage_button_bg_light);
        InAppMessageViewUtils.setButtons(this.getMessageButtonViews(), buttonLayout, backgroundColor, messageButtons);
        InAppMessageViewUtils.resetButtonSizesIfNecessary(this.getMessageButtonViews(), messageButtons);
    }

    public void setMessageCloseButtonColor(int color2) {
        InAppMessageViewUtils.setViewBackgroundColorFilter(this.getMessageCloseButtonView(), color2, this.getContext().getResources().getColor(R.color.com_appboy_inappmessage_button_close_light));
    }

    public void setMessageHeaderTextColor(int color2) {
        InAppMessageViewUtils.setTextViewColor(this.getMessageHeaderTextView(), color2);
    }

    public void setMessageHeaderText(String text) {
        this.getMessageHeaderTextView().setText((CharSequence)text);
    }

    @Override
    public void resetMessageMargins() {
        boolean successful = false;
        if (this.getMessageImageView() != null && this.getMessageImageView().getDrawable() != null) {
            successful = true;
        }
        this.resetMessageMargins(successful);
    }

    @Override
    public void resetMessageMargins(boolean imageRetrievalSuccessful) {
        super.resetMessageMargins(imageRetrievalSuccessful);
        if (StringUtils.isNullOrBlank((String)this.getMessageTextView().getText().toString())) {
            ViewUtils.removeViewFromParent((View)this.getMessageTextView());
        }
        if (StringUtils.isNullOrBlank((String)this.getMessageHeaderTextView().getText().toString())) {
            ViewUtils.removeViewFromParent((View)this.getMessageHeaderTextView());
        }
        InAppMessageViewUtils.resetMessageMarginsIfNecessary(this.getMessageTextView(), this.getMessageHeaderTextView());
    }

    public abstract View getMessageButtonsView();

    @Override
    public abstract TextView getMessageTextView();

    public abstract TextView getMessageHeaderTextView();

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            InAppMessageViewUtils.closeInAppMessageOnKeycodeBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }
}

