/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.push;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import com.appboy.Constants;
import com.appboy.support.AppboyImageUtils;
import com.appboy.support.AppboyLogger;

public class AppboyWearableNotificationUtils {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, AppboyWearableNotificationUtils.class.getName());

    public static void setWearableNotificationFeaturesIfPresentAndSupported(Context context, NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        if (notificationExtras != null) {
            String uriString;
            Bitmap wearNotificationBackgroundBitmap;
            NotificationCompat.WearableExtender wearableExtender = new NotificationCompat.WearableExtender();
            if (notificationExtras.containsKey("ab_wi")) {
                Boolean wearableHideIcon = Boolean.parseBoolean(notificationExtras.getString("ab_wi"));
                wearableExtender.setHintHideIcon(wearableHideIcon.booleanValue());
            }
            if (notificationExtras.containsKey("ab_wb") && (wearNotificationBackgroundBitmap = AppboyImageUtils.getBitmap((Uri)Uri.parse((String)(uriString = notificationExtras.getString("ab_wb"))))) != null) {
                wearableExtender.setBackground(wearNotificationBackgroundBitmap);
            }
            int currentPageIndex = 0;
            while (AppboyWearableNotificationUtils.isWearExtraPagePresentInBundle(notificationExtras, currentPageIndex)) {
                String extraPageTitle = notificationExtras.getString("ab_we_t" + currentPageIndex);
                String extraPageText = notificationExtras.getString("ab_we_c" + currentPageIndex);
                if (extraPageText == null || extraPageTitle == null) {
                    AppboyLogger.d((String)TAG, (String)String.format("The title or content of extra page %s was null. Adding no further extra pages.", currentPageIndex));
                    break;
                }
                NotificationCompat.BigTextStyle extraPageStyle = new NotificationCompat.BigTextStyle();
                extraPageStyle.bigText((CharSequence)extraPageText);
                Notification wearExtraPageNotification = new NotificationCompat.Builder(context).setContentTitle((CharSequence)extraPageTitle).setStyle((NotificationCompat.Style)extraPageStyle).build();
                wearableExtender.addPage(wearExtraPageNotification);
                ++currentPageIndex;
            }
            notificationBuilder.extend((NotificationCompat.Extender)wearableExtender);
        }
    }

    private static boolean isWearExtraPagePresentInBundle(Bundle appboyExtras, int pageNumber) {
        String titleKey = "ab_we_t" + pageNumber;
        String textKey = "ab_we_c" + pageNumber;
        return appboyExtras.containsKey(titleKey) && appboyExtras.containsKey(textKey);
    }
}

