/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.actions;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import com.appboy.support.StringUtils;
import com.appboy.ui.actions.ActivityAction;
import com.appboy.ui.actions.IAction;
import com.appboy.ui.actions.ViewAction;
import com.appboy.ui.actions.WebAction;

public class ActionFactory {
    public static IAction createUriAction(Context context, String url) {
        return ActionFactory.createUriAction(context, url, null);
    }

    public static IAction createUriAction(Context context, String url, Bundle extras) {
        if (!StringUtils.isNullOrBlank((String)url)) {
            Uri uri = Uri.parse((String)url);
            if (WebAction.getSupportedSchemes().contains(uri.getScheme())) {
                return new WebAction(url, extras);
            }
            if ("intent".equals(uri.getScheme())) {
                return new ActivityAction(context.getPackageName(), uri, extras);
            }
            return new ViewAction(uri, extras);
        }
        return null;
    }

    public static IAction createViewUriAction(String url, Bundle extras) {
        if (!StringUtils.isNullOrBlank((String)url)) {
            Uri uri = Uri.parse((String)url);
            return new ViewAction(uri, extras);
        }
        return null;
    }
}

