/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.widget;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.appboy.models.cards.CaptionedImageCard;
import com.appboy.models.cards.Card;
import com.appboy.ui.R;
import com.appboy.ui.actions.ActionFactory;
import com.appboy.ui.actions.IAction;
import com.appboy.ui.widget.BaseCardView;
import com.facebook.drawee.view.SimpleDraweeView;

public class CaptionedImageCardView
extends BaseCardView<CaptionedImageCard> {
    private ImageView mImage;
    private final TextView mTitle;
    private final TextView mDescription;
    private final TextView mDomain;
    private SimpleDraweeView mDrawee;
    private IAction mCardAction;
    private static final String TAG = String.format("%s.%s", "Appboy", CaptionedImageCardView.class.getName());
    private float mAspectRatio = 1.3333334f;

    public CaptionedImageCardView(Context context) {
        this(context, null);
    }

    public CaptionedImageCardView(Context context, CaptionedImageCard card) {
        super(context);
        if (this.canUseFresco()) {
            this.mDrawee = (SimpleDraweeView)this.getProperViewFromInflatedStub(R.id.com_appboy_captioned_image_card_drawee_stub);
        } else {
            this.mImage = (ImageView)this.getProperViewFromInflatedStub(R.id.com_appboy_captioned_image_card_imageview_stub);
            this.mImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
            this.mImage.setAdjustViewBounds(true);
        }
        this.mTitle = (TextView)this.findViewById(R.id.com_appboy_captioned_image_title);
        this.mDescription = (TextView)this.findViewById(R.id.com_appboy_captioned_image_description);
        this.mDomain = (TextView)this.findViewById(R.id.com_appboy_captioned_image_card_domain);
        if (card != null) {
            this.setCard(card);
        }
        this.safeSetBackground(this.getResources().getDrawable(R.drawable.com_appboy_card_background));
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.com_appboy_captioned_image_card;
    }

    @Override
    public void onSetCard(final CaptionedImageCard card) {
        this.mTitle.setText((CharSequence)card.getTitle());
        this.mDescription.setText((CharSequence)card.getDescription());
        this.setOptionalTextView(this.mDomain, card.getDomain());
        this.mCardAction = ActionFactory.createUriAction(this.getContext(), card.getUrl());
        boolean respectAspectRatio = false;
        if (card.getAspectRatio() != 0.0f) {
            this.mAspectRatio = card.getAspectRatio();
            respectAspectRatio = true;
        }
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BaseCardView.handleCardClick(CaptionedImageCardView.this.mContext, (Card)card, CaptionedImageCardView.this.mCardAction, TAG);
            }
        });
        if (this.canUseFresco()) {
            this.setSimpleDraweeToUrl(this.mDrawee, card.getImageUrl(), this.mAspectRatio, respectAspectRatio);
        } else {
            this.setImageViewToUrl(this.mImage, card.getImageUrl(), this.mAspectRatio, respectAspectRatio);
        }
    }
}

