/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.kits;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.appboy.Appboy;
import com.appboy.AppboyGcmReceiver;
import com.appboy.AppboyUser;
import com.appboy.enums.Gender;
import com.appboy.models.outgoing.AppboyProperties;
import com.appboy.push.AppboyNotificationUtils;
import com.mparticle.MPEvent;
import com.mparticle.MParticle;
import com.mparticle.commerce.CommerceEvent;
import com.mparticle.commerce.Product;
import com.mparticle.internal.CommerceEventUtil;
import com.mparticle.internal.ConfigManager;
import com.mparticle.internal.PushRegistrationHelper;
import com.mparticle.kits.AbstractKit;
import com.mparticle.kits.ActivityLifecycleForwarder;
import com.mparticle.kits.ClientSideForwarder;
import com.mparticle.kits.ECommerceForwarder;
import com.mparticle.kits.PushProvider;
import com.mparticle.kits.ReportingMessage;
import com.mparticle.messaging.MessagingConfigCallbacks;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class AppboyKit
extends AbstractKit
implements ActivityLifecycleForwarder,
PushProvider,
MessagingConfigCallbacks,
ClientSideForwarder,
ECommerceForwarder {
    static final String APPBOY_KEY = "apiKey";
    public static final String PUSH_ENABLED = "push_enabled";
    boolean started = false;
    boolean running = false;
    private boolean pushEnabled;

    public Object getInstance(Activity activity) {
        return Appboy.getInstance((Context)activity);
    }

    public String getName() {
        return "Appboy";
    }

    public boolean isOriginator(String uri) {
        return false;
    }

    protected AbstractKit update() {
        String key = (String)this.properties.get(APPBOY_KEY);
        if (!this.running && !TextUtils.isEmpty((CharSequence)key)) {
            Appboy.configure((Context)this.context, (String)key);
            this.running = true;
        }
        if (this.running) {
            this.pushEnabled = Boolean.parseBoolean((String)this.properties.get(PUSH_ENABLED));
            if (this.pushEnabled) {
                String regId = PushRegistrationHelper.getRegistrationId((Context)this.context);
                if (TextUtils.isEmpty((CharSequence)regId)) {
                    PushRegistrationHelper.enablePushNotifications((Context)this.context, (String)this.mEkManager.getConfigurationManager().getPushSenderId(), (MessagingConfigCallbacks)this);
                } else {
                    this.setPushRegistrationId(regId);
                }
            }
        }
        return this;
    }

    public List<ReportingMessage> onActivityCreated(Activity activity, int activityCount) {
        return null;
    }

    public boolean isRunning() {
        return this.running;
    }

    public List<ReportingMessage> logEvent(MPEvent event) throws Exception {
        if (event.getInfo() == null) {
            Appboy.getInstance((Context)this.context).logCustomEvent(event.getEventName());
        } else {
            AppboyProperties properties = new AppboyProperties();
            for (Map.Entry entry : event.getInfo().entrySet()) {
                properties.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
            Appboy.getInstance((Context)this.context).logCustomEvent(event.getEventName(), properties);
        }
        LinkedList<ReportingMessage> messages = new LinkedList<ReportingMessage>();
        messages.add(ReportingMessage.fromEvent((AbstractKit)this, (MPEvent)event));
        return messages;
    }

    public List<ReportingMessage> logScreen(String screenName, Map<String, String> eventAttributes) throws Exception {
        return null;
    }

    public List<ReportingMessage> logEvent(CommerceEvent event) throws Exception {
        LinkedList<ReportingMessage> messages = new LinkedList<ReportingMessage>();
        if (!TextUtils.isEmpty((CharSequence)event.getProductAction()) && event.getProductAction().equalsIgnoreCase("purchase") && event.getProducts().size() > 0) {
            List productList = event.getProducts();
            for (Product product : productList) {
                this.logTransaction(event, product);
            }
            messages.add(ReportingMessage.fromEvent((AbstractKit)this, (CommerceEvent)event));
            return messages;
        }
        List eventList = CommerceEventUtil.expand((CommerceEvent)event);
        if (eventList != null) {
            for (int i = 0; i < eventList.size(); ++i) {
                try {
                    this.logEvent((MPEvent)eventList.get(i));
                    messages.add(ReportingMessage.fromEvent((AbstractKit)this, (CommerceEvent)event));
                    continue;
                }
                catch (Exception e) {
                    ConfigManager.log((MParticle.LogLevel)MParticle.LogLevel.WARNING, (String[])new String[]{"Failed to call logCustomEvent to Appboy kit: " + e.toString()});
                }
            }
        }
        return messages;
    }

    void removeUserAttribute(String key) {
        Appboy.getInstance((Context)this.context).getCurrentUser().unsetCustomUserAttribute(key);
    }

    void setUserIdentity(String id2, MParticle.IdentityType identityType) {
        AppboyUser user = Appboy.getInstance((Context)this.context).getCurrentUser();
        if (MParticle.IdentityType.CustomerId.equals((Object)identityType)) {
            if (user == null || user.getUserId() != null && !user.getUserId().equals(id2)) {
                Appboy.getInstance((Context)this.context).changeUser(id2);
            }
        } else if (MParticle.IdentityType.Email.equals((Object)identityType)) {
            user.setEmail(id2);
        }
    }

    void setUserAttributes(JSONObject attributes) {
        AppboyUser user = Appboy.getInstance((Context)this.context).getCurrentUser();
        if (attributes != null) {
            Iterator keys = attributes.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = attributes.optString(key, "");
                if ("$City".equals(key)) {
                    user.setHomeCity(value);
                    continue;
                }
                if ("$Country".equals(key)) {
                    user.setCountry(value);
                    continue;
                }
                if ("$FirstName".equals(key)) {
                    user.setFirstName(value);
                    continue;
                }
                if ("$Gender".equals(key)) {
                    if (value.contains("fe")) {
                        user.setGender(Gender.FEMALE);
                        continue;
                    }
                    user.setGender(Gender.MALE);
                    continue;
                }
                if ("$LastName".equals(key)) {
                    user.setLastName(value);
                    continue;
                }
                if ("$Mobile".equals(key)) {
                    user.setPhoneNumber(value);
                    continue;
                }
                if (key.startsWith("$")) {
                    key = key.substring(1);
                }
                user.setCustomUserAttribute(key, value);
            }
        }
    }

    private void logTransaction(CommerceEvent event, Product product) {
        AppboyProperties purchaseProperties = new AppboyProperties();
        HashMap eventAttributes = new HashMap();
        CommerceEventUtil.extractActionAttributes((CommerceEvent)event, eventAttributes);
        String currency = (String)eventAttributes.get("Currency Code");
        if (TextUtils.isEmpty((CharSequence)currency)) {
            currency = "USD";
        }
        eventAttributes.remove("Currency Code");
        for (Map.Entry entry : eventAttributes.entrySet()) {
            purchaseProperties.addProperty((String)entry.getKey(), (String)entry.getValue());
        }
        Appboy.getInstance((Context)this.context).logPurchase(product.getSku(), currency, new BigDecimal(product.getUnitPrice()), (int)product.getQuantity(), purchaseProperties);
    }

    public List<ReportingMessage> logLtvIncrease(BigDecimal valueIncreased, String eventName, Map<String, String> contextInfo) {
        return null;
    }

    public List<ReportingMessage> onActivityResumed(Activity activity, int activityCount) {
        if (!this.started) {
            this.onActivityStarted(activity, activityCount);
            LinkedList<ReportingMessage> messageList = new LinkedList<ReportingMessage>();
            messageList.add(new ReportingMessage((AbstractKit)this, "ast", (double)System.currentTimeMillis(), null));
            return messageList;
        }
        return null;
    }

    public List<ReportingMessage> onActivityPaused(Activity activity, int activityCount) {
        return null;
    }

    public List<ReportingMessage> onActivityStopped(Activity activity, int activityCount) {
        if (this.started) {
            Appboy.getInstance((Context)activity).closeSession(activity);
            this.started = false;
            LinkedList<ReportingMessage> messageList = new LinkedList<ReportingMessage>();
            messageList.add(new ReportingMessage((AbstractKit)this, "ast", (double)System.currentTimeMillis(), null));
            return messageList;
        }
        return null;
    }

    public List<ReportingMessage> onActivityStarted(Activity activity, int activityCount) {
        this.started = true;
        Appboy.getInstance((Context)activity).openSession(activity);
        LinkedList<ReportingMessage> messageList = new LinkedList<ReportingMessage>();
        messageList.add(new ReportingMessage((AbstractKit)this, "ast", (double)System.currentTimeMillis(), null));
        return messageList;
    }

    public List<ReportingMessage> handleGcmMessage(Intent intent) {
        if (AppboyNotificationUtils.isAppboyPushMessage(intent)) {
            new AppboyGcmReceiver().onReceive(this.context, intent);
            LinkedList<ReportingMessage> messages = new LinkedList<ReportingMessage>();
            messages.add(ReportingMessage.fromPushMessage((AbstractKit)this, (Intent)intent));
            return messages;
        }
        return null;
    }

    public void setPushNotificationIcon(int resId) {
    }

    public void setPushNotificationTitle(int resId) {
    }

    public void setPushSenderId(String senderId) {
    }

    public void setPushSoundEnabled(boolean enabled) {
    }

    public void setPushVibrationEnabled(boolean enabled) {
    }

    public void setPushRegistrationId(String registrationId) {
        Appboy.getInstance((Context)this.context).registerAppboyGcmMessages(registrationId);
    }

    public Appboy getAppboy() {
        return Appboy.getInstance((Context)this.context);
    }
}

