/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import com.appboy.Constants;
import com.appboy.IAppboyNavigator;
import com.appboy.support.AppboyLogger;
import com.appboy.ui.actions.ActivityAction;
import com.appboy.ui.actions.WebAction;
import com.appboy.ui.activities.AppboyFeedActivity;

public class AppboyNavigator
implements IAppboyNavigator {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, AppboyNavigator.class.getName());

    public void gotoNewsFeed(Context context, Bundle extras) {
        ComponentName componentName = new ComponentName(context, AppboyFeedActivity.class);
        try {
            context.getPackageManager().getActivityInfo(componentName, 1);
            Intent intent = new Intent(context, AppboyFeedActivity.class);
            ActivityAction activityAction = new ActivityAction(intent);
            activityAction.execute(context);
        }
        catch (PackageManager.NameNotFoundException e) {
            AppboyLogger.d((String)TAG, (String)"The AppboyFeedActivity is not registered in the manifest. Ignoring request to display the news feed.");
        }
    }

    public void gotoURI(Context context, Uri uri, Bundle extras) {
        if (uri == null) {
            AppboyLogger.e((String)TAG, (String)"IAppboyNavigator cannot open URI because the URI is null.");
            return;
        }
        WebAction webAction = new WebAction(uri.toString());
        webAction.execute(context);
    }
}

