/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.inappmessage;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import com.appboy.Appboy;
import com.appboy.Constants;
import com.appboy.IAppboyNavigator;
import com.appboy.events.IEventSubscriber;
import com.appboy.events.InAppMessageEvent;
import com.appboy.models.IInAppMessage;
import com.appboy.models.InAppMessageFull;
import com.appboy.models.InAppMessageHtmlFull;
import com.appboy.models.InAppMessageModal;
import com.appboy.models.InAppMessageSlideup;
import com.appboy.support.AppboyLogger;
import com.appboy.ui.AppboyNavigator;
import com.appboy.ui.inappmessage.AppboyAsyncInAppMessageDisplayer;
import com.appboy.ui.inappmessage.IInAppMessageAnimationFactory;
import com.appboy.ui.inappmessage.IInAppMessageImmersiveView;
import com.appboy.ui.inappmessage.IInAppMessageView;
import com.appboy.ui.inappmessage.IInAppMessageViewFactory;
import com.appboy.ui.inappmessage.IInAppMessageViewWrapper;
import com.appboy.ui.inappmessage.InAppMessageOperation;
import com.appboy.ui.inappmessage.InAppMessageViewWrapper;
import com.appboy.ui.inappmessage.factories.AppboyFullViewFactory;
import com.appboy.ui.inappmessage.factories.AppboyHtmlFullViewFactory;
import com.appboy.ui.inappmessage.factories.AppboyInAppMessageAnimationFactory;
import com.appboy.ui.inappmessage.factories.AppboyModalViewFactory;
import com.appboy.ui.inappmessage.factories.AppboySlideupViewFactory;
import com.appboy.ui.inappmessage.listeners.AppboyDefaultHtmlInAppMessageActionListener;
import com.appboy.ui.inappmessage.listeners.AppboyDefaultInAppMessageManagerListener;
import com.appboy.ui.inappmessage.listeners.AppboyInAppMessageViewLifecycleListener;
import com.appboy.ui.inappmessage.listeners.AppboyInAppMessageWebViewClientListener;
import com.appboy.ui.inappmessage.listeners.IHtmlInAppMessageActionListener;
import com.appboy.ui.inappmessage.listeners.IInAppMessageManagerListener;
import com.appboy.ui.inappmessage.listeners.IInAppMessageViewLifecycleListener;
import com.appboy.ui.inappmessage.listeners.IInAppMessageWebViewClientListener;
import com.appboy.ui.support.ViewUtils;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;

public final class AppboyInAppMessageManager {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, AppboyInAppMessageManager.class.getName());
    private static volatile AppboyInAppMessageManager sInstance = null;
    private final Stack<IInAppMessage> mInAppMessageStack = new Stack();
    private final IAppboyNavigator mDefaultAppboyNavigator = new AppboyNavigator();
    private Activity mActivity;
    private IEventSubscriber<InAppMessageEvent> mInAppMessageEventSubscriber;
    private IInAppMessageViewFactory mCustomInAppMessageViewFactory;
    private IInAppMessageAnimationFactory mCustomInAppMessageAnimationFactory;
    private IInAppMessageViewWrapper mInAppMessageViewWrapper;
    private IInAppMessage mCarryoverInAppMessage;
    private AtomicBoolean mDisplayingInAppMessage = new AtomicBoolean(false);
    private Context mApplicationContext;
    private final IInAppMessageWebViewClientListener mInAppMessageWebViewClientListener = new AppboyInAppMessageWebViewClientListener();
    private final IInAppMessageViewLifecycleListener mInAppMessageViewLifecycleListener = new AppboyInAppMessageViewLifecycleListener();
    private IInAppMessageManagerListener mDefaultInAppMessageManagerListener = new AppboyDefaultInAppMessageManagerListener();
    private IInAppMessageManagerListener mCustomInAppMessageManagerListener;
    private IHtmlInAppMessageActionListener mDefaultHtmlInAppMessageActionListener = new AppboyDefaultHtmlInAppMessageActionListener();
    private IHtmlInAppMessageActionListener mCustomHtmlInAppMessageActionListener;
    private IInAppMessageViewFactory mInAppMessageSlideupViewFactory = new AppboySlideupViewFactory();
    private IInAppMessageViewFactory mInAppMessageModalViewFactory = new AppboyModalViewFactory();
    private IInAppMessageViewFactory mInAppMessageFullViewFactory = new AppboyFullViewFactory();
    private IInAppMessageViewFactory mInAppMessageHtmlFullViewFactory = new AppboyHtmlFullViewFactory(this.mInAppMessageWebViewClientListener);
    private IInAppMessageAnimationFactory mInAppMessageAnimationFactory = new AppboyInAppMessageAnimationFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppboyInAppMessageManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<AppboyInAppMessageManager> clazz = AppboyInAppMessageManager.class;
        synchronized (AppboyInAppMessageManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new AppboyInAppMessageManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void registerInAppMessageManager(Activity activity) {
        this.mActivity = activity;
        if (this.mActivity != null && this.mApplicationContext == null) {
            this.mApplicationContext = this.mActivity.getApplicationContext();
        }
        if (this.mCarryoverInAppMessage != null) {
            AppboyLogger.d((String)TAG, (String)"Displaying carryover in-app message.");
            this.mCarryoverInAppMessage.setAnimateIn(false);
            this.displayInAppMessage(this.mCarryoverInAppMessage);
            this.mCarryoverInAppMessage = null;
        }
        this.mInAppMessageEventSubscriber = this.createInAppMessageEventSubscriber();
        Appboy.getInstance((Context)activity).subscribeToNewInAppMessages(this.mInAppMessageEventSubscriber);
    }

    public void unregisterInAppMessageManager(Activity activity) {
        if (this.mInAppMessageViewWrapper != null) {
            ViewUtils.removeViewFromParent(this.mInAppMessageViewWrapper.getInAppMessageView());
            if (this.mInAppMessageViewWrapper.getIsAnimatingClose()) {
                this.mInAppMessageViewLifecycleListener.afterClosed(this.mInAppMessageViewWrapper.getInAppMessage());
                this.mCarryoverInAppMessage = null;
            } else {
                this.mCarryoverInAppMessage = this.mInAppMessageViewWrapper.getInAppMessage();
            }
            this.mInAppMessageViewWrapper = null;
        } else {
            this.mCarryoverInAppMessage = null;
        }
        Appboy.getInstance((Context)activity).removeSingleSubscription(this.mInAppMessageEventSubscriber, InAppMessageEvent.class);
        this.mActivity = null;
        this.mDisplayingInAppMessage.set(false);
    }

    public void setCustomInAppMessageManagerListener(IInAppMessageManagerListener inAppMessageManagerListener) {
        this.mCustomInAppMessageManagerListener = inAppMessageManagerListener;
    }

    public void setCustomHtmlInAppMessageActionListener(IHtmlInAppMessageActionListener htmlInAppMessageActionListener) {
        this.mCustomHtmlInAppMessageActionListener = htmlInAppMessageActionListener;
    }

    public void setCustomInAppMessageAnimationFactory(IInAppMessageAnimationFactory inAppMessageAnimationFactory) {
        this.mCustomInAppMessageAnimationFactory = inAppMessageAnimationFactory;
    }

    public void setCustomInAppMessageViewFactory(IInAppMessageViewFactory inAppMessageViewFactory) {
        this.mCustomInAppMessageViewFactory = inAppMessageViewFactory;
    }

    public void addInAppMessage(IInAppMessage inAppMessage) {
        this.mInAppMessageStack.push(inAppMessage);
        this.requestDisplayInAppMessage();
    }

    public boolean requestDisplayInAppMessage() {
        try {
            if (this.mActivity == null) {
                AppboyLogger.e((String)TAG, (String)"No activity is currently registered to receive in-app messages. Doing nothing.");
                return false;
            }
            if (this.mDisplayingInAppMessage.get()) {
                AppboyLogger.d((String)TAG, (String)"A in-app message is currently being displayed. Ignoring request to display in-app message.");
                return false;
            }
            if (this.mInAppMessageStack.isEmpty()) {
                AppboyLogger.d((String)TAG, (String)"The in-app message stack is empty. No in-app message will be displayed.");
                return false;
            }
            final IInAppMessage inAppMessage = this.mInAppMessageStack.pop();
            InAppMessageOperation inAppMessageOperation = this.getInAppMessageManagerListener().beforeInAppMessageDisplayed(inAppMessage);
            switch (inAppMessageOperation) {
                case DISPLAY_NOW: {
                    AppboyLogger.d((String)TAG, (String)"The IInAppMessageManagerListener method beforeInAppMessageDisplayed returned DISPLAY_NOW. The in-app message will be displayed.");
                    break;
                }
                case DISPLAY_LATER: {
                    AppboyLogger.d((String)TAG, (String)"The IInAppMessageManagerListener method beforeInAppMessageDisplayed returned DISPLAY_LATER. The in-app message will be pushed back onto the stack.");
                    this.mInAppMessageStack.push(inAppMessage);
                    return false;
                }
                case DISCARD: {
                    AppboyLogger.d((String)TAG, (String)"The IInAppMessageManagerListener method beforeInAppMessageDisplayed returned DISCARD. The in-app message will not be displayed and will not be put back on the stack.");
                    return false;
                }
                default: {
                    AppboyLogger.e((String)TAG, (String)"The IInAppMessageManagerListener method beforeInAppMessageDisplayed returned null instead of a InAppMessageOperation. Ignoring the in-app message. Please check the IInAppMessageStackBehaviour implementation.");
                    return false;
                }
            }
            this.mActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    new AppboyAsyncInAppMessageDisplayer().execute(new IInAppMessage[]{inAppMessage});
                }
            });
            return true;
        }
        catch (Exception e) {
            AppboyLogger.e((String)TAG, (String)"Error running requestDisplayInAppMessage", (Throwable)e);
            return false;
        }
    }

    public void hideCurrentInAppMessage(boolean animate, boolean dismissed) {
        IInAppMessageViewWrapper inAppMessageWrapperView = this.mInAppMessageViewWrapper;
        if (inAppMessageWrapperView != null && dismissed) {
            this.mInAppMessageViewLifecycleListener.onDismissed(inAppMessageWrapperView.getInAppMessageView(), inAppMessageWrapperView.getInAppMessage());
        }
        this.hideCurrentInAppMessage(animate);
    }

    public void hideCurrentInAppMessage(boolean animate) {
        IInAppMessageViewWrapper inAppMessageWrapperView = this.mInAppMessageViewWrapper;
        if (inAppMessageWrapperView != null) {
            IInAppMessage inAppMessage = inAppMessageWrapperView.getInAppMessage();
            if (inAppMessage != null) {
                inAppMessage.setAnimateOut(animate);
            }
            inAppMessageWrapperView.close();
        }
    }

    public IInAppMessageManagerListener getInAppMessageManagerListener() {
        return this.mCustomInAppMessageManagerListener != null ? this.mCustomInAppMessageManagerListener : this.mDefaultInAppMessageManagerListener;
    }

    public IHtmlInAppMessageActionListener getHtmlInAppMessageActionListener() {
        return this.mCustomHtmlInAppMessageActionListener != null ? this.mCustomHtmlInAppMessageActionListener : this.mDefaultHtmlInAppMessageActionListener;
    }

    public IAppboyNavigator getAppboyNavigator() {
        IAppboyNavigator customAppboyNavigator = Appboy.getInstance((Context)this.mActivity).getAppboyNavigator();
        return customAppboyNavigator != null ? customAppboyNavigator : this.mDefaultAppboyNavigator;
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public void resetAfterInAppMessageClose() {
        this.mInAppMessageViewWrapper = null;
        this.mDisplayingInAppMessage.set(false);
    }

    private IInAppMessageAnimationFactory getInAppMessageAnimationFactory() {
        return this.mCustomInAppMessageAnimationFactory != null ? this.mCustomInAppMessageAnimationFactory : this.mInAppMessageAnimationFactory;
    }

    private IInAppMessageViewFactory getInAppMessageViewFactory(IInAppMessage inAppMessage) {
        if (this.mCustomInAppMessageViewFactory != null) {
            return this.mCustomInAppMessageViewFactory;
        }
        if (inAppMessage instanceof InAppMessageSlideup) {
            return this.mInAppMessageSlideupViewFactory;
        }
        if (inAppMessage instanceof InAppMessageModal) {
            return this.mInAppMessageModalViewFactory;
        }
        if (inAppMessage instanceof InAppMessageFull) {
            return this.mInAppMessageFullViewFactory;
        }
        if (inAppMessage instanceof InAppMessageHtmlFull) {
            return this.mInAppMessageHtmlFullViewFactory;
        }
        return null;
    }

    boolean displayInAppMessage(IInAppMessage inAppMessage) {
        if (!this.mDisplayingInAppMessage.compareAndSet(false, true)) {
            AppboyLogger.d((String)TAG, (String)"A in-app message is currently being displayed.  Adding in-app message back on the stack.");
            this.mInAppMessageStack.push(inAppMessage);
            return false;
        }
        try {
            if (this.mActivity == null) {
                throw new Exception("No activity is currently registered to receive in-app messages. Doing nothing.");
            }
            IInAppMessageViewFactory inAppMessageViewFactory = this.getInAppMessageViewFactory(inAppMessage);
            if (inAppMessageViewFactory == null) {
                throw new Exception("ViewFactory from getInAppMessageViewFactory was null.");
            }
            View inAppMessageView = inAppMessageViewFactory.createInAppMessageView(this.mActivity, inAppMessage);
            if (inAppMessageView == null) {
                throw new Exception("The in-app message view returned from the IInAppMessageViewFactory was null. The in-app message will not be displayed and will not be put back on the stack.");
            }
            if (inAppMessageView.getParent() != null) {
                throw new Exception("The in-app message view returned from the IInAppMessageViewFactory already has a parent. This is a sign that the view is being reused. The IInAppMessageViewFactory method createInAppMessageViewmust return a new view without a parent. The in-app message will not be displayed and will not be put back on the stack.");
            }
            Animation openingAnimation = this.getInAppMessageAnimationFactory().getOpeningAnimation(inAppMessage);
            Animation closingAnimation = this.getInAppMessageAnimationFactory().getClosingAnimation(inAppMessage);
            if (inAppMessageView instanceof IInAppMessageImmersiveView) {
                AppboyLogger.d((String)TAG, (String)"Creating view wrapper for immersive in-app message.");
                IInAppMessageImmersiveView inAppMessageViewImmersive = (IInAppMessageImmersiveView)inAppMessageView;
                this.mInAppMessageViewWrapper = new InAppMessageViewWrapper(inAppMessageView, inAppMessage, this.mInAppMessageViewLifecycleListener, openingAnimation, closingAnimation, inAppMessageViewImmersive.getMessageClickableView(), inAppMessageViewImmersive.getMessageButtonViews(), inAppMessageViewImmersive.getMessageCloseButtonView());
            } else if (inAppMessageView instanceof IInAppMessageView) {
                AppboyLogger.d((String)TAG, (String)"Creating view wrapper for base in-app message.");
                IInAppMessageView inAppMessageViewBase = (IInAppMessageView)inAppMessageView;
                this.mInAppMessageViewWrapper = new InAppMessageViewWrapper(inAppMessageView, inAppMessage, this.mInAppMessageViewLifecycleListener, openingAnimation, closingAnimation, inAppMessageViewBase.getMessageClickableView());
            } else {
                AppboyLogger.d((String)TAG, (String)"Creating view wrapper for in-app message.");
                this.mInAppMessageViewWrapper = new InAppMessageViewWrapper(inAppMessageView, inAppMessage, this.mInAppMessageViewLifecycleListener, openingAnimation, closingAnimation, inAppMessageView);
            }
            FrameLayout root = (FrameLayout)this.mActivity.getWindow().getDecorView().findViewById(0x1020002);
            this.mInAppMessageViewWrapper.open(root);
            return true;
        }
        catch (Exception e) {
            AppboyLogger.e((String)TAG, (String)"Error running displayInAppMessage", (Throwable)e);
            this.mInAppMessageViewWrapper = null;
            this.mDisplayingInAppMessage.set(false);
            return false;
        }
    }

    private IEventSubscriber<InAppMessageEvent> createInAppMessageEventSubscriber() {
        return new IEventSubscriber<InAppMessageEvent>(){

            public void trigger(InAppMessageEvent event) {
                if (AppboyInAppMessageManager.this.getInAppMessageManagerListener().onInAppMessageReceived(event.getInAppMessage())) {
                    return;
                }
                AppboyInAppMessageManager.this.addInAppMessage(event.getInAppMessage());
            }
        };
    }
}

