/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.widget;

import android.content.Context;
import android.view.View;
import android.widget.TextView;
import com.appboy.models.cards.Card;
import com.appboy.models.cards.TextAnnouncementCard;
import com.appboy.ui.R;
import com.appboy.ui.actions.ActionFactory;
import com.appboy.ui.actions.IAction;
import com.appboy.ui.widget.BaseCardView;

public class TextAnnouncementCardView
extends BaseCardView<TextAnnouncementCard> {
    private final TextView mTitle = (TextView)this.findViewById(R.id.com_appboy_text_announcement_card_title);
    private final TextView mDescription = (TextView)this.findViewById(R.id.com_appboy_text_announcement_card_description);
    private final TextView mDomain = (TextView)this.findViewById(R.id.com_appboy_text_announcement_card_domain);
    private IAction mCardAction;
    private static final String TAG = String.format("%s.%s", "Appboy", TextAnnouncementCardView.class.getName());

    public TextAnnouncementCardView(Context context) {
        this(context, null);
    }

    public TextAnnouncementCardView(Context context, TextAnnouncementCard card) {
        super(context);
        if (card != null) {
            this.setCard(card);
        }
        this.safeSetBackground(this.getResources().getDrawable(R.drawable.com_appboy_card_background));
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.com_appboy_text_announcement_card;
    }

    @Override
    public void onSetCard(final TextAnnouncementCard card) {
        this.mTitle.setText((CharSequence)card.getTitle());
        this.mDescription.setText((CharSequence)card.getDescription());
        this.setOptionalTextView(this.mDomain, card.getDomain());
        this.mCardAction = ActionFactory.createUriAction(this.getContext(), card.getUrl());
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BaseCardView.handleCardClick(TextAnnouncementCardView.this.mContext, (Card)card, TextAnnouncementCardView.this.mCardAction, TAG);
            }
        });
    }
}

