/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.push;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.format.DateFormat;
import android.widget.RemoteViews;
import com.appboy.Constants;
import com.appboy.push.AppboyNotificationUtils;
import com.appboy.support.AppboyLogger;
import com.appboy.support.PackageUtils;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AppboyNotificationRemoteViewsUtils {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, AppboyNotificationRemoteViewsUtils.class.getName());
    public static final String APPBOY_NOTIFICATION_ID = "com_appboy_notification";
    public static final String APPBOY_NOTIFICATION_ID_NO_ICON = "com_appboy_notification_no_icon";
    public static final String APPBOY_NOTIFICATION_TITLE_ID = "com_appboy_notification_title";
    public static final String APPBOY_NOTIFICATION_CONTENT_ID = "com_appboy_notification_content";
    public static final String APPBOY_NOTIFICATION_ICON_ID = "com_appboy_notification_icon";
    public static final String APPBOY_NOTIFICATION_TIME_ID = "com_appboy_notification_time";
    public static final String APPBOY_NOTIFICATION_TWENTY_FOUR_HOUR_FORMAT_ID = "com_appboy_notification_time_twenty_four_hour_format";
    public static final String APPBOY_NOTIFICATION_TWELVE_HOUR_FORTMAT_ID = "com_appboy_notification_time_twelve_hour_format";

    @TargetApi(value=11)
    public static RemoteViews createMultiLineContentNotificationView(Context context, Bundle notificationExtras, int smallIconResourceId, boolean showSmallIcon) {
        if (notificationExtras != null) {
            String title = notificationExtras.getString("t");
            String contentText = notificationExtras.getString("a");
            Resources resources = context.getResources();
            String resourcePackageName = PackageUtils.getResourcePackageName((Context)context);
            int layoutResourceId = showSmallIcon ? resources.getIdentifier(APPBOY_NOTIFICATION_ID, "layout", resourcePackageName) : resources.getIdentifier(APPBOY_NOTIFICATION_ID_NO_ICON, "layout", resourcePackageName);
            int titleResourceId = resources.getIdentifier(APPBOY_NOTIFICATION_TITLE_ID, "id", resourcePackageName);
            int contentResourceId = resources.getIdentifier(APPBOY_NOTIFICATION_CONTENT_ID, "id", resourcePackageName);
            int iconResourceId = resources.getIdentifier(APPBOY_NOTIFICATION_ICON_ID, "id", resourcePackageName);
            int timeViewResourceId = resources.getIdentifier(APPBOY_NOTIFICATION_TIME_ID, "id", resourcePackageName);
            int twentyFourHourFormatResourceId = resources.getIdentifier(APPBOY_NOTIFICATION_TWENTY_FOUR_HOUR_FORMAT_ID, "string", resourcePackageName);
            int twelveHourFormatResourceId = resources.getIdentifier(APPBOY_NOTIFICATION_TWELVE_HOUR_FORTMAT_ID, "string", resourcePackageName);
            String twentyFourHourTimeFormat = AppboyNotificationUtils.getOptionalStringResource(resources, twentyFourHourFormatResourceId, "HH:mm");
            String twelveHourTimeFormat = AppboyNotificationUtils.getOptionalStringResource(resources, twelveHourFormatResourceId, "h:mm a");
            if (layoutResourceId == 0 || titleResourceId == 0 || contentResourceId == 0 || iconResourceId == 0 || timeViewResourceId == 0) {
                AppboyLogger.w((String)TAG, (String)String.format("Couldn't find all resource IDs for custom notification view, extended view will not be used for push notifications. Received %d for layout, %d for title, %d for content, %d for icon, and %d for time.", layoutResourceId, titleResourceId, contentResourceId, iconResourceId, timeViewResourceId));
            } else {
                RemoteViews remoteViews;
                AppboyLogger.d((String)TAG, (String)"Using RemoteViews for rendering of push notification.");
                try {
                    remoteViews = new RemoteViews(PackageUtils.getResourcePackageName((Context)context), layoutResourceId);
                }
                catch (Exception e) {
                    AppboyLogger.e((String)TAG, (String)String.format("Failed to initialize remote views with package %s", PackageUtils.getResourcePackageName((Context)context)), (Throwable)e);
                    try {
                        remoteViews = new RemoteViews(context.getPackageName(), layoutResourceId);
                    }
                    catch (Exception e2) {
                        AppboyLogger.e((String)TAG, (String)String.format("Failed to initialize remote views with package %s", context.getPackageName()), (Throwable)e2);
                        return null;
                    }
                }
                remoteViews.setTextViewText(titleResourceId, (CharSequence)title);
                remoteViews.setTextViewText(contentResourceId, (CharSequence)contentText);
                if (showSmallIcon) {
                    remoteViews.setImageViewResource(iconResourceId, smallIconResourceId);
                }
                SimpleDateFormat timeFormat = new SimpleDateFormat(DateFormat.is24HourFormat((Context)context) ? twentyFourHourTimeFormat : twelveHourTimeFormat);
                String notificationTime = timeFormat.format(new Date());
                remoteViews.setTextViewText(timeViewResourceId, (CharSequence)notificationTime);
                return remoteViews;
            }
        }
        return null;
    }
}

