/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.push;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import android.os.SystemClock;
import android.support.v4.app.NotificationCompat;
import com.appboy.Appboy;
import com.appboy.AppboyAdmReceiver;
import com.appboy.AppboyGcmReceiver;
import com.appboy.Constants;
import com.appboy.IAppboyNotificationFactory;
import com.appboy.configuration.XmlAppConfigurationProvider;
import com.appboy.push.AppboyNotificationFactory;
import com.appboy.push.AppboyNotificationStyleFactory;
import com.appboy.support.AppboyLogger;
import com.appboy.support.IntentUtils;
import com.appboy.support.PackageUtils;
import com.appboy.support.PermissionUtils;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class AppboyNotificationUtils {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, AppboyNotificationUtils.class.getName());
    private static final String SOURCE_KEY = "source";
    public static final String APPBOY_NOTIFICATION_OPENED_SUFFIX = ".intent.APPBOY_NOTIFICATION_OPENED";
    public static final String APPBOY_NOTIFICATION_RECEIVED_SUFFIX = ".intent.APPBOY_PUSH_RECEIVED";

    @Deprecated
    public static Bundle getAppboyExtras(Bundle notificationExtras) {
        if (notificationExtras == null) {
            return null;
        }
        if (!Constants.IS_AMAZON.booleanValue()) {
            return notificationExtras.getBundle("extra");
        }
        return notificationExtras;
    }

    public static void handleNotificationOpened(Context context, Intent intent) {
        try {
            AppboyNotificationUtils.logNotificationOpened(context, intent);
            AppboyNotificationUtils.sendNotificationOpenedBroadcast(context, intent);
        }
        catch (Exception e) {
            AppboyLogger.e((String)TAG, (String)"Exception occurred attempting to handle notification.", (Throwable)e);
        }
    }

    public static Bundle getAppboyExtrasWithoutPreprocessing(Bundle notificationExtras) {
        if (notificationExtras == null) {
            return null;
        }
        if (!Constants.IS_AMAZON.booleanValue()) {
            return AppboyNotificationUtils.parseJSONStringDictionaryIntoBundle(AppboyNotificationUtils.bundleOptString(notificationExtras, "extra", "{}"));
        }
        return new Bundle(notificationExtras);
    }

    @TargetApi(value=12)
    public static String bundleOptString(Bundle bundle, String key, String defaultValue) {
        if (Build.VERSION.SDK_INT >= 12) {
            return bundle.getString(key, defaultValue);
        }
        String result = bundle.getString(key);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public static Bundle parseJSONStringDictionaryIntoBundle(String jsonStringDictionary) {
        try {
            Bundle bundle = new Bundle();
            JSONObject json = new JSONObject(jsonStringDictionary);
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                bundle.putString(key, json.getString(key));
            }
            return bundle;
        }
        catch (JSONException e) {
            AppboyLogger.e((String)TAG, (String)String.format("Unable parse JSON into a bundle.", new Object[0]), (Throwable)e);
            return null;
        }
    }

    public static boolean isAppboyPushMessage(Intent intent) {
        Bundle extras = intent.getExtras();
        return extras != null && "true".equals(extras.getString("_ab"));
    }

    public static boolean isNotificationMessage(Intent intent) {
        Bundle extras = intent.getExtras();
        return extras != null && extras.containsKey("t") && extras.containsKey("a");
    }

    public static void sendPushMessageReceivedBroadcast(Context context, Bundle notificationExtras) {
        String pushReceivedAction = context.getPackageName() + APPBOY_NOTIFICATION_RECEIVED_SUFFIX;
        Intent pushReceivedIntent = new Intent(pushReceivedAction);
        if (notificationExtras != null) {
            pushReceivedIntent.putExtras(notificationExtras);
        }
        context.sendBroadcast(pushReceivedIntent);
    }

    public static void setNotificationDurationAlarm(Context context, Class<?> thisClass, int notificationId, int durationInMillis) {
        Intent cancelIntent = new Intent(context, thisClass);
        cancelIntent.setAction("com.appboy.action.CANCEL_NOTIFICATION");
        cancelIntent.putExtra("nid", notificationId);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)cancelIntent, (int)0x8000000);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        if (durationInMillis >= 1000) {
            alarmManager.set(3, SystemClock.elapsedRealtime() + (long)durationInMillis, pendingIntent);
        }
    }

    public static int getNotificationId(Bundle notificationExtras) {
        if (notificationExtras != null) {
            if (notificationExtras.containsKey("n")) {
                try {
                    int notificationId = Integer.parseInt(notificationExtras.getString("n"));
                    AppboyLogger.d((String)TAG, (String)String.format("Using notification id provided in the message's extras bundle: " + notificationId, new Object[0]));
                    return notificationId;
                }
                catch (NumberFormatException e) {
                    AppboyLogger.e((String)TAG, (String)String.format("Unable to parse notification id provided in the message's extras bundle. Using default notification id instead: -1", new Object[0]), (Throwable)e);
                    return -1;
                }
            }
            String messageKey = AppboyNotificationUtils.bundleOptString(notificationExtras, "t", "") + AppboyNotificationUtils.bundleOptString(notificationExtras, "a", "");
            int notificationId = messageKey.hashCode();
            AppboyLogger.d((String)TAG, (String)String.format("Message without notification id provided in the extras bundle received.  Using a hash of the message: " + notificationId, new Object[0]));
            return notificationId;
        }
        AppboyLogger.d((String)TAG, (String)String.format("Message without extras bundle received.  Using default notification id: -1", new Object[0]));
        return -1;
    }

    @TargetApi(value=16)
    public static int getNotificationPriority(Bundle notificationExtras) {
        if (notificationExtras != null && notificationExtras.containsKey("p")) {
            try {
                int notificationPriority = Integer.parseInt(notificationExtras.getString("p"));
                if (AppboyNotificationUtils.isValidNotificationPriority(notificationPriority)) {
                    return notificationPriority;
                }
                AppboyLogger.e((String)TAG, (String)String.format("Received invalid notification priority %d", notificationPriority));
            }
            catch (NumberFormatException e) {
                AppboyLogger.e((String)TAG, (String)String.format("Unable to parse custom priority. Returning default priority of 0", new Object[0]), (Throwable)e);
            }
        }
        return 0;
    }

    @TargetApi(value=16)
    public static boolean isValidNotificationPriority(int priority) {
        return priority >= -2 && priority <= 2;
    }

    public static boolean wakeScreenIfHasPermission(Context context, Bundle notificationExtras) {
        if (!PermissionUtils.hasPermission((Context)context, (String)"android.permission.WAKE_LOCK")) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 16 && AppboyNotificationUtils.getNotificationPriority(notificationExtras) == -2) {
            return false;
        }
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        PowerManager.WakeLock wakeLock = powerManager.newWakeLock(0x1000001A, TAG);
        wakeLock.acquire();
        wakeLock.release();
        return true;
    }

    public static IAppboyNotificationFactory getActiveNotificationFactory() {
        IAppboyNotificationFactory customAppboyNotificationFactory = Appboy.getCustomAppboyNotificationFactory();
        if (customAppboyNotificationFactory == null) {
            return AppboyNotificationFactory.getInstance();
        }
        return customAppboyNotificationFactory;
    }

    public static void setTitleIfPresent(NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        if (notificationExtras != null) {
            notificationBuilder.setContentTitle((CharSequence)notificationExtras.getString("t"));
        }
    }

    public static void setContentIfPresent(NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        if (notificationExtras != null) {
            notificationBuilder.setContentText((CharSequence)notificationExtras.getString("a"));
        }
    }

    public static void setTickerIfPresent(NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        if (notificationExtras != null) {
            notificationBuilder.setTicker((CharSequence)notificationExtras.getString("t"));
        }
    }

    public static void setContentIntentIfPresent(Context context, NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        try {
            Intent pushOpenedIntent = new Intent("com.appboy.action.APPBOY_PUSH_CLICKED").setClass(context, AppboyNotificationUtils.getNotificationReceiverClass());
            if (notificationExtras != null) {
                pushOpenedIntent.putExtras(notificationExtras);
            }
            PendingIntent pushOpenedPendingIntent = PendingIntent.getBroadcast((Context)context, (int)IntentUtils.getRequestCode(), (Intent)pushOpenedIntent, (int)0x40000000);
            notificationBuilder.setContentIntent(pushOpenedPendingIntent);
        }
        catch (Exception e) {
            AppboyLogger.e((String)TAG, (String)"Error setting content.", (Throwable)e);
        }
    }

    public static int setSmallIcon(XmlAppConfigurationProvider appConfigurationProvider, NotificationCompat.Builder notificationBuilder) {
        int smallNotificationIconResourceId = appConfigurationProvider.getSmallNotificationIconResourceId();
        if (smallNotificationIconResourceId == 0) {
            AppboyLogger.d((String)TAG, (String)"Small notification icon resource was not found. Will use the app icon when displaying notifications.");
            smallNotificationIconResourceId = appConfigurationProvider.getApplicationIconResourceId();
        }
        notificationBuilder.setSmallIcon(smallNotificationIconResourceId);
        return smallNotificationIconResourceId;
    }

    public static boolean setLargeIconIfPresentAndSupported(Context context, XmlAppConfigurationProvider appConfigurationProvider, NotificationCompat.Builder notificationBuilder) {
        int largeNotificationIconResourceId;
        if (Build.VERSION.SDK_INT >= 11 && (largeNotificationIconResourceId = appConfigurationProvider.getLargeNotificationIconResourceId()) != 0) {
            try {
                Bitmap largeNotificationBitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)largeNotificationIconResourceId);
                notificationBuilder.setLargeIcon(largeNotificationBitmap);
                return true;
            }
            catch (Exception e) {
                AppboyLogger.e((String)TAG, (String)"Error setting large notification icon", (Throwable)e);
            }
        }
        return false;
    }

    public static void setSoundIfPresentAndSupported(NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        String soundURI;
        if (Build.VERSION.SDK_INT >= 11 && notificationExtras != null && notificationExtras.containsKey("sd") && (soundURI = notificationExtras.getString("sd")) != null) {
            if (soundURI.equals("d")) {
                notificationBuilder.setDefaults(1);
            } else {
                notificationBuilder.setSound(Uri.parse((String)soundURI));
            }
        }
    }

    public static void setSummaryTextIfPresentAndSupported(NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        String summaryText;
        if (Build.VERSION.SDK_INT >= 16 && notificationExtras != null && notificationExtras.containsKey("s") && (summaryText = notificationExtras.getString("s")) != null) {
            notificationBuilder.setSubText((CharSequence)summaryText);
        }
    }

    public static void setPriorityIfPresentAndSupported(NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        if (Build.VERSION.SDK_INT >= 16 && notificationExtras != null) {
            notificationBuilder.setPriority(AppboyNotificationUtils.getNotificationPriority(notificationExtras));
        }
    }

    public static void setStyleIfSupported(Context context, NotificationCompat.Builder notificationBuilder, Bundle notificationExtras, Bundle appboyExtras) {
        if (Build.VERSION.SDK_INT >= 16 && notificationExtras != null) {
            NotificationCompat.Style style = AppboyNotificationStyleFactory.getBigNotificationStyle(context, notificationExtras, appboyExtras);
            notificationBuilder.setStyle(style);
        }
    }

    public static void setAccentColorIfPresentAndSupported(XmlAppConfigurationProvider appConfigurationProvider, NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (notificationExtras != null && notificationExtras.containsKey("ac")) {
                notificationBuilder.setColor((int)Long.parseLong(notificationExtras.getString("ac")));
            } else {
                notificationBuilder.setColor(appConfigurationProvider.getDefaultNotificationAccentColor());
            }
        }
    }

    public static void setCategoryIfPresentAndSupported(NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        if (Build.VERSION.SDK_INT >= 21 && notificationExtras != null && notificationExtras.containsKey("ab_ct")) {
            String notificationCategory = notificationExtras.getString("ab_ct");
            notificationBuilder.setCategory(notificationCategory);
        }
    }

    public static void setVisibilityIfPresentAndSupported(NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        if (Build.VERSION.SDK_INT >= 21 && notificationExtras != null && notificationExtras.containsKey("ab_vs")) {
            try {
                int visibility = Integer.parseInt(notificationExtras.getString("ab_vs"));
                if (AppboyNotificationUtils.isValidNotificationVisibility(visibility)) {
                    notificationBuilder.setVisibility(visibility);
                } else {
                    AppboyLogger.e((String)TAG, (String)String.format("Received invalid notification visibility %d", visibility));
                }
            }
            catch (Exception e) {
                AppboyLogger.e((String)TAG, (String)"Failed to parse visibility from notificationExtras", (Throwable)e);
            }
        }
    }

    public static void setPublicVersionIfPresentAndSupported(Context context, XmlAppConfigurationProvider xmlAppConfigurationProvider, NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        if (Build.VERSION.SDK_INT >= 21 && notificationExtras != null && notificationExtras.containsKey("ab_pn")) {
            String publicNotificationExtrasString = notificationExtras.getString("ab_pn");
            Bundle publicNotificationExtras = AppboyNotificationUtils.parseJSONStringDictionaryIntoBundle(publicNotificationExtrasString);
            NotificationCompat.Builder publicNotificationBuilder = new NotificationCompat.Builder(context);
            AppboyNotificationUtils.setContentIfPresent(publicNotificationBuilder, publicNotificationExtras);
            AppboyNotificationUtils.setTitleIfPresent(publicNotificationBuilder, publicNotificationExtras);
            AppboyNotificationUtils.setSummaryTextIfPresentAndSupported(publicNotificationBuilder, publicNotificationExtras);
            AppboyNotificationUtils.setSmallIcon(xmlAppConfigurationProvider, publicNotificationBuilder);
            AppboyNotificationUtils.setAccentColorIfPresentAndSupported(xmlAppConfigurationProvider, publicNotificationBuilder, publicNotificationExtras);
            notificationBuilder.setPublicVersion(publicNotificationBuilder.build());
        }
    }

    @TargetApi(value=21)
    public static boolean isValidNotificationVisibility(int visibility) {
        return visibility == -1 || visibility == 0 || visibility == 1;
    }

    public static void logBaiduNotificationClick(Context context, String customContentString) {
        if (customContentString == null) {
            AppboyLogger.w((String)TAG, (String)"customContentString was null. Doing nothing.");
            return;
        }
        try {
            JSONObject jsonExtras = new JSONObject(customContentString);
            String source = jsonExtras.optString(SOURCE_KEY, null);
            String campaignId = jsonExtras.optString("cid", null);
            if (source != null && "Appboy".equals(source) && campaignId != null) {
                Appboy.getInstance((Context)context).logPushNotificationOpened(campaignId);
            }
        }
        catch (Exception e) {
            AppboyLogger.e((String)TAG, (String)String.format("Caught an exception processing customContentString: %s", customContentString), (Throwable)e);
        }
    }

    public static void handleCancelNotificationAction(Context context, Intent intent) {
        try {
            if (intent.hasExtra("nid")) {
                int notificationId = intent.getIntExtra("nid", -1);
                NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                notificationManager.cancel("appboy_notification", notificationId);
            }
        }
        catch (Exception e) {
            AppboyLogger.e((String)TAG, (String)"Exception occurred handling cancel notification intent.", (Throwable)e);
        }
    }

    public static void cancelNotification(Context context, int notificationId) {
        try {
            Intent cancelNotificationIntent = new Intent("com.appboy.action.CANCEL_NOTIFICATION").setClass(context, AppboyNotificationUtils.getNotificationReceiverClass());
            cancelNotificationIntent.putExtra("nid", notificationId);
            context.sendBroadcast(cancelNotificationIntent);
        }
        catch (Exception e) {
            AppboyLogger.e((String)TAG, (String)"Exception occurred attempting to cancel notification.", (Throwable)e);
        }
    }

    public static Class<?> getNotificationReceiverClass() {
        if (Constants.IS_AMAZON.booleanValue()) {
            return AppboyAdmReceiver.class;
        }
        return AppboyGcmReceiver.class;
    }

    public static boolean isUninstallTrackingPush(Bundle notificationExtras) {
        if (notificationExtras != null) {
            if (notificationExtras.containsKey("appboy_uninstall_tracking")) {
                return true;
            }
            Bundle appboyExtras = notificationExtras.getBundle("extra");
            if (appboyExtras != null) {
                return appboyExtras.containsKey("appboy_uninstall_tracking");
            }
        }
        return false;
    }

    static String getOptionalStringResource(Resources resources, int stringResourceId, String defaultString) {
        try {
            return resources.getString(stringResourceId);
        }
        catch (Resources.NotFoundException e) {
            return defaultString;
        }
    }

    static void sendNotificationOpenedBroadcast(Context context, Intent intent) {
        String pushOpenedAction = PackageUtils.getResourcePackageName((Context)context) + APPBOY_NOTIFICATION_OPENED_SUFFIX;
        Intent pushOpenedIntent = new Intent(pushOpenedAction);
        if (intent.getExtras() != null) {
            pushOpenedIntent.putExtras(intent.getExtras());
        }
        context.sendBroadcast(pushOpenedIntent);
    }

    private static void logNotificationOpened(Context context, Intent intent) {
        String campaignId = intent.getStringExtra("cid");
        if (campaignId != null) {
            AppboyLogger.i((String)TAG, (String)String.format("Logging push click to Appboy. Campaign Id: " + campaignId, new Object[0]));
            Appboy.getInstance((Context)context).logPushNotificationOpened(campaignId);
        } else {
            AppboyLogger.i((String)TAG, (String)String.format("No campaign Id associated with this notification. Not logging push click to Appboy.", new Object[0]));
        }
    }
}

