/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.adapters;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import com.appboy.Constants;
import com.appboy.models.cards.BannerImageCard;
import com.appboy.models.cards.CaptionedImageCard;
import com.appboy.models.cards.Card;
import com.appboy.models.cards.CrossPromotionSmallCard;
import com.appboy.models.cards.ShortNewsCard;
import com.appboy.models.cards.TextAnnouncementCard;
import com.appboy.support.AppboyLogger;
import com.appboy.ui.configuration.XmlUIConfigurationProvider;
import com.appboy.ui.widget.BannerImageCardView;
import com.appboy.ui.widget.BaseCardView;
import com.appboy.ui.widget.CaptionedImageCardView;
import com.appboy.ui.widget.CrossPromotionSmallCardView;
import com.appboy.ui.widget.DefaultCardView;
import com.appboy.ui.widget.ShortNewsCardView;
import com.appboy.ui.widget.TextAnnouncementCardView;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AppboyListAdapter
extends ArrayAdapter<Card> {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, AppboyListAdapter.class.getName());
    private final Context mContext;
    private final Set<String> mCardIdImpressions;
    private final XmlUIConfigurationProvider mUiConfigurationProvider;

    public AppboyListAdapter(Context context, int layoutResourceId, List<Card> cards) {
        super(context, layoutResourceId, cards);
        this.mContext = context;
        this.mCardIdImpressions = new HashSet<String>();
        this.mUiConfigurationProvider = new XmlUIConfigurationProvider(context);
    }

    public int getViewTypeCount() {
        return 8;
    }

    public int getItemViewType(int position) {
        Card card = (Card)this.getItem(position);
        if (card instanceof BannerImageCard) {
            return 1;
        }
        if (card instanceof CaptionedImageCard) {
            return 2;
        }
        if (card instanceof CrossPromotionSmallCard) {
            return 3;
        }
        if (card instanceof ShortNewsCard) {
            return 4;
        }
        if (card instanceof TextAnnouncementCard) {
            return 5;
        }
        return 0;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        BaseCardView view;
        Card card = (Card)this.getItem(position);
        if (convertView == null) {
            view = card instanceof BannerImageCard ? new BannerImageCardView(this.mContext) : (card instanceof CaptionedImageCard ? new CaptionedImageCardView(this.mContext) : (card instanceof CrossPromotionSmallCard ? new CrossPromotionSmallCardView(this.mContext) : (card instanceof ShortNewsCard ? new ShortNewsCardView(this.mContext) : (card instanceof TextAnnouncementCard ? new TextAnnouncementCardView(this.mContext) : new DefaultCardView(this.mContext)))));
        } else {
            AppboyLogger.d((String)TAG, (String)("Reusing convertView for rendering of item " + position));
            view = (BaseCardView)convertView;
        }
        AppboyLogger.d((String)TAG, (String)String.format("Using view of type: %s for card at position %d: %s", view.getClass().getName(), position, card.toString()));
        view.setCard(card);
        this.logCardImpression(card);
        return view;
    }

    public synchronized void replaceFeed(List<Card> cards) {
        this.setNotifyOnChange(false);
        if (cards == null) {
            this.clear();
            this.notifyDataSetChanged();
            return;
        }
        AppboyLogger.d((String)TAG, (String)String.format("Replacing existing feed of %d cards with new feed containing %d cards.", this.getCount(), cards.size()));
        int i = 0;
        int j = 0;
        int newFeedSize = cards.size();
        while (i < this.getCount()) {
            Card existingCard = (Card)this.getItem(i);
            Card newCard = null;
            if (j < newFeedSize) {
                newCard = cards.get(j);
            }
            if (newCard != null && newCard.isEqualToCard(existingCard)) {
                ++i;
                ++j;
                continue;
            }
            this.remove(existingCard);
        }
        if (Build.VERSION.SDK_INT < 11) {
            while (j < newFeedSize) {
                this.add(cards.get(j));
                ++j;
            }
        } else {
            this.addAllBatch(cards.subList(j, newFeedSize));
        }
        this.notifyDataSetChanged();
    }

    public synchronized void add(Card card) {
        super.add((Object)card);
    }

    @TargetApi(value=11)
    private synchronized void addAllBatch(Collection<Card> cards) {
        super.addAll(cards);
    }

    public void resetCardImpressionTracker() {
        this.mCardIdImpressions.clear();
    }

    private void logCardImpression(Card card) {
        String cardId = card.getId();
        if (!this.mCardIdImpressions.contains(cardId)) {
            this.mCardIdImpressions.add(cardId);
            card.logImpression();
            AppboyLogger.d((String)TAG, (String)String.format("Logged impression for card %s", cardId));
        } else {
            AppboyLogger.d((String)TAG, (String)String.format("Already counted impression for card %s", cardId));
        }
        if (!card.getViewed()) {
            card.setViewed(true);
        }
    }

    public void batchSetCardsToRead(int startIndex, int endIndex) {
        if (this.getCount() == 0) {
            AppboyLogger.d((String)TAG, (String)"mAdapter is empty in setting some cards to viewed.");
            return;
        }
        startIndex = Math.max(0, startIndex);
        endIndex = Math.min(this.getCount(), endIndex);
        for (int traversalIndex = startIndex; traversalIndex < endIndex; ++traversalIndex) {
            Card card = (Card)this.getItem(traversalIndex);
            if (card == null) {
                AppboyLogger.d((String)TAG, (String)"Card was null in setting some cards to viewed.");
                break;
            }
            if (card.isRead()) continue;
            card.setIsRead(true);
        }
    }
}

