/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.inappmessage.factories;

import android.content.res.Resources;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import com.appboy.enums.inappmessage.SlideFrom;
import com.appboy.models.IInAppMessage;
import com.appboy.models.InAppMessageSlideup;
import com.appboy.ui.inappmessage.IInAppMessageAnimationFactory;
import com.appboy.ui.support.AnimationUtils;

public class AppboyInAppMessageAnimationFactory
implements IInAppMessageAnimationFactory {
    private final int mShortAnimationDurationMillis = Resources.getSystem().getInteger(0x10E0000);

    @Override
    public Animation getOpeningAnimation(IInAppMessage inAppMessage) {
        if (inAppMessage instanceof InAppMessageSlideup) {
            InAppMessageSlideup inAppMessageSlideup = (InAppMessageSlideup)inAppMessage;
            if (inAppMessageSlideup.getSlideFrom() == SlideFrom.TOP) {
                return AnimationUtils.createVerticalAnimation(-1.0f, 0.0f, this.mShortAnimationDurationMillis, false);
            }
            return AnimationUtils.createVerticalAnimation(1.0f, 0.0f, this.mShortAnimationDurationMillis, false);
        }
        return AnimationUtils.setAnimationParams((Animation)new AlphaAnimation(0.0f, 1.0f), this.mShortAnimationDurationMillis, true);
    }

    @Override
    public Animation getClosingAnimation(IInAppMessage inAppMessage) {
        if (inAppMessage instanceof InAppMessageSlideup) {
            InAppMessageSlideup inAppMessageSlideup = (InAppMessageSlideup)inAppMessage;
            if (inAppMessageSlideup.getSlideFrom() == SlideFrom.TOP) {
                return AnimationUtils.createVerticalAnimation(0.0f, -1.0f, this.mShortAnimationDurationMillis, false);
            }
            return AnimationUtils.createVerticalAnimation(0.0f, 1.0f, this.mShortAnimationDurationMillis, false);
        }
        return AnimationUtils.setAnimationParams((Animation)new AlphaAnimation(1.0f, 0.0f), this.mShortAnimationDurationMillis, false);
    }
}

