/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.inappmessage.listeners;

import android.content.Context;
import android.net.Uri;
import android.view.View;
import com.appboy.Constants;
import com.appboy.enums.inappmessage.ClickAction;
import com.appboy.models.IInAppMessage;
import com.appboy.models.IInAppMessageHtml;
import com.appboy.models.IInAppMessageImmersive;
import com.appboy.models.MessageButton;
import com.appboy.support.AppboyLogger;
import com.appboy.support.BundleUtils;
import com.appboy.support.WebContentUtils;
import com.appboy.ui.actions.ActionFactory;
import com.appboy.ui.actions.IAction;
import com.appboy.ui.inappmessage.AppboyInAppMessageManager;
import com.appboy.ui.inappmessage.InAppMessageCloser;
import com.appboy.ui.inappmessage.listeners.IInAppMessageViewLifecycleListener;
import java.util.Map;

public class AppboyInAppMessageViewLifecycleListener
implements IInAppMessageViewLifecycleListener {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, AppboyInAppMessageViewLifecycleListener.class.getName());

    @Override
    public void beforeOpened(View inAppMessageView, IInAppMessage inAppMessage) {
        AppboyLogger.d((String)TAG, (String)"InAppMessageViewWrapper.IInAppMessageViewLifecycleListener.beforeOpened called.");
        inAppMessage.logImpression();
    }

    @Override
    public void afterOpened(View inAppMessageView, IInAppMessage inAppMessage) {
        AppboyLogger.d((String)TAG, (String)"InAppMessageViewWrapper.IInAppMessageViewLifecycleListener.afterOpened called.");
    }

    @Override
    public void beforeClosed(View inAppMessageView, IInAppMessage inAppMessage) {
        AppboyLogger.d((String)TAG, (String)"InAppMessageViewWrapper.IInAppMessageViewLifecycleListener.beforeClosed called.");
    }

    @Override
    public void afterClosed(IInAppMessage inAppMessage) {
        AppboyLogger.d((String)TAG, (String)"InAppMessageViewWrapper.IInAppMessageViewLifecycleListener.afterClosed called.");
        this.getInAppMessageManager().resetAfterInAppMessageClose();
        if (inAppMessage instanceof IInAppMessageHtml) {
            this.startClearHtmlInAppMessageAssetsThread((IInAppMessageHtml)inAppMessage);
        }
    }

    @Override
    public void onClicked(InAppMessageCloser inAppMessageCloser, View inAppMessageView, IInAppMessage inAppMessage) {
        boolean handled;
        AppboyLogger.d((String)TAG, (String)"InAppMessageViewWrapper.IInAppMessageViewLifecycleListener.onClicked called.");
        if (inAppMessage.getClickAction() != ClickAction.NONE) {
            inAppMessage.logClick();
        }
        if (!(handled = this.getInAppMessageManager().getInAppMessageManagerListener().onInAppMessageClicked(inAppMessage, inAppMessageCloser))) {
            this.performInAppMessageClicked(inAppMessage, inAppMessageCloser);
        }
    }

    @Override
    public void onButtonClicked(InAppMessageCloser inAppMessageCloser, MessageButton messageButton, IInAppMessageImmersive inAppMessageImmersive) {
        boolean handled;
        AppboyLogger.d((String)TAG, (String)"InAppMessageViewWrapper.IInAppMessageViewLifecycleListener.onButtonClicked called.");
        if (messageButton.getClickAction() != ClickAction.NONE) {
            inAppMessageImmersive.logButtonClick(messageButton);
        }
        if (!(handled = this.getInAppMessageManager().getInAppMessageManagerListener().onInAppMessageButtonClicked(messageButton, inAppMessageCloser))) {
            this.performInAppMessageButtonClicked(messageButton, (IInAppMessage)inAppMessageImmersive, inAppMessageCloser);
        }
    }

    @Override
    public void onDismissed(View inAppMessageView, IInAppMessage inAppMessage) {
        AppboyLogger.d((String)TAG, (String)"InAppMessageViewWrapper.IInAppMessageViewLifecycleListener.onDismissed called.");
        this.getInAppMessageManager().getInAppMessageManagerListener().onInAppMessageDismissed(inAppMessage);
    }

    private void performInAppMessageButtonClicked(MessageButton messageButton, IInAppMessage inAppMessage, InAppMessageCloser inAppMessageCloser) {
        this.performClickAction(messageButton.getClickAction(), inAppMessage, inAppMessageCloser, messageButton.getUri());
    }

    private void performInAppMessageClicked(IInAppMessage inAppMessage, InAppMessageCloser inAppMessageCloser) {
        this.performClickAction(inAppMessage.getClickAction(), inAppMessage, inAppMessageCloser, inAppMessage.getUri());
    }

    private void performClickAction(ClickAction clickAction, IInAppMessage inAppMessage, InAppMessageCloser inAppMessageCloser, Uri clickUri) {
        if (this.getInAppMessageManager().getActivity() == null) {
            AppboyLogger.w((String)TAG, (String)"Can't perform click action because the cached activity is null.");
            return;
        }
        switch (clickAction) {
            case NEWS_FEED: {
                inAppMessage.setAnimateOut(false);
                inAppMessageCloser.close(false);
                this.getInAppMessageManager().getAppboyNavigator().gotoNewsFeed((Context)this.getInAppMessageManager().getActivity(), BundleUtils.mapToBundle((Map)inAppMessage.getExtras()));
                break;
            }
            case URI: {
                inAppMessage.setAnimateOut(false);
                inAppMessageCloser.close(false);
                IAction action = ActionFactory.createUriAction((Context)this.getInAppMessageManager().getActivity(), clickUri.toString());
                action.execute((Context)this.getInAppMessageManager().getActivity());
                break;
            }
            case NONE: {
                inAppMessageCloser.close(true);
                break;
            }
            default: {
                inAppMessageCloser.close(false);
            }
        }
    }

    private AppboyInAppMessageManager getInAppMessageManager() {
        return AppboyInAppMessageManager.getInstance();
    }

    private void startClearHtmlInAppMessageAssetsThread(final IInAppMessageHtml inAppMessageHtml) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (inAppMessageHtml != null) {
                    WebContentUtils.clearInAppMessageLocalAssets((IInAppMessageHtml)inAppMessageHtml);
                }
            }
        }).start();
    }
}

