/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.inappmessage.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewStub;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.appboy.support.StringUtils;
import com.appboy.ui.R;
import com.appboy.ui.inappmessage.IInAppMessageView;
import com.appboy.ui.inappmessage.views.InAppMessageViewUtils;
import com.appboy.ui.support.FrescoLibraryUtils;
import com.appboy.ui.support.ViewUtils;
import com.facebook.drawee.view.SimpleDraweeView;

public abstract class AppboyInAppMessageBaseView
extends RelativeLayout
implements IInAppMessageView {
    final boolean mCanUseFresco;

    public AppboyInAppMessageBaseView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mCanUseFresco = FrescoLibraryUtils.canUseFresco(context);
    }

    public void setMessageBackgroundColor(int color2) {
        InAppMessageViewUtils.setViewBackgroundColor((View)this.getMessageBackgroundObject(), color2);
    }

    public void setMessageTextColor(int color2) {
        InAppMessageViewUtils.setTextViewColor(this.getMessageTextView(), color2);
    }

    public void setMessage(String text) {
        this.getMessageTextView().setText((CharSequence)text);
    }

    public void setMessageImageView(Bitmap bitmap) {
        InAppMessageViewUtils.setImage(bitmap, this.getMessageImageView());
    }

    public void setMessageSimpleDrawee(String imageUrl) {
        FrescoLibraryUtils.setDraweeControllerHelper((SimpleDraweeView)this.getMessageSimpleDraweeView(), imageUrl, 0.0f, false);
    }

    public void setMessageIcon(String icon, int iconColor, int iconBackgroundColor) {
        InAppMessageViewUtils.setIcon(this.getContext(), icon, iconColor, iconBackgroundColor, this.getMessageIconView());
    }

    @Deprecated
    public void resetMessageMargins() {
        boolean successful = false;
        if (this.getMessageImageView() != null && this.getMessageImageView().getDrawable() != null) {
            successful = true;
        }
        this.resetMessageMargins(successful);
    }

    public void resetMessageMargins(boolean imageRetrievalSuccessful) {
        RelativeLayout layoutContainingImage;
        View viewContainingImage;
        if (this.mCanUseFresco) {
            viewContainingImage = this.getMessageSimpleDraweeView();
            layoutContainingImage = (RelativeLayout)this.findViewById(R.id.com_appboy_stubbed_inappmessage_drawee_view_parent);
        } else {
            viewContainingImage = this.getMessageImageView();
            layoutContainingImage = (RelativeLayout)this.findViewById(R.id.com_appboy_stubbed_inappmessage_image_view_parent);
        }
        if (viewContainingImage != null) {
            if (!imageRetrievalSuccessful) {
                ViewUtils.removeViewFromParent(viewContainingImage);
                if (layoutContainingImage != null) {
                    ViewUtils.removeViewFromParent((View)layoutContainingImage);
                }
            } else {
                ViewUtils.removeViewFromParent((View)this.getMessageIconView());
            }
        }
        if (this.getMessageIconView() != null && StringUtils.isNullOrBlank((String)((String)this.getMessageIconView().getText()))) {
            ViewUtils.removeViewFromParent((View)this.getMessageIconView());
        }
    }

    @Override
    public View getMessageClickableView() {
        return this;
    }

    public abstract TextView getMessageTextView();

    public abstract ImageView getMessageImageView();

    public abstract TextView getMessageIconView();

    public abstract Object getMessageBackgroundObject();

    public abstract View getMessageSimpleDraweeView();

    View getProperViewFromInflatedStub(int stubLayoutId) {
        ViewStub imageStub = (ViewStub)this.findViewById(stubLayoutId);
        imageStub.inflate();
        if (this.mCanUseFresco) {
            return this.findViewById(R.id.com_appboy_stubbed_inappmessage_drawee_view);
        }
        return this.findViewById(R.id.com_appboy_stubbed_inappmessage_image_view);
    }
}

