/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.inappmessage.views;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.appboy.Constants;
import com.appboy.models.MessageButton;
import com.appboy.support.AppboyLogger;
import com.appboy.ui.R;
import com.appboy.ui.inappmessage.AppboyInAppMessageManager;
import com.appboy.ui.support.ViewUtils;
import java.util.List;

public class InAppMessageViewUtils {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, InAppMessageViewUtils.class.getName());

    public static void setImage(Bitmap bitmap, ImageView imageView) {
        if (bitmap != null) {
            imageView.setImageBitmap(bitmap);
        }
    }

    public static void setIcon(Context context, String icon, int iconColor, int iconBackgroundColor, TextView textView) {
        if (InAppMessageViewUtils.isValidIcon(icon)) {
            try {
                Typeface fontFamily = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fontawesome-webfont.ttf");
                textView.setTypeface(fontFamily);
            }
            catch (Exception e) {
                AppboyLogger.e((String)TAG, (String)"Caught exception setting icon typeface. Not rendering icon.", (Throwable)e);
                return;
            }
            textView.setText((CharSequence)icon);
            InAppMessageViewUtils.setTextViewColor(textView, iconColor);
            if (textView.getBackground() != null) {
                InAppMessageViewUtils.setDrawableColor(textView.getBackground(), iconBackgroundColor, context.getResources().getColor(R.color.com_appboy_inappmessage_icon_background));
            } else {
                InAppMessageViewUtils.setViewBackgroundColor((View)textView, iconBackgroundColor);
            }
        }
    }

    public static void setButtons(List<View> buttonViews, View buttonLayoutView, int defaultColor, List<MessageButton> messageButtons) {
        if (messageButtons == null || messageButtons.size() == 0) {
            ViewUtils.removeViewFromParent(buttonLayoutView);
            return;
        }
        for (int i = 0; i < buttonViews.size(); ++i) {
            if (messageButtons.size() <= i) {
                buttonViews.get(i).setVisibility(8);
                continue;
            }
            if (!(buttonViews.get(i) instanceof Button)) continue;
            Button button = (Button)buttonViews.get(i);
            MessageButton messageButton = messageButtons.get(i);
            button.setText((CharSequence)messageButton.getText());
            InAppMessageViewUtils.setTextViewColor((TextView)button, messageButton.getTextColor());
            InAppMessageViewUtils.setDrawableColor(button.getBackground(), messageButton.getBackgroundColor(), defaultColor);
        }
    }

    public static void setModalFrameColor(View view, Integer color2) {
        if (color2 != null) {
            view.setBackgroundColor(color2.intValue());
        }
    }

    public static void setTextViewColor(TextView textView, int color2) {
        if (InAppMessageViewUtils.isValidInAppMessageColor(color2)) {
            textView.setTextColor(color2);
        }
    }

    public static void setViewBackgroundColor(View view, int color2) {
        if (InAppMessageViewUtils.isValidInAppMessageColor(color2)) {
            view.setBackgroundColor(color2);
        }
    }

    public static void setViewBackgroundColorFilter(View view, int color2, int defaultColor) {
        if (InAppMessageViewUtils.isValidInAppMessageColor(color2)) {
            view.getBackground().setColorFilter(color2, PorterDuff.Mode.MULTIPLY);
        } else {
            view.getBackground().setColorFilter(defaultColor, PorterDuff.Mode.MULTIPLY);
        }
    }

    public static void setDrawableColor(Drawable drawable2, int color2, int defaultColor) {
        if (drawable2 instanceof GradientDrawable) {
            InAppMessageViewUtils.setDrawableColor((GradientDrawable)drawable2, color2, defaultColor);
        } else if (InAppMessageViewUtils.isValidInAppMessageColor(color2)) {
            drawable2.setColorFilter(color2, PorterDuff.Mode.MULTIPLY);
        } else {
            drawable2.setColorFilter(defaultColor, PorterDuff.Mode.MULTIPLY);
        }
    }

    public static void setDrawableColor(GradientDrawable gradientDrawable, int color2, int defaultColor) {
        if (InAppMessageViewUtils.isValidInAppMessageColor(color2)) {
            gradientDrawable.setColor(color2);
        } else {
            gradientDrawable.setColor(defaultColor);
        }
    }

    public static boolean isValidInAppMessageColor(int color2) {
        return color2 != 0;
    }

    public static boolean isValidIcon(String icon) {
        return icon != null;
    }

    protected static void resetMessageMarginsIfNecessary(TextView messageView, TextView headerView) {
        if (headerView == null && messageView != null) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
            layoutParams.setMargins(0, 0, 0, 0);
            messageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    protected static void resetButtonSizesIfNecessary(List<View> buttonViews, List<MessageButton> messageButtons) {
        if (messageButtons != null && messageButtons.size() == 1) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, -2, 1.0f);
            buttonViews.get(0).setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public static void closeInAppMessageOnKeycodeBack() {
        AppboyLogger.d((String)TAG, (String)"Back button intercepted by in-app message view, closing in-app message.");
        AppboyInAppMessageManager.getInstance().hideCurrentInAppMessage(true, true);
    }
}

