/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.support;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Animatable;
import android.net.Uri;
import com.appboy.Constants;
import com.appboy.support.AppboyLogger;
import com.appboy.support.PackageUtils;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.backends.pipeline.PipelineDraweeControllerBuilder;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.controller.BaseControllerListener;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.view.SimpleDraweeView;
import com.facebook.imagepipeline.image.ImageInfo;

public class FrescoLibraryUtils {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, FrescoLibraryUtils.class.getName());
    public static final String FRESCO_ENABLED = "com_appboy_enable_fresco_library_use";
    private static boolean sCanUseFresco = false;
    private static boolean sCanUseFrescoSet = false;
    private static final String[] USED_FRESCO_CLASSES = new String[]{"com.facebook.drawee.backends.pipeline.Fresco", "com.facebook.drawee.interfaces.DraweeController", "com.facebook.drawee.view.SimpleDraweeView", "com.facebook.drawee.backends.pipeline.Fresco", "com.facebook.drawee.controller.BaseControllerListener", "com.facebook.drawee.controller.ControllerListener", "com.facebook.imagepipeline.image.ImageInfo"};

    private static boolean getIsFrescoEnabledFromXml(Resources resources, String resourcePackageName) {
        int resId = resources.getIdentifier(FRESCO_ENABLED, "bool", resourcePackageName);
        boolean frescoEnabledXmlSetting = resId != 0 ? resources.getBoolean(resId) : false;
        return frescoEnabledXmlSetting;
    }

    public static boolean canUseFresco(Context context) {
        boolean isFrescoOnPath;
        if (sCanUseFrescoSet) {
            return sCanUseFresco;
        }
        context = context.getApplicationContext();
        boolean isFrescoEnabledFromXml = FrescoLibraryUtils.getIsFrescoEnabledFromXml(context.getResources(), PackageUtils.getResourcePackageName((Context)context));
        try {
            ClassLoader staticClassLoader = FrescoLibraryUtils.class.getClassLoader();
            isFrescoOnPath = true;
            for (String classPath : USED_FRESCO_CLASSES) {
                if (Class.forName(classPath, false, staticClassLoader) != null) continue;
                isFrescoOnPath = false;
                break;
            }
        }
        catch (Exception e) {
            isFrescoOnPath = false;
        }
        catch (NoClassDefFoundError ncd) {
            isFrescoOnPath = false;
        }
        catch (Throwable t) {
            isFrescoOnPath = false;
        }
        sCanUseFrescoSet = true;
        sCanUseFresco = isFrescoOnPath && isFrescoEnabledFromXml;
        return sCanUseFresco;
    }

    public static void setDraweeControllerHelper(final SimpleDraweeView simpleDraweeView, String imageUrl, final float aspectRatio, final boolean respectAspectRatio) {
        if (imageUrl == null) {
            AppboyLogger.w((String)TAG, (String)"The url set for the Drawee controller was null. Controller not set.");
            return;
        }
        if (simpleDraweeView == null) {
            AppboyLogger.w((String)TAG, (String)"The SimpleDraweeView set for the Drawee controller was null. Controller not set.");
            return;
        }
        BaseControllerListener<ImageInfo> controllerListener = new BaseControllerListener<ImageInfo>(){

            public void onFinalImageSet(String id2, ImageInfo imageInfo, Animatable animatable) {
                if (imageInfo == null) {
                    return;
                }
                final float imageAspectRatio = respectAspectRatio ? aspectRatio : (float)(imageInfo.getWidth() / imageInfo.getHeight());
                simpleDraweeView.post(new Runnable(){

                    @Override
                    public void run() {
                        simpleDraweeView.setAspectRatio(imageAspectRatio);
                    }
                });
            }
        };
        try {
            Uri uri = Uri.parse((String)imageUrl);
            AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setUri(uri).setAutoPlayAnimations(true)).setTapToRetryEnabled(true)).setControllerListener((ControllerListener)controllerListener)).build();
            simpleDraweeView.setController((DraweeController)controller);
        }
        catch (NullPointerException e) {
            AppboyLogger.e((String)TAG, (String)"Fresco controller builder could not be retrieved. Fresco most likely prematurely shutdown.", (Throwable)e);
        }
        catch (Exception e) {
            AppboyLogger.e((String)TAG, (String)"Fresco controller builder could not be retrieved. Fresco most likely prematurely shutdown.", (Throwable)e);
        }
    }

    static boolean canUseFrescoMock(Context context, Resources resources, boolean isFrescoOnPath) {
        return isFrescoOnPath && FrescoLibraryUtils.getIsFrescoEnabledFromXml(resources, PackageUtils.getResourcePackageName((Context)context.getApplicationContext()));
    }
}

