/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.configuration;

import android.content.Context;
import com.appboy.Constants;
import com.appboy.support.PackageUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CachedConfigurationProvider {
    private static final String a = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, CachedConfigurationProvider.class.getName());
    private final Context b;
    protected final Map<String, Object> mConfigurationCache;

    /*
     * WARNING - void declaration
     */
    public CachedConfigurationProvider(Context context) {
        void var1_1;
        this.b = var1_1;
        this.mConfigurationCache = Collections.synchronizedMap(new HashMap());
    }

    /*
     * WARNING - void declaration
     */
    protected boolean getBooleanValue(String key, boolean defaultValue) {
        void var1_1;
        boolean bl2;
        if (this.mConfigurationCache.containsKey(key)) {
            return (Boolean)this.mConfigurationCache.get(key);
        }
        bl2 = this.readBooleanResourceValue(key, bl2);
        this.mConfigurationCache.put((String)var1_1, bl2);
        return bl2;
    }

    /*
     * WARNING - void declaration
     */
    protected String getStringValue(String key, String defaultValue) {
        void var1_1;
        String string2;
        if (this.mConfigurationCache.containsKey(key)) {
            return (String)this.mConfigurationCache.get(key);
        }
        string2 = this.readStringResourceValue(key, string2);
        this.mConfigurationCache.put((String)var1_1, string2);
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public int getIntValue(String key, int defaultValue) {
        void var1_1;
        int n2;
        if (this.mConfigurationCache.containsKey(key)) {
            return (Integer)this.mConfigurationCache.get(key);
        }
        n2 = this.readIntegerResourceValue(key, n2);
        this.mConfigurationCache.put((String)var1_1, n2);
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    protected int readIntegerResourceValue(String key, int defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        int n2 = this.b.getResources().getIdentifier(key, "integer", PackageUtils.getResourcePackageName(this.b));
        if (n2 == 0) {
            void var2_2;
            void var1_1;
            String.format("Unable to find the integer configuration value with key %s. Using default value '%d'.", var1_1, defaultValue);
            return (int)var2_2;
        }
        return this.b.getResources().getInteger(n2);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean readBooleanResourceValue(String key, boolean defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        int n2 = this.b.getResources().getIdentifier(key, "bool", PackageUtils.getResourcePackageName(this.b));
        if (n2 == 0) {
            void var2_2;
            void var1_1;
            String.format("Unable to find the boolean configuration value with key %s. Using default value '%b'.", var1_1, defaultValue);
            return (boolean)var2_2;
        }
        return this.b.getResources().getBoolean(n2);
    }

    /*
     * WARNING - void declaration
     */
    protected String readStringResourceValue(String key, String defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        int n2 = this.b.getResources().getIdentifier(key, "string", PackageUtils.getResourcePackageName(this.b));
        if (n2 == 0) {
            void var2_2;
            void var1_1;
            String.format("Unable to find the boolean configuration value with key %s. Using default value '%s'.", var1_1, defaultValue);
            return var2_2;
        }
        return this.b.getResources().getString(n2);
    }

    /*
     * WARNING - void declaration
     */
    protected String[] readStringArrayResourceValue(String key, String[] defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        int n2 = this.b.getResources().getIdentifier(key, "array", PackageUtils.getResourcePackageName(this.b));
        if (n2 == 0) {
            void var2_2;
            void var1_1;
            String.format("Unable to find the string array configuration value with key %s. Using default value '%s'.", var1_1, Arrays.toString(defaultValue));
            return var2_2;
        }
        return this.b.getResources().getStringArray(n2);
    }
}

