/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.support;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import com.appboy.Constants;
import com.appboy.support.AppboyLogger;
import com.appboy.support.PermissionUtils;
import com.appboy.support.StringUtils;
import java.io.File;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AppboyFileUtils {
    private static final String a = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, AppboyFileUtils.class.getName());
    public static final List<String> REMOTE_SCHEMES = Collections.unmodifiableList(Arrays.asList("http", "https", "ftp", "ftps", "about", "javascript"));

    public static void deleteFileOrDirectory(File fileOrDirectory) {
        File file;
        if (fileOrDirectory == null || !fileOrDirectory.exists()) {
            return;
        }
        if (fileOrDirectory.isDirectory()) {
            for (String string2 : fileOrDirectory.list()) {
                AppboyFileUtils.deleteFileOrDirectory(new File(fileOrDirectory, string2));
            }
        }
        file.delete();
    }

    /*
     * WARNING - void declaration
     */
    public static File getApplicationPrivateStorage(Context context, String type) {
        Context context2;
        if (Build.VERSION.SDK_INT >= 19) {
            return context.getExternalFilesDirs(type)[0];
        }
        if (PermissionUtils.hasPermission(context, "android.permission.WRITE_EXTERNAL_STORAGE")) {
            void var1_1;
            return context.getExternalFilesDir((String)var1_1);
        }
        return context2.getFilesDir();
    }

    public static String getMimeType(String remoteUrl) {
        String string2;
        if (StringUtils.isNullOrBlank(remoteUrl)) {
            return null;
        }
        return URLConnection.guessContentTypeFromName(string2.split("\\?")[0]);
    }

    public static boolean canStoreAssetsLocally(Context context) {
        Context context2;
        return Build.VERSION.SDK_INT >= 19 || PermissionUtils.hasPermission(context2, "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    public static boolean isRemoteUri(Uri uri) {
        Object object;
        if (uri == null) {
            AppboyLogger.i(a, "Null Uri received.");
            return false;
        }
        if (StringUtils.isNullOrBlank((String)(object = object.getScheme()))) {
            AppboyLogger.i(a, "Null or blank Uri scheme.");
            return false;
        }
        return REMOTE_SCHEMES.contains(object);
    }

    public static boolean isLocalUri(Uri uri) {
        Object object;
        if (uri == null) {
            AppboyLogger.i(a, "Null Uri received.");
            return false;
        }
        return StringUtils.isNullOrBlank((String)(object = object.getScheme())) || ((String)object).equals("file");
    }
}

