/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.support;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Environment;
import com.appboy.Constants;
import com.appboy.support.AppboyFileUtils;
import com.appboy.support.AppboyLogger;
import com.appboy.support.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

public class AppboyImageUtils {
    private static final String a = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, AppboyImageUtils.class.getName());

    /*
     * WARNING - void declaration
     */
    public static Uri storeBitmap(Context context, Bitmap imageBitmap, String imageFilenameBase, String folderName, boolean external) {
        if (context == null) {
            AppboyLogger.w(a, "Received null context. Doing nothing.");
            return null;
        }
        if (imageBitmap == null) {
            AppboyLogger.w(a, "Received null bitmap. Doing nothing.");
            return null;
        }
        if (StringUtils.isNullOrBlank(imageFilenameBase)) {
            AppboyLogger.w(a, "Received null or blank image filename base. Doing nothing.");
            return null;
        }
        if (StringUtils.isNullOrBlank(folderName)) {
            AppboyLogger.w(a, "Received null or blank image folder name. Doing nothing.");
            return null;
        }
        try {
            void var1_1;
            FileOutputStream fileOutputStream;
            Object object;
            if (external) {
                object = Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + (String)object;
                object = new File((String)object);
            } else {
                object = AppboyFileUtils.getApplicationPrivateStorage(context, (String)object);
            }
            if (!((File)object).exists()) {
                ((File)object).mkdirs();
            }
            object = new File((File)object, (String)((Object)fileOutputStream) + ".png");
            fileOutputStream = new FileOutputStream((File)object);
            var1_1.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
            if (external) {
                Context context2;
                MediaScannerConnection.scanFile((Context)context2, (String[])new String[]{((File)object).getAbsolutePath()}, null, null);
            }
            AppboyLogger.i(a, "Stored image locally at " + ((File)object).getAbsolutePath());
            return Uri.fromFile((File)object);
        }
        catch (Exception exception) {
            AppboyLogger.e(a, "Exception occurred when attempting to store image locally.", exception);
            return null;
        }
    }

    public static Bitmap getBitmap(Uri uri) {
        if (uri == null) {
            AppboyLogger.i(a, "Null Uri received. Not getting image.");
            return null;
        }
        if (AppboyFileUtils.isLocalUri(uri)) {
            return AppboyImageUtils.b(uri);
        }
        if (AppboyFileUtils.isRemoteUri(uri)) {
            Uri uri2;
            return AppboyImageUtils.a(uri2);
        }
        AppboyLogger.w(a, "Uri with unknown scheme received. Not getting image.");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static int getPixelsFromDensityAndDp(int dpi, int dp2) {
        void var1_1;
        return Math.abs(dpi * var1_1 / 160);
    }

    private static Bitmap a(Uri object) {
        object = object.toString();
        try {
            InputStream inputStream = new URL((String)object).openStream();
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            if (inputStream != null) {
                inputStream.close();
            }
            return bitmap;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            AppboyLogger.e(a, String.format("Out of Memory Error in image bitmap download for Uri: %s.", object), outOfMemoryError);
        }
        catch (UnknownHostException unknownHostException) {
            AppboyLogger.e(a, String.format("Unknown Host Exception in image bitmap download for Uri: %s. Device may be offline.", object), unknownHostException);
        }
        catch (MalformedURLException malformedURLException) {
            AppboyLogger.e(a, String.format("Malformed URL Exception in image bitmap download for Uri: %s. Image Uri may be corrupted.", object), malformedURLException);
        }
        catch (Exception exception) {
            AppboyLogger.e(a, String.format("Exception in image bitmap download for Uri: %s", object), exception);
        }
        catch (Throwable throwable) {
            AppboyLogger.e(a, String.format("Throwable caught in image bitmap download for Uri: %s", object), throwable);
        }
        return null;
    }

    private static Bitmap b(Uri uri) {
        try {
            File file = new File(uri.getPath());
            if (file.exists()) {
                AppboyLogger.i(a, "Retrieving image from path: " + file.getAbsolutePath());
                return BitmapFactory.decodeFile((String)file.getAbsolutePath());
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            AppboyLogger.e(a, String.format("Out of Memory Error in local bitmap file retrieval for Uri: %s.", uri.toString()), outOfMemoryError);
        }
        catch (Exception exception) {
            AppboyLogger.e(a, "Exception occurred when attempting to retrieve local bitmap.", exception);
        }
        catch (Throwable throwable) {
            AppboyLogger.e(a, String.format("Throwable caught in local bitmap file retrieval for Uri: %s", uri.toString()), throwable);
        }
        return null;
    }
}

