/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.support;

import android.content.res.Resources;
import com.appboy.Constants;
import com.appboy.support.AppboyLogger;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.json.JSONArray;

public final class StringUtils {
    private static final String a = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, StringUtils.class.getName());
    public static final String EMPTY_STRING = "";

    public static String checkNotNullOrEmpty(String reference) {
        String string2;
        if (reference == null) {
            throw new NullPointerException("Provided String must be non-null.");
        }
        if (reference.length() == 0) {
            throw new IllegalArgumentException("Provided String must be non-empty.");
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Collection<String> strings, String sep) {
        void var1_1;
        Collection<String> collection;
        if (strings == null) {
            return EMPTY_STRING;
        }
        return StringUtils.join(strings.toArray(new String[collection.size()]), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(String[] strings, String sep) {
        Object object;
        if (strings == null || sep == null) {
            return EMPTY_STRING;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : object) {
            if (string2 == null) continue;
            stringBuilder.append(string2).append(sep);
        }
        object = stringBuilder.toString();
        if (object != null && ((String)object).endsWith(sep)) {
            void var1_1;
            object = ((String)object).substring(0, ((String)object).length() - var1_1.length());
        }
        return object;
    }

    public static boolean isNullOrEmpty(String reference) {
        String string2;
        return reference == null || string2.length() == 0;
    }

    public static boolean isNullOrBlank(String reference) {
        String string2;
        return reference == null || string2.trim().length() == 0;
    }

    /*
     * WARNING - void declaration
     */
    public static String getOptionalStringResource(Resources resources, int stringResourceId, String defaultString) {
        try {
            void var1_1;
            return resources.getString((int)var1_1);
        }
        catch (Resources.NotFoundException notFoundException) {
            void var2_2;
            return var2_2;
        }
    }

    public static String emptyToNull(String input) {
        String string2;
        if (input.trim().equals(EMPTY_STRING)) {
            return null;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public static int countOccurrences(String reference, String subString) {
        void var1_1;
        return reference.split((String)var1_1, -1).length - 1;
    }

    public static HashSet<String> stringArrayToHashSet(String[] stringArray) {
        String[] stringArray2;
        return new HashSet<String>(Arrays.asList(stringArray2));
    }

    public static HashSet<String> jsonArrayToHashSet(JSONArray jsonArray) {
        HashSet<String> hashSet = new HashSet<String>();
        if (jsonArray != null) {
            for (int i2 = 0; i2 < jsonArray.length(); ++i2) {
                hashSet.add(jsonArray.get(i2).toString());
            }
        }
        return hashSet;
    }

    public static String stringArrayToJsonString(String[] stringArray) {
        String[] stringArray2;
        JSONArray jSONArray = new JSONArray();
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return "[]";
        }
        for (String string2 : stringArray2) {
            jSONArray.put((Object)string2);
        }
        return jSONArray.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String getCacheFileSuffix(String userId, String apiKey) {
        void var1_1;
        String string2 = StringUtils.MD5(userId == null ? "null" : userId.toString());
        if (string2 == null) {
            String string3;
            string2 = Integer.toString(string3.hashCode());
        }
        return "." + string2 + "." + (String)var1_1;
    }

    public static String MD5(String md5) {
        try {
            Object object;
            object = MessageDigest.getInstance("MD5").digest(((String)object).getBytes());
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                stringBuffer.append(Integer.toHexString(object[i2] & 0xFF | 0x100).substring(1, 3));
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            AppboyLogger.i(a, "Failed to calculate MD5 hash", exception);
            return null;
        }
    }
}

