/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.inappmessage.listeners;

import android.content.Context;
import android.os.Bundle;
import com.appboy.Appboy;
import com.appboy.Constants;
import com.appboy.models.IInAppMessage;
import com.appboy.models.InAppMessageHtmlFull;
import com.appboy.models.outgoing.AppboyProperties;
import com.appboy.push.AppboyNotificationUtils;
import com.appboy.support.AppboyLogger;
import com.appboy.support.BundleUtils;
import com.appboy.support.StringUtils;
import com.appboy.ui.actions.ActionFactory;
import com.appboy.ui.actions.IAction;
import com.appboy.ui.inappmessage.AppboyInAppMessageManager;
import com.appboy.ui.inappmessage.listeners.IInAppMessageWebViewClientListener;
import java.util.Map;

public class AppboyInAppMessageWebViewClientListener
implements IInAppMessageWebViewClientListener {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, AppboyInAppMessageWebViewClientListener.class.getName());
    private static final String HTML_IAM_CUSTOM_EVENT_NAME_KEY = "name";

    @Override
    public void onCloseAction(IInAppMessage inAppMessage, String url, Bundle queryBundle) {
        AppboyLogger.d((String)TAG, (String)"IInAppMessageWebViewClientListener.onCloseAction called.");
        this.getInAppMessageManager().hideCurrentInAppMessage(true, true);
        this.getInAppMessageManager().getHtmlInAppMessageActionListener().onCloseClicked(inAppMessage, url, queryBundle);
    }

    @Override
    public void onNewsfeedAction(IInAppMessage inAppMessage, String url, Bundle queryBundle) {
        AppboyLogger.d((String)TAG, (String)"IInAppMessageWebViewClientListener.onNewsfeedAction called.");
        if (this.getInAppMessageManager().getActivity() == null) {
            AppboyLogger.w((String)TAG, (String)"Can't perform news feed action because the cached activity is null.");
            return;
        }
        this.logHtmlInAppMessageClick(inAppMessage, queryBundle);
        boolean handled = this.getInAppMessageManager().getHtmlInAppMessageActionListener().onNewsfeedClicked(inAppMessage, url, queryBundle);
        if (!handled) {
            this.getInAppMessageManager().hideCurrentInAppMessage(false);
            Bundle inAppMessageBundle = BundleUtils.mapToBundle((Map)inAppMessage.getExtras());
            inAppMessageBundle.putAll(queryBundle);
            this.getInAppMessageManager().getAppboyNavigator().gotoNewsFeed((Context)this.getInAppMessageManager().getActivity(), inAppMessageBundle);
        }
    }

    @Override
    public void onCustomEventAction(IInAppMessage inAppMessage, String url, Bundle queryBundle) {
        AppboyLogger.d((String)TAG, (String)"IInAppMessageWebViewClientListener.onCustomEventAction called.");
        if (this.getInAppMessageManager().getActivity() == null) {
            AppboyLogger.w((String)TAG, (String)"Can't perform custom event action because the activity is null.");
            return;
        }
        boolean handled = this.getInAppMessageManager().getHtmlInAppMessageActionListener().onCustomEventFired(inAppMessage, url, queryBundle);
        if (!handled) {
            String customEventName = AppboyInAppMessageWebViewClientListener.parseCustomEventNameFromQueryBundle(queryBundle);
            if (StringUtils.isNullOrBlank((String)customEventName)) {
                return;
            }
            AppboyProperties customEventProperties = AppboyInAppMessageWebViewClientListener.parsePropertiesFromQueryBundle(queryBundle);
            Appboy.getInstance((Context)this.getInAppMessageManager().getActivity()).logCustomEvent(customEventName, customEventProperties);
        }
    }

    @Override
    public void onOtherUrlAction(IInAppMessage inAppMessage, String url, Bundle queryBundle) {
        AppboyLogger.d((String)TAG, (String)"IInAppMessageWebViewClientListener.onOtherUrlAction called.");
        if (this.getInAppMessageManager().getActivity() == null) {
            AppboyLogger.w((String)TAG, (String)"Can't perform other url action because the cached activity is null.");
            return;
        }
        this.logHtmlInAppMessageClick(inAppMessage, queryBundle);
        boolean handled = this.getInAppMessageManager().getHtmlInAppMessageActionListener().onOtherUrlAction(inAppMessage, url, queryBundle);
        if (!handled) {
            IAction urlAction;
            this.getInAppMessageManager().hideCurrentInAppMessage(false);
            boolean doExternalOpen = false;
            if (queryBundle.containsKey("abExternalOpen")) {
                doExternalOpen = Boolean.parseBoolean(queryBundle.getString("abExternalOpen"));
            }
            if (doExternalOpen) {
                Bundle inAppMessageBundle = BundleUtils.mapToBundle((Map)inAppMessage.getExtras());
                inAppMessageBundle.putAll(queryBundle);
                urlAction = ActionFactory.createViewUriAction(url, inAppMessageBundle);
            } else {
                urlAction = ActionFactory.createUriAction((Context)this.getInAppMessageManager().getActivity(), url);
            }
            if (urlAction != null) {
                urlAction.execute((Context)this.getInAppMessageManager().getActivity());
            }
        }
    }

    private AppboyInAppMessageManager getInAppMessageManager() {
        return AppboyInAppMessageManager.getInstance();
    }

    private void logHtmlInAppMessageClick(IInAppMessage inAppMessage, Bundle queryBundle) {
        if (queryBundle != null && queryBundle.containsKey("abButtonId")) {
            InAppMessageHtmlFull inAppMessageHtmlFull = (InAppMessageHtmlFull)inAppMessage;
            inAppMessageHtmlFull.logButtonClick(queryBundle.getString("abButtonId"));
        } else {
            inAppMessage.logClick();
        }
    }

    static String parseCustomEventNameFromQueryBundle(Bundle queryBundle) {
        return queryBundle.getString(HTML_IAM_CUSTOM_EVENT_NAME_KEY);
    }

    static AppboyProperties parsePropertiesFromQueryBundle(Bundle queryBundle) {
        AppboyProperties customEventProperties = new AppboyProperties();
        for (String key : queryBundle.keySet()) {
            String propertyValue;
            if (key.equals(HTML_IAM_CUSTOM_EVENT_NAME_KEY) || StringUtils.isNullOrBlank((String)(propertyValue = AppboyNotificationUtils.bundleOptString(queryBundle, key, null)))) continue;
            customEventProperties.addProperty(key, propertyValue);
        }
        return customEventProperties;
    }
}

