/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.widget;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.appboy.models.cards.Card;
import com.appboy.models.cards.ShortNewsCard;
import com.appboy.ui.R;
import com.appboy.ui.actions.ActionFactory;
import com.appboy.ui.actions.IAction;
import com.appboy.ui.widget.BaseCardView;
import com.facebook.drawee.view.SimpleDraweeView;

public class ShortNewsCardView
extends BaseCardView<ShortNewsCard> {
    private ImageView mImage;
    private SimpleDraweeView mDrawee;
    private final TextView mTitle;
    private final TextView mDescription = (TextView)this.findViewById(R.id.com_appboy_short_news_card_description);
    private final TextView mDomain;
    private IAction mCardAction;
    private final float mAspectRatio = 1.0f;
    private static final String TAG = String.format("%s.%s", "Appboy", ShortNewsCardView.class.getName());

    public ShortNewsCardView(Context context) {
        this(context, null);
    }

    public ShortNewsCardView(Context context, ShortNewsCard card) {
        super(context);
        this.mTitle = (TextView)this.findViewById(R.id.com_appboy_short_news_card_title);
        this.mDomain = (TextView)this.findViewById(R.id.com_appboy_short_news_card_domain);
        if (this.canUseFresco()) {
            this.mDrawee = (SimpleDraweeView)this.getProperViewFromInflatedStub(R.id.com_appboy_short_news_card_drawee_stub);
        } else {
            this.mImage = (ImageView)this.getProperViewFromInflatedStub(R.id.com_appboy_short_news_card_imageview_stub);
        }
        if (card != null) {
            this.setCard(card);
        }
        this.safeSetBackground(this.getResources().getDrawable(R.drawable.com_appboy_card_background));
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.com_appboy_short_news_card;
    }

    @Override
    public void onSetCard(final ShortNewsCard card) {
        this.mDescription.setText((CharSequence)card.getDescription());
        this.setOptionalTextView(this.mTitle, card.getTitle());
        this.setOptionalTextView(this.mDomain, card.getDomain());
        this.mCardAction = ActionFactory.createUriAction(this.getContext(), card.getUrl());
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BaseCardView.handleCardClick(ShortNewsCardView.this.mContext, (Card)card, ShortNewsCardView.this.mCardAction, TAG);
            }
        });
        if (this.canUseFresco()) {
            this.setSimpleDraweeToUrl(this.mDrawee, card.getImageUrl(), 1.0f, true);
        } else {
            this.setImageViewToUrl(this.mImage, card.getImageUrl(), 1.0f);
        }
    }
}

