/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui;

import android.annotation.TargetApi;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.view.ViewGroup;
import android.webkit.DownloadListener;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import com.appboy.Constants;
import com.appboy.support.AppboyLogger;
import com.appboy.ui.R;
import com.appboy.ui.actions.ActionFactory;
import com.appboy.ui.actions.IAction;
import com.appboy.ui.actions.WebAction;
import com.appboy.ui.activities.AppboyBaseActivity;

public class AppboyWebViewActivity
extends AppboyBaseActivity {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, AppboyWebViewActivity.class.getName());
    public static final String URL_EXTRA = "url";

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(2);
        this.requestWindowFeature(5);
        this.setContentView(R.layout.com_appboy_webview_activity);
        this.setProgressBarVisibility(true);
        WebView webView = (WebView)this.findViewById(R.id.com_appboy_webview_activity_webview);
        WebSettings webSettings = webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setAllowFileAccess(false);
        webSettings.setPluginState(WebSettings.PluginState.OFF);
        this.setZoomSafe(webSettings);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setDomStorageEnabled(true);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        webView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        webView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int progress) {
                if (progress < 100) {
                    AppboyWebViewActivity.this.setProgressBarVisibility(true);
                } else {
                    AppboyWebViewActivity.this.setProgressBarVisibility(false);
                }
            }
        });
        webView.setDownloadListener(new DownloadListener(){

            public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
                Intent i = new Intent("android.intent.action.VIEW");
                i.setData(Uri.parse((String)url));
                AppboyWebViewActivity.this.startActivity(i);
            }
        });
        webView.getSettings().setCacheMode(2);
        this.setWebLayerTypeSafe(webView);
        webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                try {
                    if (!WebAction.getSupportedSchemes().contains(Uri.parse((String)url).getScheme())) {
                        IAction action = ActionFactory.createViewUriAction(url, AppboyWebViewActivity.this.getIntent().getExtras());
                        action.execute(view.getContext());
                        AppboyWebViewActivity.this.finish();
                        return true;
                    }
                }
                catch (Exception e) {
                    AppboyLogger.i((String)TAG, (String)String.format("Unexpected exception while processing url %s. Passing url back to WebView.", url), (Throwable)e);
                }
                return super.shouldOverrideUrlLoading(view, url);
            }
        });
        Bundle extras = this.getIntent().getExtras();
        if (extras != null && extras.containsKey(URL_EXTRA)) {
            String url = extras.getString(URL_EXTRA);
            webView.loadUrl(url);
        }
    }

    @TargetApi(value=11)
    private void setZoomSafe(WebSettings webSettings) {
        if (Build.VERSION.SDK_INT >= 11) {
            webSettings.setDisplayZoomControls(false);
        }
    }

    @TargetApi(value=11)
    private void setWebLayerTypeSafe(WebView webView) {
        if (Build.VERSION.SDK_INT >= 11) {
            webView.setLayerType(1, null);
        }
    }
}

