/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.actions;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import com.appboy.ui.actions.IAction;
import com.appboy.ui.support.UriUtils;
import java.util.Map;

public final class ActivityAction
implements IAction {
    private final Intent mIntent;

    public ActivityAction(String packageName, Uri uri) {
        this(packageName, uri, null);
    }

    public ActivityAction(String packageName, Uri uri, Bundle extras) {
        this(new Intent());
        this.mIntent.setClassName(packageName, uri.getHost());
        if (extras != null) {
            this.mIntent.putExtras(extras);
        }
        Map<String, String> parameters = UriUtils.getQueryParameters(uri);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            this.mIntent.putExtra(entry.getKey(), entry.getValue());
        }
    }

    public ActivityAction(Intent intent) {
        this.mIntent = intent;
    }

    @Override
    public void execute(Context context) {
        if (this.mIntent.resolveActivity(context.getPackageManager()) != null) {
            context.startActivity(this.mIntent);
        }
    }
}

