/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.ui.inappmessage;

import android.app.Activity;
import android.net.Uri;
import android.os.AsyncTask;
import com.appboy.Constants;
import com.appboy.models.IInAppMessage;
import com.appboy.models.InAppMessageHtmlBase;
import com.appboy.models.InAppMessageHtmlFull;
import com.appboy.support.AppboyFileUtils;
import com.appboy.support.AppboyImageUtils;
import com.appboy.support.AppboyLogger;
import com.appboy.support.StringUtils;
import com.appboy.support.WebContentUtils;
import com.appboy.ui.inappmessage.AppboyInAppMessageManager;
import com.appboy.ui.support.FrescoLibraryUtils;
import com.facebook.datasource.DataSource;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.File;

public class AppboyAsyncInAppMessageDisplayer
extends AsyncTask<IInAppMessage, Integer, IInAppMessage> {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, AppboyAsyncInAppMessageDisplayer.class.getName());

    protected IInAppMessage doInBackground(IInAppMessage ... inAppMessages) {
        try {
            boolean assetDownloadSucceeded;
            AppboyLogger.d((String)TAG, (String)"Starting asynchronous in-app message preparation.");
            Activity activity = this.getInAppMessageManagerActivity();
            if (activity == null) {
                AppboyLogger.e((String)TAG, (String)"No activity is currently registered to receive in-app messages. Doing nothing.");
                return null;
            }
            IInAppMessage inAppMessage = inAppMessages[0];
            if (inAppMessage instanceof InAppMessageHtmlFull) {
                assetDownloadSucceeded = this.prepareInAppMessageWithHtml(inAppMessage);
            } else {
                String imageUrl = inAppMessage.getImageUrl();
                if (StringUtils.isNullOrBlank((String)imageUrl)) {
                    AppboyLogger.w((String)TAG, (String)"In-app message has no image URL. Not downloading image from URL.");
                    return inAppMessage;
                }
                assetDownloadSucceeded = FrescoLibraryUtils.canUseFresco(activity.getApplicationContext()) ? this.prepareInAppMessageWithFresco(inAppMessage) : this.prepareInAppMessageWithBitmapDownload(inAppMessage);
            }
            if (!assetDownloadSucceeded) {
                return null;
            }
            return inAppMessage;
        }
        catch (Exception e) {
            AppboyLogger.e((String)TAG, (String)"Error running AsyncInAppMessageDisplayer", (Throwable)e);
            return null;
        }
    }

    protected void onPostExecute(final IInAppMessage inAppMessage) {
        try {
            Activity activity = this.getInAppMessageManagerActivity();
            if (activity == null) {
                AppboyLogger.e((String)TAG, (String)"No activity is currently registered to receive in-app messages. Not displayingin-app message.");
                return;
            }
            AppboyLogger.d((String)TAG, (String)"Finished asynchronous in-app message preparation. Attempting to display in-app message.");
            if (inAppMessage != null) {
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        AppboyLogger.d((String)TAG, (String)"Displaying in-app message.");
                        AppboyInAppMessageManager.getInstance().displayInAppMessage(inAppMessage);
                    }
                });
            } else {
                AppboyLogger.e((String)TAG, (String)"Cannot display the in-app message because the in-app message was null.");
            }
        }
        catch (Exception e) {
            AppboyLogger.e((String)TAG, (String)"Error running onPostExecute", (Throwable)e);
        }
    }

    boolean prepareInAppMessageWithHtml(IInAppMessage inAppMessage) {
        Activity activity = this.getInAppMessageManagerActivity();
        if (activity == null) {
            AppboyLogger.e((String)TAG, (String)"Can't store HTML in-app message assets because activity is null.");
            return false;
        }
        InAppMessageHtmlBase inAppMessageHtml = (InAppMessageHtmlBase)inAppMessage;
        if (StringUtils.isNullOrBlank((String)inAppMessageHtml.getAssetsZipRemoteUrl())) {
            AppboyLogger.i((String)TAG, (String)"Html in-app message has no remote asset zip. Continuing with in-app message preparation.");
            return true;
        }
        if (!StringUtils.isNullOrBlank((String)inAppMessageHtml.getLocalAssetsDirectoryUrl())) {
            AppboyLogger.i((String)TAG, (String)"Local assets for html in-app message are already populated. Not downloading assets.");
            return true;
        }
        File internalStorageCacheDirectory = activity.getCacheDir();
        String localWebContentUrl = WebContentUtils.getLocalHtmlUrlFromRemoteUrl((File)internalStorageCacheDirectory, (String)inAppMessageHtml.getAssetsZipRemoteUrl(), (boolean)true);
        if (!StringUtils.isNullOrBlank((String)localWebContentUrl)) {
            AppboyLogger.d((String)TAG, (String)("Local url for html in-app message assets is " + localWebContentUrl));
            inAppMessageHtml.setLocalAssetsDirectoryUrl(localWebContentUrl);
            return true;
        }
        AppboyLogger.w((String)TAG, (String)String.format("Download of html content to local directory failed for remote url: %s . Returned local url is: %s", inAppMessageHtml.getAssetsZipRemoteUrl(), localWebContentUrl));
        return false;
    }

    boolean prepareInAppMessageWithFresco(IInAppMessage inAppMessage) {
        boolean downloadSucceeded;
        String imageUrl = inAppMessage.getImageUrl();
        if (AppboyFileUtils.isLocalUri((Uri)Uri.parse((String)imageUrl))) {
            AppboyLogger.i((String)TAG, (String)"In-app message has local image Uri for Fresco display. Not downloading image.");
            inAppMessage.setImageDownloadSuccessful(true);
            return true;
        }
        ImagePipeline imagePipeline = Fresco.getImagePipeline();
        ImageRequest imageRequest = ImageRequest.fromUri((String)imageUrl);
        DataSource dataSource = imagePipeline.prefetchToDiskCache(imageRequest, new Object());
        while (!dataSource.isFinished()) {
        }
        boolean bl = downloadSucceeded = !dataSource.hasFailed();
        if (downloadSucceeded) {
            inAppMessage.setImageDownloadSuccessful(true);
        } else if (dataSource.getFailureCause() == null) {
            AppboyLogger.w((String)TAG, (String)("Fresco disk prefetch failed with null cause for image url:" + imageUrl));
        } else {
            AppboyLogger.w((String)TAG, (String)("Fresco disk prefetch failed with cause: " + dataSource.getFailureCause().getMessage() + " with image url: " + imageUrl));
        }
        dataSource.close();
        return downloadSucceeded;
    }

    boolean prepareInAppMessageWithBitmapDownload(IInAppMessage inAppMessage) {
        if (inAppMessage.getBitmap() != null) {
            AppboyLogger.i((String)TAG, (String)"In-app message already contains image bitmap. Not downloading image from URL.");
            inAppMessage.setImageDownloadSuccessful(true);
            return true;
        }
        inAppMessage.setBitmap(AppboyImageUtils.getBitmap((Uri)Uri.parse((String)inAppMessage.getImageUrl())));
        if (inAppMessage.getBitmap() != null) {
            inAppMessage.setImageDownloadSuccessful(true);
            return true;
        }
        return false;
    }

    private Activity getInAppMessageManagerActivity() {
        return AppboyInAppMessageManager.getInstance().getActivity();
    }
}

