/*
 * Decompiled with CFR 0.152.
 */
package com.appboy;

import android.app.Notification;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.NotificationManagerCompat;
import android.util.Log;
import com.appboy.Appboy;
import com.appboy.Constants;
import com.appboy.IAppboyNotificationFactory;
import com.appboy.configuration.XmlAppConfigurationProvider;
import com.appboy.push.AppboyNotificationActionUtils;
import com.appboy.push.AppboyNotificationUtils;
import com.appboy.support.AppboyLogger;

public final class AppboyGcmReceiver
extends BroadcastReceiver {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, AppboyGcmReceiver.class.getName());
    private static final String GCM_RECEIVE_INTENT_ACTION = "com.google.android.c2dm.intent.RECEIVE";
    private static final String GCM_REGISTRATION_INTENT_ACTION = "com.google.android.c2dm.intent.REGISTRATION";
    private static final String GCM_ERROR_KEY = "error";
    private static final String GCM_REGISTRATION_ID_KEY = "registration_id";
    private static final String GCM_UNREGISTERED_KEY = "unregistered";
    private static final String GCM_MESSAGE_TYPE_KEY = "message_type";
    private static final String GCM_DELETED_MESSAGES_KEY = "deleted_messages";
    private static final String GCM_NUMBER_OF_MESSAGES_DELETED_KEY = "total_deleted";
    public static final String CAMPAIGN_ID_KEY = "cid";

    public void onReceive(Context context, Intent intent) {
        AppboyLogger.i((String)TAG, (String)String.format("Received broadcast message. Message: %s", intent.toString()));
        String action = intent.getAction();
        if (GCM_REGISTRATION_INTENT_ACTION.equals(action)) {
            this.handleRegistrationEventIfEnabled(new XmlAppConfigurationProvider(context), context, intent);
        } else if (GCM_RECEIVE_INTENT_ACTION.equals(action)) {
            this.handleAppboyGcmReceiveIntent(context, intent);
        } else if ("com.appboy.action.CANCEL_NOTIFICATION".equals(action)) {
            AppboyNotificationUtils.handleCancelNotificationAction(context, intent);
        } else if ("com.appboy.action.APPBOY_ACTION_CLICKED".equals(action)) {
            AppboyNotificationActionUtils.handleNotificationActionClicked(context, intent);
        } else if ("com.appboy.action.APPBOY_PUSH_CLICKED".equals(action)) {
            AppboyNotificationUtils.handleNotificationOpened(context, intent);
        } else {
            AppboyLogger.w((String)TAG, (String)String.format("The GCM receiver received a message not sent from Appboy. Ignoring the message.", new Object[0]));
        }
    }

    boolean handleRegistrationIntent(Context context, Intent intent) {
        String error = intent.getStringExtra(GCM_ERROR_KEY);
        String registrationId = intent.getStringExtra(GCM_REGISTRATION_ID_KEY);
        if (error != null) {
            if ("SERVICE_NOT_AVAILABLE".equals(error)) {
                Log.e((String)TAG, (String)"Unable to connect to the GCM registration server. Try again later.");
            } else if ("ACCOUNT_MISSING".equals(error)) {
                Log.e((String)TAG, (String)"No Google account found on the phone. For pre-3.0 devices, a Google account is required on the device.");
            } else if ("AUTHENTICATION_FAILED".equals(error)) {
                Log.e((String)TAG, (String)"Unable to authenticate Google account. For Android versions <4.0.4, a valid Google Play account is required for Google Cloud Messaging to function. This phone will be unable to receive Google Cloud Messages until the user logs in with a valid Google Play account or upgrades the operating system on this device.");
            } else if ("INVALID_SENDER".equals(error)) {
                Log.e((String)TAG, (String)"One or multiple of the sender IDs provided are invalid.");
            } else if ("PHONE_REGISTRATION_ERROR".equals(error)) {
                Log.e((String)TAG, (String)"Device does not support GCM.");
            } else if ("INVALID_PARAMETERS".equals(error)) {
                Log.e((String)TAG, (String)"The request sent by the device does not contain the expected parameters. This phone does not currently support GCM.");
            } else {
                AppboyLogger.w((String)TAG, (String)String.format("Received an unrecognised GCM registration error type. Ignoring. Error: %s", error));
            }
        } else if (registrationId != null) {
            Appboy.getInstance((Context)context).registerAppboyPushMessages(registrationId);
        } else if (intent.hasExtra(GCM_UNREGISTERED_KEY)) {
            Appboy.getInstance((Context)context).unregisterAppboyPushMessages();
        } else {
            AppboyLogger.w((String)TAG, (String)"The GCM registration message is missing error information, registration id, and unregistration confirmation. Ignoring.");
            return false;
        }
        return true;
    }

    boolean handleAppboyGcmMessage(Context context, Intent intent) {
        NotificationManagerCompat notificationManager = NotificationManagerCompat.from((Context)context);
        String messageType = intent.getStringExtra(GCM_MESSAGE_TYPE_KEY);
        if (GCM_DELETED_MESSAGES_KEY.equals(messageType)) {
            int totalDeleted = intent.getIntExtra(GCM_NUMBER_OF_MESSAGES_DELETED_KEY, -1);
            if (totalDeleted == -1) {
                Log.e((String)TAG, (String)String.format("Unable to parse GCM message. Intent: %s", intent.toString()));
            } else {
                AppboyLogger.i((String)TAG, (String)String.format("GCM deleted %d messages. Fetch them from Appboy.", totalDeleted));
            }
            return false;
        }
        Bundle gcmExtras = intent.getExtras();
        Bundle appboyExtras = AppboyNotificationUtils.getAppboyExtrasWithoutPreprocessing(gcmExtras);
        gcmExtras.putBundle("extra", appboyExtras);
        if (AppboyNotificationUtils.isNotificationMessage(intent)) {
            int notificationId = AppboyNotificationUtils.getNotificationId(gcmExtras);
            gcmExtras.putInt("nid", notificationId);
            XmlAppConfigurationProvider appConfigurationProvider = new XmlAppConfigurationProvider(context);
            Notification notification = null;
            IAppboyNotificationFactory appboyNotificationFactory = AppboyNotificationUtils.getActiveNotificationFactory();
            try {
                notification = appboyNotificationFactory.createNotification(appConfigurationProvider, context, gcmExtras, appboyExtras);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Failed to create notification.", (Throwable)e);
                return false;
            }
            if (notification == null) {
                return false;
            }
            notificationManager.notify("appboy_notification", notificationId, notification);
            AppboyNotificationUtils.sendPushMessageReceivedBroadcast(context, gcmExtras);
            AppboyNotificationUtils.wakeScreenIfHasPermission(context, gcmExtras);
            if (gcmExtras != null && gcmExtras.containsKey("nd")) {
                int durationInMillis = Integer.parseInt(gcmExtras.getString("nd"));
                AppboyNotificationUtils.setNotificationDurationAlarm(context, ((Object)((Object)this)).getClass(), notificationId, durationInMillis);
            }
            return true;
        }
        AppboyNotificationUtils.sendPushMessageReceivedBroadcast(context, gcmExtras);
        return false;
    }

    void handleAppboyGcmReceiveIntent(Context context, Intent intent) {
        if (AppboyNotificationUtils.isAppboyPushMessage(intent)) {
            new HandleAppboyGcmMessageTask(context, intent);
        }
    }

    boolean handleRegistrationEventIfEnabled(XmlAppConfigurationProvider appConfigurationProvider, Context context, Intent intent) {
        if (appConfigurationProvider.isGcmMessagingRegistrationEnabled()) {
            this.handleRegistrationIntent(context, intent);
            return true;
        }
        return false;
    }

    public class HandleAppboyGcmMessageTask
    extends AsyncTask<Void, Void, Void> {
        private final Context context;
        private final Intent intent;

        public HandleAppboyGcmMessageTask(Context context, Intent intent) {
            this.context = context;
            this.intent = intent;
            this.execute(new Void[0]);
        }

        protected Void doInBackground(Void ... voids) {
            AppboyGcmReceiver.this.handleAppboyGcmMessage(this.context, this.intent);
            return null;
        }
    }
}

