/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.push;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.appboy.Constants;
import com.appboy.support.AppboyImageUtils;
import com.appboy.support.AppboyLogger;

public class AppboyNotificationStyleFactory {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, AppboyNotificationStyleFactory.class.getName());
    public static final int BIG_PICTURE_STYLE_IMAGE_HEIGHT = 192;

    @TargetApi(value=16)
    public static NotificationCompat.Style getBigNotificationStyle(Context context, Bundle notificationExtras, Bundle appboyExtras) {
        NotificationCompat.BigPictureStyle style = null;
        if (appboyExtras != null && appboyExtras.containsKey("appboy_image_url")) {
            style = AppboyNotificationStyleFactory.getBigPictureNotificationStyle(context, notificationExtras, appboyExtras);
        }
        if (style == null) {
            AppboyLogger.d((String)TAG, (String)"Rendering push notification with BigTextStyle");
            style = AppboyNotificationStyleFactory.getBigTextNotificationStyle(notificationExtras);
        }
        return style;
    }

    public static NotificationCompat.BigTextStyle getBigTextNotificationStyle(Bundle notificationExtras) {
        if (notificationExtras != null) {
            NotificationCompat.BigTextStyle bigTextNotificationStyle = new NotificationCompat.BigTextStyle();
            bigTextNotificationStyle.bigText((CharSequence)notificationExtras.getString("a"));
            String bigSummary = null;
            String bigTitle = null;
            if (notificationExtras.containsKey("ab_bs")) {
                bigSummary = notificationExtras.getString("ab_bs");
            }
            if (notificationExtras.containsKey("ab_bt")) {
                bigTitle = notificationExtras.getString("ab_bt");
            }
            if (bigSummary != null) {
                bigTextNotificationStyle.setSummaryText((CharSequence)bigSummary);
            }
            if (bigTitle != null) {
                bigTextNotificationStyle.setBigContentTitle((CharSequence)bigTitle);
            }
            return bigTextNotificationStyle;
        }
        return null;
    }

    @TargetApi(value=16)
    public static NotificationCompat.BigPictureStyle getBigPictureNotificationStyle(Context context, Bundle notificationExtras, Bundle appboyExtras) {
        if (appboyExtras == null || !appboyExtras.containsKey("appboy_image_url")) {
            return null;
        }
        String imageUrl = appboyExtras.getString("appboy_image_url");
        if (imageUrl == null) {
            return null;
        }
        Bitmap imageBitmap = AppboyImageUtils.getBitmap((Uri)Uri.parse((String)imageUrl));
        if (imageBitmap == null) {
            return null;
        }
        try {
            if (imageBitmap.getWidth() > imageBitmap.getHeight()) {
                WindowManager windowManager = (WindowManager)context.getSystemService("window");
                DisplayMetrics displayMetrics = new DisplayMetrics();
                windowManager.getDefaultDisplay().getMetrics(displayMetrics);
                int bigPictureHeightPixels = AppboyImageUtils.getPixelsFromDensityAndDp((int)displayMetrics.densityDpi, (int)192);
                int bigPictureWidthPixels = 2 * bigPictureHeightPixels;
                if (bigPictureWidthPixels > displayMetrics.widthPixels) {
                    bigPictureWidthPixels = displayMetrics.widthPixels;
                }
                try {
                    imageBitmap = Bitmap.createScaledBitmap((Bitmap)imageBitmap, (int)bigPictureWidthPixels, (int)bigPictureHeightPixels, (boolean)true);
                }
                catch (Exception e) {
                    AppboyLogger.e((String)TAG, (String)"Failed to scale image bitmap, using original.", (Throwable)e);
                }
            }
            if (imageBitmap == null) {
                AppboyLogger.i((String)TAG, (String)"Bitmap download failed for push notification. No image will be included with the notification.");
                return null;
            }
            NotificationCompat.BigPictureStyle bigPictureNotificationStyle = new NotificationCompat.BigPictureStyle();
            bigPictureNotificationStyle.bigPicture(imageBitmap);
            AppboyNotificationStyleFactory.setBigPictureSummaryAndTitle(bigPictureNotificationStyle, notificationExtras);
            return bigPictureNotificationStyle;
        }
        catch (Exception e) {
            AppboyLogger.e((String)TAG, (String)"Failed to create Big Picture Style.", (Throwable)e);
            return null;
        }
    }

    static void setBigPictureSummaryAndTitle(NotificationCompat.BigPictureStyle bigPictureNotificationStyle, Bundle notificationExtras) {
        String summaryText;
        String bigSummary = null;
        String bigTitle = null;
        if (notificationExtras.containsKey("ab_bs")) {
            bigSummary = notificationExtras.getString("ab_bs");
        }
        if (notificationExtras.containsKey("ab_bt")) {
            bigTitle = notificationExtras.getString("ab_bt");
        }
        if (bigSummary != null) {
            bigPictureNotificationStyle.setSummaryText((CharSequence)bigSummary);
        }
        if (bigTitle != null) {
            bigPictureNotificationStyle.setBigContentTitle((CharSequence)bigTitle);
        }
        if ((summaryText = notificationExtras.getString("s")) == null && bigSummary == null) {
            bigPictureNotificationStyle.setSummaryText((CharSequence)notificationExtras.getString("a"));
        }
    }
}

