/*
 * Decompiled with CFR 0.152.
 */
package com.appboy;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import com.appboy.Appboy;
import com.appboy.Constants;
import com.appboy.IAppboyNotificationFactory;
import com.appboy.configuration.XmlAppConfigurationProvider;
import com.appboy.push.AppboyNotificationActionUtils;
import com.appboy.push.AppboyNotificationUtils;
import com.appboy.support.AppboyLogger;

public final class AppboyAdmReceiver
extends BroadcastReceiver {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, AppboyAdmReceiver.class.getName());
    private static final String ADM_RECEIVE_INTENT_ACTION = "com.amazon.device.messaging.intent.RECEIVE";
    private static final String ADM_REGISTRATION_INTENT_ACTION = "com.amazon.device.messaging.intent.REGISTRATION";
    private static final String ADM_ERROR_KEY = "error";
    private static final String ADM_REGISTRATION_ID_KEY = "registration_id";
    private static final String ADM_UNREGISTERED_KEY = "unregistered";
    private static final String ADM_MESSAGE_TYPE_KEY = "message_type";
    private static final String ADM_DELETED_MESSAGES_KEY = "deleted_messages";
    private static final String ADM_NUMBER_OF_MESSAGES_DELETED_KEY = "total_deleted";
    public static final String CAMPAIGN_ID_KEY = "cid";

    public void onReceive(Context context, Intent intent) {
        AppboyLogger.i((String)TAG, (String)String.format("Received broadcast message. Message: %s", intent.toString()));
        String action = intent.getAction();
        if (ADM_REGISTRATION_INTENT_ACTION.equals(action)) {
            this.handleRegistrationEventIfEnabled(new XmlAppConfigurationProvider(context), context, intent);
        } else if (ADM_RECEIVE_INTENT_ACTION.equals(action)) {
            this.handleAppboyAdmReceiveIntent(context, intent);
        } else if ("com.appboy.action.CANCEL_NOTIFICATION".equals(action)) {
            AppboyNotificationUtils.handleCancelNotificationAction(context, intent);
        } else if ("com.appboy.action.APPBOY_ACTION_CLICKED".equals(action)) {
            AppboyNotificationActionUtils.handleNotificationActionClicked(context, intent);
        } else if ("com.appboy.action.APPBOY_PUSH_CLICKED".equals(action)) {
            AppboyNotificationUtils.handleNotificationOpened(context, intent);
        } else {
            AppboyLogger.w((String)TAG, (String)String.format("The ADM receiver received a message not sent from Appboy. Ignoring the message.", new Object[0]));
        }
    }

    boolean handleRegistrationIntent(Context context, Intent intent) {
        String error = intent.getStringExtra(ADM_ERROR_KEY);
        String registrationId = intent.getStringExtra(ADM_REGISTRATION_ID_KEY);
        String unregistered = intent.getStringExtra(ADM_UNREGISTERED_KEY);
        if (error != null) {
            AppboyLogger.e((String)TAG, (String)("Error during ADM registration: " + error));
        } else if (registrationId != null) {
            AppboyLogger.i((String)TAG, (String)("Registering for ADM messages with registrationId: " + registrationId));
            Appboy.getInstance((Context)context).registerAppboyPushMessages(registrationId);
        } else if (unregistered != null) {
            AppboyLogger.i((String)TAG, (String)("Unregistering from ADM: " + unregistered));
            Appboy.getInstance((Context)context).unregisterAppboyPushMessages();
        } else {
            AppboyLogger.w((String)TAG, (String)"The ADM registration intent is missing error information, registration id, and unregistration confirmation. Ignoring.");
            return false;
        }
        return true;
    }

    boolean handleAppboyAdmMessage(Context context, Intent intent) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        String messageType = intent.getStringExtra(ADM_MESSAGE_TYPE_KEY);
        if (ADM_DELETED_MESSAGES_KEY.equals(messageType)) {
            int totalDeleted = intent.getIntExtra(ADM_NUMBER_OF_MESSAGES_DELETED_KEY, -1);
            if (totalDeleted == -1) {
                AppboyLogger.e((String)TAG, (String)String.format("Unable to parse ADM message. Intent: %s", intent.toString()));
            } else {
                AppboyLogger.i((String)TAG, (String)String.format("ADM deleted %d messages. Fetch them from Appboy.", totalDeleted));
            }
            return false;
        }
        Bundle admExtras = intent.getExtras();
        Bundle appboyExtras = AppboyNotificationUtils.getAppboyExtrasWithoutPreprocessing(admExtras);
        admExtras.putBundle("extra", appboyExtras);
        if (AppboyNotificationUtils.isNotificationMessage(intent)) {
            int notificationId = AppboyNotificationUtils.getNotificationId(admExtras);
            admExtras.putInt("nid", notificationId);
            XmlAppConfigurationProvider appConfigurationProvider = new XmlAppConfigurationProvider(context);
            Notification notification = null;
            IAppboyNotificationFactory appboyNotificationFactory = AppboyNotificationUtils.getActiveNotificationFactory();
            try {
                notification = appboyNotificationFactory.createNotification(appConfigurationProvider, context, admExtras, appboyExtras);
            }
            catch (Exception e) {
                AppboyLogger.e((String)TAG, (String)"Failed to create notification.", (Throwable)e);
                return false;
            }
            if (notification == null) {
                return false;
            }
            notificationManager.notify("appboy_notification", notificationId, notification);
            AppboyNotificationUtils.sendPushMessageReceivedBroadcast(context, admExtras);
            AppboyNotificationUtils.wakeScreenIfHasPermission(context, admExtras);
            if (admExtras.containsKey("nd")) {
                int durationInMillis = Integer.parseInt(admExtras.getString("nd"));
                AppboyNotificationUtils.setNotificationDurationAlarm(context, ((Object)((Object)this)).getClass(), notificationId, durationInMillis);
            }
            return true;
        }
        AppboyNotificationUtils.sendPushMessageReceivedBroadcast(context, admExtras);
        return false;
    }

    void handleAppboyAdmReceiveIntent(Context context, Intent intent) {
        if (AppboyNotificationUtils.isAppboyPushMessage(intent)) {
            new HandleAppboyAdmMessageTask(context, intent);
        }
    }

    boolean handleRegistrationEventIfEnabled(XmlAppConfigurationProvider appConfigurationProvider, Context context, Intent intent) {
        AppboyLogger.i((String)TAG, (String)String.format("Received ADM registration. Message: %s", intent.toString()));
        if (appConfigurationProvider.isAdmMessagingRegistrationEnabled()) {
            AppboyLogger.d((String)TAG, (String)"ADM enabled in appboy.xml. Continuing to process ADM registration intent.");
            this.handleRegistrationIntent(context, intent);
            return true;
        }
        AppboyLogger.w((String)TAG, (String)"ADM not enabled in appboy.xml. Ignoring ADM registration intent. Note: you must set com_appboy_push_adm_messaging_registration_enabled to true in your appboy.xml to enable ADM.");
        return false;
    }

    public class HandleAppboyAdmMessageTask
    extends AsyncTask<Void, Void, Void> {
        private final Context context;
        private final Intent intent;

        public HandleAppboyAdmMessageTask(Context context, Intent intent) {
            this.context = context;
            this.intent = intent;
            this.execute(new Void[0]);
        }

        protected Void doInBackground(Void ... voids) {
            AppboyAdmReceiver.this.handleAppboyAdmMessage(this.context, this.intent);
            return null;
        }
    }
}

