/*
 * Decompiled with CFR 0.152.
 */
package com.appboy.push;

import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.NotificationCompat;
import com.appboy.Appboy;
import com.appboy.Constants;
import com.appboy.push.AppboyNotificationUtils;
import com.appboy.support.AppboyImageUtils;
import com.appboy.support.AppboyLogger;
import com.appboy.support.IntentUtils;
import com.appboy.support.PackageUtils;
import com.appboy.support.PermissionUtils;
import com.appboy.support.StringUtils;

public class AppboyNotificationActionUtils {
    private static final String TAG = String.format("%s.%s", Constants.APPBOY_LOG_TAG_PREFIX, AppboyNotificationActionUtils.class.getName());
    public static final String DEFAULT_LOCAL_STORAGE_FOLDER = "Shared Photos";
    public static final String IMAGE_MIME_TYPE = "image/*";
    public static final String TEXT_MIME_TYPE = "text/plain";

    @TargetApi(value=16)
    public static void addNotificationActions(Context context, NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        try {
            if (notificationExtras == null) {
                AppboyLogger.w((String)TAG, (String)String.format("Notification extras were null. Doing nothing.", new Object[0]));
                return;
            }
            if (Build.VERSION.SDK_INT < 16) {
                return;
            }
            int actionIndex = 0;
            while (!StringUtils.isNullOrBlank((String)AppboyNotificationActionUtils.getActionFieldAtIndex(actionIndex, notificationExtras, "ab_a*_a"))) {
                AppboyNotificationActionUtils.addNotificationAction(context, notificationBuilder, notificationExtras, actionIndex);
                ++actionIndex;
            }
        }
        catch (Exception e) {
            AppboyLogger.e((String)TAG, (String)String.format("Caught exception while adding notification action buttons.", e));
        }
    }

    @TargetApi(value=16)
    public static void handleNotificationActionClicked(Context context, Intent intent) {
        try {
            String actionType = intent.getStringExtra("appboy_action_type");
            if (StringUtils.isNullOrBlank((String)actionType)) {
                AppboyLogger.w((String)TAG, (String)String.format("Notification action button type was blank or null.  Doing nothing.", new Object[0]));
                return;
            }
            int notificationId = intent.getIntExtra("nid", -1);
            if (!actionType.equals("ab_none")) {
                AppboyNotificationActionUtils.logNotificationActionClicked(context, intent);
            }
            if (actionType.equals("ab_uri") || actionType.equals("ab_open")) {
                AppboyNotificationUtils.cancelNotification(context, notificationId);
                context.sendBroadcast(new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS"));
                if (actionType.equals("ab_uri") && intent.getExtras().containsKey("appboy_action_uri")) {
                    intent.putExtra("uri", intent.getStringExtra("appboy_action_uri"));
                } else {
                    intent.removeExtra("uri");
                }
                AppboyNotificationUtils.sendNotificationOpenedBroadcast(context, intent);
            } else if (actionType.equals("ab_share")) {
                AppboyNotificationUtils.cancelNotification(context, notificationId);
                context.sendBroadcast(new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS"));
                AppboyNotificationActionUtils.handleShareActionClicked(context, intent);
            } else if (actionType.equals("ab_none")) {
                AppboyNotificationUtils.cancelNotification(context, notificationId);
            } else {
                AppboyLogger.i((String)TAG, (String)String.format("Custom notification action button clicked. Doing nothing and passing on data to client receiver.", new Object[0]));
                AppboyNotificationUtils.sendNotificationOpenedBroadcast(context, intent);
            }
        }
        catch (Exception e) {
            AppboyLogger.e((String)TAG, (String)String.format("Caught exception while handling notification action button click.", e));
        }
    }

    static boolean canShareImage(Context context, Bundle appboyExtras) {
        return appboyExtras != null && appboyExtras.containsKey("appboy_image_url") && PermissionUtils.hasPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
    }

    static int getIconDrawableResourceId(Context context, String iconDrawableName) {
        if (context == null) {
            return 0;
        }
        if (!StringUtils.isNullOrBlank((String)iconDrawableName)) {
            return context.getResources().getIdentifier(iconDrawableName, "drawable", PackageUtils.getResourcePackageName((Context)context));
        }
        return 0;
    }

    static boolean isCustomActionType(String actionType) {
        if (actionType.equals("ab_uri")) {
            return false;
        }
        if (actionType.equals("ab_open")) {
            return false;
        }
        if (actionType.equals("ab_none")) {
            return false;
        }
        return !actionType.equals("ab_share");
    }

    @TargetApi(value=16)
    private static void addNotificationAction(Context context, NotificationCompat.Builder notificationBuilder, Bundle notificationExtras, int actionIndex) {
        Bundle notificationActionExtras = new Bundle(notificationExtras);
        String actionType = AppboyNotificationActionUtils.getActionFieldAtIndex(actionIndex, notificationExtras, "ab_a*_a");
        notificationActionExtras.putInt("appboy_action_index", actionIndex);
        notificationActionExtras.putString("appboy_action_type", actionType);
        notificationActionExtras.putString("appboy_action_id", AppboyNotificationActionUtils.getActionFieldAtIndex(actionIndex, notificationExtras, "ab_a*_id"));
        notificationActionExtras.putString("appboy_action_uri", AppboyNotificationActionUtils.getActionFieldAtIndex(actionIndex, notificationExtras, "ab_a*_uri"));
        notificationActionExtras.putBoolean("appboy_is_custom_action", AppboyNotificationActionUtils.isCustomActionType(actionType));
        String iconDrawableName = AppboyNotificationActionUtils.getActionFieldAtIndex(actionIndex, notificationExtras, "ab_a*_ic");
        notificationActionExtras.putString("appboy_action_icon", AppboyNotificationActionUtils.getActionFieldAtIndex(actionIndex, notificationExtras, "ab_a*_ic"));
        Intent sendIntent = new Intent("com.appboy.action.APPBOY_ACTION_CLICKED").setClass(context, AppboyNotificationUtils.getNotificationReceiverClass());
        sendIntent.putExtras(notificationActionExtras);
        String actionText = AppboyNotificationActionUtils.getActionFieldAtIndex(actionIndex, notificationExtras, "ab_a*_t");
        PendingIntent pendingSendIntent = PendingIntent.getBroadcast((Context)context, (int)IntentUtils.getRequestCode(), (Intent)sendIntent, (int)0x8000000);
        int iconDrawableResourceId = AppboyNotificationActionUtils.getIconDrawableResourceId(context, iconDrawableName);
        NotificationCompat.Action.Builder notificationActionBuilder = new NotificationCompat.Action.Builder(iconDrawableResourceId, (CharSequence)actionText, pendingSendIntent);
        notificationActionBuilder.addExtras(new Bundle(notificationActionExtras));
        notificationBuilder.addAction(notificationActionBuilder.build());
    }

    private static void logNotificationActionClicked(Context context, Intent intent) {
        String campaignId = intent.getStringExtra("cid");
        String actionButtonId = intent.getStringExtra("appboy_action_id");
        if (StringUtils.isNullOrBlank((String)campaignId)) {
            AppboyLogger.i((String)TAG, (String)String.format("No campaign Id associated with this notification.  Not logging push action click to Appboy.", new Object[0]));
            return;
        }
        if (StringUtils.isNullOrBlank((String)actionButtonId)) {
            AppboyLogger.i((String)TAG, (String)String.format("No action button Id associated with this notification action.  Not logging push action click to Appboy.", new Object[0]));
            return;
        }
        AppboyLogger.i((String)TAG, (String)String.format("Logging push action click to Appboy. Campaign Id: " + campaignId + " Action Button Id: " + actionButtonId, new Object[0]));
        Appboy.getInstance((Context)context).logPushNotificationActionClicked(campaignId, actionButtonId);
    }

    private static void handleShareActionClicked(Context context, Intent intent) {
        new ShareTask(context).execute(new Intent[]{intent});
    }

    private static Intent createShareActionIntent(Context context, Intent intent) {
        Bundle notificationExtras = intent.getExtras();
        Intent shareIntent = new Intent("android.intent.action.SEND");
        shareIntent.putExtra("android.intent.extra.SUBJECT", notificationExtras.getString("t"));
        shareIntent.putExtra("android.intent.extra.TEXT", notificationExtras.getString("a"));
        Bundle appboyExtras = notificationExtras.getBundle("extra");
        if (AppboyNotificationActionUtils.canShareImage(context, appboyExtras)) {
            String fileName = Long.toString(System.currentTimeMillis());
            String imageUrl = appboyExtras.getString("appboy_image_url");
            Bitmap imageBitmap = AppboyImageUtils.getBitmap((Uri)Uri.parse((String)imageUrl));
            Uri localImageUri = AppboyImageUtils.storeBitmap((Context)context.getApplicationContext(), (Bitmap)imageBitmap, (String)fileName, (String)DEFAULT_LOCAL_STORAGE_FOLDER, (boolean)true);
            shareIntent.setType(IMAGE_MIME_TYPE);
            shareIntent.putExtra("android.intent.extra.STREAM", (Parcelable)localImageUri);
            shareIntent.addFlags(1);
        } else {
            shareIntent.setType(TEXT_MIME_TYPE);
        }
        shareIntent.setFlags(0x10000000);
        return shareIntent;
    }

    static String getActionFieldAtIndex(int actionIndex, Bundle notificationExtras, String actionFieldKeyTemplate) {
        String actionFieldKey = actionFieldKeyTemplate.replace("*", String.valueOf(actionIndex));
        String actionFieldValue = notificationExtras.getString(actionFieldKey);
        if (actionFieldValue == null) {
            return "";
        }
        return actionFieldValue;
    }

    private static class ShareTask
    extends AsyncTask<Intent, Integer, Intent> {
        private final Context mContext;

        public ShareTask(Context context) {
            this.mContext = context;
        }

        protected Intent doInBackground(Intent ... intents) {
            if (this.mContext != null) {
                return AppboyNotificationActionUtils.createShareActionIntent(this.mContext, intents[0]);
            }
            return null;
        }

        protected void onPostExecute(Intent shareIntent) {
            if (shareIntent != null && this.mContext != null) {
                if (shareIntent != null) {
                    this.mContext.startActivity(shareIntent);
                } else {
                    AppboyLogger.w((String)TAG, (String)"Null share intent received.  Not starting share intent.");
                }
            }
        }
    }
}

