/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.kits;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.appboy.Appboy;
import com.appboy.AppboyGcmReceiver;
import com.appboy.AppboyUser;
import com.appboy.enums.Gender;
import com.appboy.models.outgoing.AppboyProperties;
import com.appboy.push.AppboyNotificationUtils;
import com.mparticle.MPEvent;
import com.mparticle.MParticle;
import com.mparticle.commerce.CommerceEvent;
import com.mparticle.commerce.Product;
import com.mparticle.internal.ConfigManager;
import com.mparticle.kits.CommerceEventUtils;
import com.mparticle.kits.KitIntegration;
import com.mparticle.kits.KitUtils;
import com.mparticle.kits.ReportingMessage;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AppboyKit
extends KitIntegration
implements KitIntegration.ActivityListener,
KitIntegration.AttributeListener,
KitIntegration.CommerceListener,
KitIntegration.EventListener,
KitIntegration.PushListener {
    static final String APPBOY_KEY = "apiKey";
    public static final String PUSH_ENABLED = "push_enabled";
    private static final String PREF_KEY_HAS_SYNCED_ATTRIBUTES = "appboy::has_synced_attributes";

    public String getName() {
        return "Appboy";
    }

    protected List<ReportingMessage> onKitCreate(Map<String, String> settings, Context context) {
        String key = settings.get(APPBOY_KEY);
        if (KitUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("Appboy key is empty.");
        }
        Appboy.configure((Context)context, (String)key);
        return null;
    }

    public List<ReportingMessage> setOptOut(boolean optedOut) {
        return null;
    }

    public List<ReportingMessage> leaveBreadcrumb(String breadcrumb) {
        return null;
    }

    public List<ReportingMessage> logError(String message, Map<String, String> errorAttributes) {
        return null;
    }

    public List<ReportingMessage> logException(Exception exception, Map<String, String> exceptionAttributes, String message) {
        return null;
    }

    public List<ReportingMessage> logEvent(MPEvent event) {
        if (event.getInfo() == null) {
            Appboy.getInstance((Context)this.getContext()).logCustomEvent(event.getEventName());
        } else {
            AppboyProperties properties = new AppboyProperties();
            for (Map.Entry entry : event.getInfo().entrySet()) {
                properties.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
            Appboy.getInstance((Context)this.getContext()).logCustomEvent(event.getEventName(), properties);
        }
        LinkedList<ReportingMessage> messages = new LinkedList<ReportingMessage>();
        messages.add(ReportingMessage.fromEvent((KitIntegration)this, (MPEvent)event));
        return messages;
    }

    public List<ReportingMessage> logScreen(String screenName, Map<String, String> screenAttributes) {
        return null;
    }

    public List<ReportingMessage> logLtvIncrease(BigDecimal valueIncreased, BigDecimal valueTotal, String eventName, Map<String, String> contextInfo) {
        return null;
    }

    public List<ReportingMessage> logEvent(CommerceEvent event) {
        LinkedList<ReportingMessage> messages = new LinkedList<ReportingMessage>();
        if (!KitUtils.isEmpty((CharSequence)event.getProductAction()) && event.getProductAction().equalsIgnoreCase("purchase") && event.getProducts().size() > 0) {
            List productList = event.getProducts();
            for (Product product : productList) {
                this.logTransaction(event, product);
            }
            messages.add(ReportingMessage.fromEvent((KitIntegration)this, (CommerceEvent)event));
            return messages;
        }
        List eventList = CommerceEventUtils.expand((CommerceEvent)event);
        if (eventList != null) {
            for (int i = 0; i < eventList.size(); ++i) {
                try {
                    this.logEvent((MPEvent)eventList.get(i));
                    messages.add(ReportingMessage.fromEvent((KitIntegration)this, (CommerceEvent)event));
                    continue;
                }
                catch (Exception e) {
                    ConfigManager.log((MParticle.LogLevel)MParticle.LogLevel.WARNING, (String[])new String[]{"Failed to call logCustomEvent to Appboy kit: " + e.toString()});
                }
            }
        }
        return messages;
    }

    public void setUserAttribute(String key, String value) {
        AppboyUser user = Appboy.getInstance((Context)this.getContext()).getCurrentUser();
        if ("$City".equals(key)) {
            user.setHomeCity(value);
        } else if ("$Country".equals(key)) {
            user.setCountry(value);
        } else if ("$FirstName".equals(key)) {
            user.setFirstName(value);
        } else if ("$Gender".equals(key)) {
            if (value.contains("fe")) {
                user.setGender(Gender.FEMALE);
            } else {
                user.setGender(Gender.MALE);
            }
        } else if ("$LastName".equals(key)) {
            user.setLastName(value);
        } else if ("$Mobile".equals(key)) {
            user.setPhoneNumber(value);
        } else {
            if (key.startsWith("$")) {
                key = key.substring(1);
            }
            user.setCustomUserAttribute(key, value);
        }
    }

    public void setUserAttributeList(String key, List<String> list) {
        AppboyUser user = Appboy.getInstance((Context)this.getContext()).getCurrentUser();
        String[] array = list.toArray(new String[list.size()]);
        user.setCustomAttributeArray(key, array);
    }

    public boolean supportsAttributeLists() {
        return true;
    }

    public void setAllUserAttributes(Map<String, String> attributes, Map<String, List<String>> attributeLists) {
        if (!this.getKitPreferences().getBoolean(PREF_KEY_HAS_SYNCED_ATTRIBUTES, false)) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                this.setUserAttribute(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : attributeLists.entrySet()) {
                this.setUserAttributeList(entry.getKey(), (List)entry.getValue());
            }
            this.getKitPreferences().edit().putBoolean(PREF_KEY_HAS_SYNCED_ATTRIBUTES, true).apply();
        }
    }

    public void removeUserAttribute(String key) {
        AppboyUser user = Appboy.getInstance((Context)this.getContext()).getCurrentUser();
        if ("$City".equals(key)) {
            user.setHomeCity(null);
        } else if ("$Country".equals(key)) {
            user.setCountry(null);
        } else if ("$FirstName".equals(key)) {
            user.setFirstName(null);
        } else if ("$Gender".equals(key)) {
            user.setGender(null);
        } else if ("$LastName".equals(key)) {
            user.setLastName(null);
        } else if ("$Mobile".equals(key)) {
            user.setPhoneNumber(null);
        } else {
            if (key.startsWith("$")) {
                key = key.substring(1);
            }
            user.unsetCustomUserAttribute(key);
        }
    }

    public void setUserIdentity(MParticle.IdentityType identityType, String identity) {
        AppboyUser user = Appboy.getInstance((Context)this.getContext()).getCurrentUser();
        if (MParticle.IdentityType.CustomerId.equals((Object)identityType)) {
            if (user == null || user.getUserId() != null && !user.getUserId().equals(identity)) {
                Appboy.getInstance((Context)this.getContext()).changeUser(identity);
            }
        } else if (MParticle.IdentityType.Email.equals((Object)identityType)) {
            user.setEmail(identity);
        }
    }

    public void removeUserIdentity(MParticle.IdentityType identityType) {
    }

    public List<ReportingMessage> logout() {
        return null;
    }

    private void logTransaction(CommerceEvent event, Product product) {
        AppboyProperties purchaseProperties = new AppboyProperties();
        HashMap eventAttributes = new HashMap();
        CommerceEventUtils.extractActionAttributes((CommerceEvent)event, eventAttributes);
        String currency = (String)eventAttributes.get("Currency Code");
        if (KitUtils.isEmpty((CharSequence)currency)) {
            currency = "USD";
        }
        eventAttributes.remove("Currency Code");
        for (Map.Entry entry : eventAttributes.entrySet()) {
            purchaseProperties.addProperty((String)entry.getKey(), (String)entry.getValue());
        }
        Appboy.getInstance((Context)this.getContext()).logPurchase(product.getSku(), currency, new BigDecimal(product.getUnitPrice()), (int)product.getQuantity(), purchaseProperties);
    }

    public List<ReportingMessage> onActivityStopped(Activity activity) {
        Appboy.getInstance((Context)activity).closeSession(activity);
        LinkedList<ReportingMessage> messageList = new LinkedList<ReportingMessage>();
        messageList.add(new ReportingMessage((KitIntegration)this, "ast", System.currentTimeMillis(), null));
        return messageList;
    }

    public List<ReportingMessage> onActivitySaveInstanceState(Activity activity, Bundle outState) {
        return null;
    }

    public List<ReportingMessage> onActivityDestroyed(Activity activity) {
        return null;
    }

    public List<ReportingMessage> onActivityCreated(Activity activity, Bundle savedInstanceState) {
        return null;
    }

    public List<ReportingMessage> onActivityStarted(Activity activity) {
        Appboy.getInstance((Context)activity).openSession(activity);
        LinkedList<ReportingMessage> messageList = new LinkedList<ReportingMessage>();
        messageList.add(new ReportingMessage((KitIntegration)this, "ast", System.currentTimeMillis(), null));
        return messageList;
    }

    public List<ReportingMessage> onActivityResumed(Activity activity) {
        return null;
    }

    public List<ReportingMessage> onActivityPaused(Activity activity) {
        return null;
    }

    public boolean willHandlePushMessage(Intent intent) {
        if (!Boolean.parseBoolean((String)this.getSettings().get(PUSH_ENABLED))) {
            return false;
        }
        return AppboyNotificationUtils.isAppboyPushMessage((Intent)intent);
    }

    public void onPushMessageReceived(Context context, Intent pushIntent) {
        if (Boolean.parseBoolean((String)this.getSettings().get(PUSH_ENABLED))) {
            new AppboyGcmReceiver().onReceive(context, pushIntent);
        }
    }

    public boolean onPushRegistration(String instanceId, String senderId) {
        if (Boolean.parseBoolean((String)this.getSettings().get(PUSH_ENABLED))) {
            Appboy.getInstance((Context)this.getContext()).registerAppboyGcmMessages(instanceId);
            return true;
        }
        return false;
    }
}

